/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Bandwidth;
import org.onlab.util.KryoNamespace;
import org.onlab.util.PositionalParameterStringFormatter;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.OmsPort;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceAllocationException;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceAllocation;
import org.onosproject.net.resource.link.LambdaResource;
import org.onosproject.net.resource.link.LambdaResourceAllocation;
import org.onosproject.net.resource.link.LinkResourceAllocations;
import org.onosproject.net.resource.link.LinkResourceEvent;
import org.onosproject.net.resource.link.LinkResourceStore;
import org.onosproject.net.resource.link.LinkResourceStoreDelegate;
import org.onosproject.net.resource.link.MplsLabel;
import org.onosproject.net.resource.link.MplsLabelResourceAllocation;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionException;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class ConsistentLinkResourceStore
extends AbstractStore<LinkResourceEvent, LinkResourceStoreDelegate>
implements LinkResourceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final BandwidthResource DEFAULT_BANDWIDTH = new BandwidthResource(Bandwidth.mbps((double)1000.0));
    private static final BandwidthResource EMPTY_BW = new BandwidthResource(Bandwidth.bps((double)0.0));
    private static final int MIN_UNRESERVED_LABEL = 16;
    private static final int MAX_UNRESERVED_LABEL = 239;
    private static final String LINK_RESOURCE_ALLOCATIONS = "LinkAllocations";
    private static final String INTENT_ALLOCATIONS = "LinkIntentAllocations";
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespaces.API);
    private ConsistentMap<IntentId, LinkResourceAllocations> intentAllocMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.intentAllocMap = this.storageService.consistentMapBuilder().withName(INTENT_ALLOCATIONS).withSerializer(SERIALIZER).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private TransactionalMap<IntentId, LinkResourceAllocations> getIntentAllocs(TransactionContext tx) {
        return tx.getTransactionalMap(INTENT_ALLOCATIONS, SERIALIZER);
    }

    private TransactionalMap<LinkKey, List<LinkResourceAllocations>> getLinkAllocs(TransactionContext tx) {
        return tx.getTransactionalMap(LINK_RESOURCE_ALLOCATIONS, SERIALIZER);
    }

    private TransactionContext getTxContext() {
        return this.storageService.transactionContextBuilder().build();
    }

    private Set<? extends ResourceAllocation> getResourceCapacity(ResourceType type, Link link) {
        if (type == ResourceType.BANDWIDTH) {
            return ImmutableSet.of((Object)this.getBandwidthResourceCapacity(link));
        }
        if (type == ResourceType.LAMBDA) {
            return this.getLambdaResourceCapacity(link);
        }
        if (type == ResourceType.MPLS_LABEL) {
            return this.getMplsResourceCapacity();
        }
        return ImmutableSet.of();
    }

    private Set<LambdaResourceAllocation> getLambdaResourceCapacity(Link link) {
        HashSet<LambdaResourceAllocation> allocations = new HashSet<LambdaResourceAllocation>();
        Port port = this.deviceService.getPort(link.src().deviceId(), link.src().port());
        if (port instanceof OmsPort) {
            OmsPort omsPort = (OmsPort)port;
            for (int i = 0; i < omsPort.totalChannels(); ++i) {
                allocations.add(new LambdaResourceAllocation(LambdaResource.valueOf((int)i)));
            }
        }
        return allocations;
    }

    private BandwidthResourceAllocation getBandwidthResourceCapacity(Link link) {
        BandwidthResource bandwidth = null;
        String strBw = link.annotations().value("bandwidth");
        if (strBw != null) {
            try {
                bandwidth = new BandwidthResource(Bandwidth.mbps((double)Double.parseDouble(strBw)));
            }
            catch (NumberFormatException e) {
                bandwidth = null;
            }
        }
        if (bandwidth == null) {
            bandwidth = DEFAULT_BANDWIDTH;
        }
        return new BandwidthResourceAllocation(bandwidth);
    }

    private Set<MplsLabelResourceAllocation> getMplsResourceCapacity() {
        HashSet<MplsLabelResourceAllocation> allocations = new HashSet<MplsLabelResourceAllocation>();
        for (int i = 16; i <= 239; ++i) {
            allocations.add(new MplsLabelResourceAllocation(MplsLabel.valueOf((int)i)));
        }
        return allocations;
    }

    private Map<ResourceType, Set<? extends ResourceAllocation>> getResourceCapacity(Link link) {
        HashMap<ResourceType, Set<? extends ResourceAllocation>> caps = new HashMap<ResourceType, Set<? extends ResourceAllocation>>();
        for (ResourceType type : ResourceType.values()) {
            Set<? extends ResourceAllocation> cap = this.getResourceCapacity(type, link);
            if (cap == null) continue;
            caps.put(type, cap);
        }
        return caps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceAllocation> getFreeResources(Link link) {
        TransactionContext tx = this.getTxContext();
        tx.begin();
        try {
            Map<ResourceType, Set<? extends ResourceAllocation>> freeResources = this.getFreeResourcesEx(tx, link);
            HashSet<ResourceAllocation> allFree = new HashSet<ResourceAllocation>();
            freeResources.values().forEach(allFree::addAll);
            HashSet<ResourceAllocation> hashSet = allFree;
            return hashSet;
        }
        finally {
            tx.abort();
        }
    }

    private Map<ResourceType, Set<? extends ResourceAllocation>> getFreeResourcesEx(TransactionContext tx, Link link) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)link);
        HashMap<ResourceType, Set<? extends ResourceAllocation>> free = new HashMap<ResourceType, Set<? extends ResourceAllocation>>();
        Map<ResourceType, Set<? extends ResourceAllocation>> caps = this.getResourceCapacity(link);
        Iterable<LinkResourceAllocations> allocations = this.getAllocations(tx, link);
        block5: for (ResourceType type : ResourceType.values()) {
            switch (type) {
                case BANDWIDTH: {
                    HashSet bw = caps.get(type);
                    if (bw == null || bw.isEmpty()) {
                        bw = Sets.newHashSet((Object[])new BandwidthResourceAllocation[]{new BandwidthResourceAllocation(EMPTY_BW)});
                    }
                    BandwidthResourceAllocation cap = (BandwidthResourceAllocation)bw.iterator().next();
                    double freeBw = cap.bandwidth().toDouble();
                    for (LinkResourceAllocations alloc : allocations) {
                        Set types = alloc.getResourceAllocation(link);
                        Iterator iterator = types.iterator();
                        while (iterator.hasNext()) {
                            ResourceAllocation a = (ResourceAllocation)iterator.next();
                            if (!(a instanceof BandwidthResourceAllocation)) continue;
                            BandwidthResourceAllocation bandwidthResourceAllocation = (BandwidthResourceAllocation)a;
                            freeBw -= bandwidthResourceAllocation.bandwidth().toDouble();
                        }
                    }
                    free.put(type, Sets.newHashSet((Object[])new BandwidthResourceAllocation[]{new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)freeBw)))}));
                    continue block5;
                }
                case LAMBDA: {
                    Set<? extends ResourceAllocation> lmd = caps.get(type);
                    if (lmd == null || lmd.isEmpty()) continue block5;
                    HashSet<LambdaResourceAllocation> freeL = new HashSet<LambdaResourceAllocation>();
                    for (ResourceAllocation resourceAllocation : lmd) {
                        if (!(resourceAllocation instanceof LambdaResourceAllocation)) continue;
                        freeL.add((LambdaResourceAllocation)resourceAllocation);
                    }
                    for (LinkResourceAllocations linkResourceAllocations : allocations) {
                        Set types = linkResourceAllocations.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof LambdaResourceAllocation)) continue;
                            freeL.remove(a);
                        }
                    }
                    free.put(type, freeL);
                    continue block5;
                }
                case MPLS_LABEL: {
                    Set<? extends ResourceAllocation> mpls = caps.get(type);
                    if (mpls == null || mpls.isEmpty()) continue block5;
                    HashSet<MplsLabelResourceAllocation> hashSet = new HashSet<MplsLabelResourceAllocation>();
                    for (ResourceAllocation resourceAllocation : mpls) {
                        if (!(resourceAllocation instanceof MplsLabelResourceAllocation)) continue;
                        hashSet.add((MplsLabelResourceAllocation)resourceAllocation);
                    }
                    for (LinkResourceAllocations linkResourceAllocations : allocations) {
                        Set types = linkResourceAllocations.getResourceAllocation(link);
                        for (ResourceAllocation a : types) {
                            if (!(a instanceof MplsLabelResourceAllocation)) continue;
                            hashSet.remove(a);
                        }
                    }
                    free.put(type, hashSet);
                    continue block5;
                }
                default: {
                    this.log.debug("unsupported ResourceType {}", (Object)type);
                }
            }
        }
        return free;
    }

    public void allocateResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        TransactionContext tx = this.getTxContext();
        tx.begin();
        try {
            TransactionalMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
            intentAllocs.put((Object)allocations.intentId(), (Object)allocations);
            allocations.links().forEach(link -> this.allocateLinkResource(tx, (Link)link, allocations));
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("Exception thrown, rolling back", (Throwable)e);
            tx.abort();
            throw e;
        }
    }

    private void allocateLinkResource(TransactionContext tx, Link link, LinkResourceAllocations allocations) {
        ArrayList<LinkResourceAllocations> after;
        Set reqs = allocations.getResourceAllocation(link);
        Map<ResourceType, Set<? extends ResourceAllocation>> available = this.getFreeResourcesEx(tx, link);
        for (ResourceAllocation req : reqs) {
            Set<? extends ResourceAllocation> avail = available.get(req.type());
            if (req instanceof BandwidthResourceAllocation) {
                if (avail.isEmpty()) {
                    Preconditions.checkState((!avail.isEmpty() ? 1 : 0) != 0, (String)"There's no Bandwidth resource on %s?", (Object[])new Object[]{link});
                }
                BandwidthResourceAllocation bw = (BandwidthResourceAllocation)avail.iterator().next();
                double bwLeft = bw.bandwidth().toDouble();
                BandwidthResourceAllocation bwReq = (BandwidthResourceAllocation)req;
                if (!((bwLeft -= bwReq.bandwidth().toDouble()) < 0.0)) continue;
                throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate bandwidth for link {}  requested amount is {} current allocation is {}", (Object[])new Object[]{link, bwReq.bandwidth().toDouble(), bw}));
            }
            if (req instanceof LambdaResourceAllocation) {
                LambdaResourceAllocation lambdaAllocation = (LambdaResourceAllocation)req;
                if (avail.contains(req)) continue;
                throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate lambda for link {} lambda is {}", (Object[])new Object[]{link, lambdaAllocation.lambda().toInt()}));
            }
            if (!(req instanceof MplsLabelResourceAllocation)) continue;
            MplsLabelResourceAllocation mplsAllocation = (MplsLabelResourceAllocation)req;
            if (avail.contains(req)) continue;
            throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate MPLS label for link {} MPLS label is {}", (Object[])new Object[]{link, mplsAllocation.mplsLabel().toString()}));
        }
        LinkKey linkKey = LinkKey.linkKey((Link)link);
        TransactionalMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
        List before = (List)linkAllocs.get((Object)linkKey);
        if (before == null) {
            after = new ArrayList<LinkResourceAllocations>();
            after.add(allocations);
            before = (List)linkAllocs.putIfAbsent((Object)linkKey, after);
            if (before != null) {
                this.log.warn("Concurrent Allocation, retrying");
                throw new TransactionException();
            }
        } else {
            after = new ArrayList(before.size() + 1);
            after.addAll(before);
            after.add(allocations);
            linkAllocs.replace((Object)linkKey, (Object)before, after);
        }
    }

    public LinkResourceEvent releaseResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        IntentId intentId = allocations.intentId();
        Collection links = allocations.links();
        boolean success = false;
        do {
            TransactionContext tx = this.getTxContext();
            tx.begin();
            try {
                TransactionalMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
                intentAllocs.remove((Object)intentId);
                TransactionalMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
                links.forEach(link -> {
                    LinkKey linkId = LinkKey.linkKey((Link)link);
                    List before = (List)linkAllocs.get((Object)linkId);
                    if (before == null || before.isEmpty()) {
                        this.log.warn("There was no resource left to release on {}", (Object)linkId);
                        return;
                    }
                    ArrayList after = new ArrayList(before);
                    after.remove(allocations);
                    linkAllocs.replace((Object)linkId, (Object)before, after);
                });
                tx.commit();
                success = true;
            }
            catch (TransactionException e) {
                this.log.debug("Transaction failed, retrying", (Throwable)e);
                tx.abort();
            }
            catch (Exception e) {
                this.log.error("Exception thrown during releaseResource {}", (Object)allocations, (Object)e);
                tx.abort();
                throw e;
            }
        } while (!success);
        ImmutableList releasedResources = ImmutableList.of((Object)allocations);
        return new LinkResourceEvent(LinkResourceEvent.Type.ADDITIONAL_RESOURCES_AVAILABLE, (Collection)releasedResources);
    }

    public LinkResourceAllocations getAllocations(IntentId intentId) {
        Preconditions.checkNotNull((Object)intentId);
        Versioned alloc = null;
        try {
            alloc = this.intentAllocMap.get((Object)intentId);
        }
        catch (Exception e) {
            this.log.warn("Could not read resource allocation information", (Throwable)e);
        }
        return alloc == null ? null : (LinkResourceAllocations)alloc.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<LinkResourceAllocations> getAllocations(Link link) {
        Preconditions.checkNotNull((Object)link);
        TransactionContext tx = this.getTxContext();
        Iterable<LinkResourceAllocations> res = null;
        tx.begin();
        try {
            res = this.getAllocations(tx, link);
        }
        finally {
            tx.abort();
        }
        return res == null ? Collections.emptyList() : res;
    }

    public Iterable<LinkResourceAllocations> getAllocations() {
        try {
            Set allocs = this.intentAllocMap.values().stream().map(Versioned::value).collect(Collectors.toSet());
            return ImmutableSet.copyOf(allocs);
        }
        catch (Exception e) {
            this.log.warn("Could not read resource allocation information", (Throwable)e);
            return ImmutableSet.of();
        }
    }

    private Iterable<LinkResourceAllocations> getAllocations(TransactionContext tx, Link link) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)link);
        LinkKey key = LinkKey.linkKey((Link)link);
        TransactionalMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
        List res = null;
        res = (List)linkAllocs.get((Object)key);
        if (res == null) {
            res = (List)linkAllocs.putIfAbsent((Object)key, new ArrayList());
            if (res == null) {
                return Collections.emptyList();
            }
            return res;
        }
        return res;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

