/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.kuujo.copycat.Task;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.resource.ResourceState;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.store.consistent.impl.CommitResponse;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.consistent.impl.Match;
import org.onosproject.store.consistent.impl.Result;
import org.onosproject.store.consistent.impl.StateMachineUpdate;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.Versioned;

public class DefaultAsyncConsistentMapTest {
    private static final ApplicationId APP_ID = new DefaultApplicationId(42, "what");
    private static final TestData KEY1A = new TestData("One", "a");
    private static final TestData KEY1B = new TestData("One", "b");
    private static final TestData VALUE2A = new TestData("Two", "a");
    private static final TestData VALUE2B = new TestData("Two", "b");

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testKeySet() throws Exception {
        String name = "map_name";
        TestDatabase database = new TestDatabase();
        Serializer serializer = Serializer.forTypes((Class[])new Class[]{TestData.class});
        DefaultAsyncConsistentMap map = new DefaultAsyncConsistentMap(name, APP_ID, (Database)database, serializer, false, false, false);
        map.put((Object)KEY1A, (Object)VALUE2A);
        map.put((Object)KEY1B, (Object)VALUE2A);
        Set set = (Set)map.keySet().get();
        Assert.assertEquals((String)"Should contain 2 keys", (long)2L, (long)set.size());
        Assert.assertThat((Object)set.contains(KEY1A), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)set.contains(KEY1B), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)set.contains(new TestData("One", "a")), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testEntrySet() throws Exception {
        String name = "map_name";
        TestDatabase database = new TestDatabase();
        Serializer serializer = Serializer.forTypes((Class[])new Class[]{TestData.class});
        DefaultAsyncConsistentMap map = new DefaultAsyncConsistentMap(name, APP_ID, (Database)database, serializer, false, false, false);
        map.put((Object)KEY1A, (Object)VALUE2A);
        map.put((Object)KEY1B, (Object)VALUE2A);
        Assert.assertEquals((String)"Should contain 2 entry", (long)2L, (long)((Set)map.entrySet().get()).size());
    }

    public class TestDatabase
    implements Database {
        Map<String, Versioned<byte[]>> map = new ConcurrentHashMap<String, Versioned<byte[]>>();

        public CompletableFuture<Set<String>> maps() {
            return CompletableFuture.completedFuture(ImmutableSet.of());
        }

        public CompletableFuture<Map<String, Long>> counters() {
            return CompletableFuture.completedFuture(ImmutableMap.of());
        }

        public CompletableFuture<Integer> mapSize(String mapName) {
            return CompletableFuture.completedFuture(this.map.size());
        }

        public CompletableFuture<Boolean> mapIsEmpty(String mapName) {
            return CompletableFuture.completedFuture(this.map.isEmpty());
        }

        public CompletableFuture<Boolean> mapContainsKey(String mapName, String key) {
            return CompletableFuture.completedFuture(this.map.containsKey(key));
        }

        public CompletableFuture<Boolean> mapContainsValue(String mapName, byte[] value) {
            return CompletableFuture.completedFuture(Maps.transformValues(this.map, Versioned::value).containsValue(value));
        }

        public CompletableFuture<Versioned<byte[]>> mapGet(String mapName, String key) {
            return CompletableFuture.completedFuture(this.map.get(key));
        }

        public synchronized CompletableFuture<Result<UpdateResult<String, byte[]>>> mapUpdate(String mapName, String key, Match<byte[]> valueMatch, Match<Long> versionMatch, byte[] value) {
            Versioned newValue;
            Versioned oldValue;
            boolean updated = false;
            Versioned old = this.map.getOrDefault(key, (Versioned<byte[]>)new Versioned(null, 0L));
            if (valueMatch.matches(old.value()) && versionMatch.matches((Object)old.version())) {
                updated = true;
                oldValue = old;
                newValue = new Versioned((Object)value, old.version() + 1L);
                this.map.put(key, (Versioned<byte[]>)newValue);
            } else {
                updated = false;
                oldValue = old;
                newValue = old;
            }
            return CompletableFuture.completedFuture(Result.ok((Object)new UpdateResult(updated, mapName, (Object)key, oldValue, newValue)));
        }

        public CompletableFuture<Result<Void>> mapClear(String mapName) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Set<String>> mapKeySet(String mapName) {
            return CompletableFuture.completedFuture(Collections.unmodifiableSet(this.map.keySet()));
        }

        public CompletableFuture<Collection<Versioned<byte[]>>> mapValues(String mapName) {
            return CompletableFuture.completedFuture(Collections.unmodifiableCollection(this.map.values()));
        }

        public CompletableFuture<Set<Map.Entry<String, Versioned<byte[]>>>> mapEntrySet(String mapName) {
            return CompletableFuture.completedFuture(Collections.unmodifiableSet(this.map.entrySet()));
        }

        public CompletableFuture<Long> counterAddAndGet(String counterName, long delta) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Long> counterGetAndAdd(String counterName, long delta) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Void> counterSet(String counterName, long value) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Boolean> counterCompareAndSet(String counterName, long expectedValue, long update) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Long> counterGet(String counterName) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Long> queueSize(String queueName) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Void> queuePush(String queueName, byte[] entry) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<byte[]> queuePop(String queueName) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<byte[]> queuePeek(String queueName) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<CommitResponse> prepareAndCommit(Transaction transaction) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Boolean> prepare(Transaction transaction) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<CommitResponse> commit(Transaction transaction) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Boolean> rollback(Transaction transaction) {
            throw new UnsupportedOperationException();
        }

        public String name() {
            return "name";
        }

        public ResourceState state() {
            return ResourceState.HEALTHY;
        }

        public Cluster cluster() {
            throw new UnsupportedOperationException();
        }

        public Database addStartupTask(Task<CompletableFuture<Void>> task) {
            throw new UnsupportedOperationException();
        }

        public Database addShutdownTask(Task<CompletableFuture<Void>> task) {
            throw new UnsupportedOperationException();
        }

        public CompletableFuture<Database> open() {
            return CompletableFuture.completedFuture(this);
        }

        public boolean isOpen() {
            return true;
        }

        public CompletableFuture<Void> close() {
            return CompletableFuture.completedFuture(null);
        }

        public boolean isClosed() {
            return false;
        }

        public void registerConsumer(Consumer<StateMachineUpdate> consumer) {
        }

        public void unregisterConsumer(Consumer<StateMachineUpdate> consumer) {
        }
    }

    public static class TestData {
        private final String theKey;
        private final String notUsedForEquals;

        public TestData(String theKey, String notUsedForEquals) {
            this.theKey = theKey;
            this.notUsedForEquals = notUsedForEquals;
        }

        public int hashCode() {
            return Objects.hashCode(this.theKey);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TestData) {
                TestData that = (TestData)obj;
                return Objects.equals(this.theKey, that.theKey);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("theKey", (Object)this.theKey).add("notUsedForEquals", (Object)this.notUsedForEquals).toString();
        }
    }
}

