/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import junit.framework.TestCase;
import org.junit.Test;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.Versioned;

public class UpdateResultTest {
    @Test
    public void testGetters() {
        Versioned oldValue = new Versioned((Object)"a", 1L);
        Versioned newValue = new Versioned((Object)"b", 2L);
        UpdateResult ur = new UpdateResult(true, "foo", (Object)"k", oldValue, newValue);
        TestCase.assertTrue((boolean)ur.updated());
        TestCase.assertEquals((String)"foo", (String)ur.mapName());
        TestCase.assertEquals((String)"k", (String)((String)ur.key()));
        TestCase.assertEquals((Object)oldValue, (Object)ur.oldValue());
        TestCase.assertEquals((Object)newValue, (Object)ur.newValue());
    }

    @Test
    public void testToMapEvent() {
        Versioned oldValue = new Versioned((Object)"a", 1L);
        Versioned newValue = new Versioned((Object)"b", 2L);
        UpdateResult ur1 = new UpdateResult(true, "foo", (Object)"k", oldValue, newValue);
        MapEvent event1 = ur1.toMapEvent();
        TestCase.assertEquals((Object)MapEvent.Type.UPDATE, (Object)event1.type());
        TestCase.assertEquals((String)"k", (String)((String)event1.key()));
        TestCase.assertEquals((Object)newValue, (Object)event1.value());
        UpdateResult ur2 = new UpdateResult(true, "foo", (Object)"k", null, newValue);
        MapEvent event2 = ur2.toMapEvent();
        TestCase.assertEquals((Object)MapEvent.Type.INSERT, (Object)event2.type());
        TestCase.assertEquals((String)"k", (String)((String)event2.key()));
        TestCase.assertEquals((Object)newValue, (Object)event2.value());
        UpdateResult ur3 = new UpdateResult(true, "foo", (Object)"k", oldValue, null);
        MapEvent event3 = ur3.toMapEvent();
        TestCase.assertEquals((Object)MapEvent.Type.REMOVE, (Object)event3.type());
        TestCase.assertEquals((String)"k", (String)((String)event3.key()));
        TestCase.assertEquals((Object)oldValue, (Object)event3.value());
        UpdateResult ur4 = new UpdateResult(false, "foo", (Object)"k", oldValue, oldValue);
        TestCase.assertNull((Object)ur4.toMapEvent());
    }

    @Test
    public void testMap() {
        Versioned oldValue = new Versioned((Object)"a", 1L);
        Versioned newValue = new Versioned((Object)"b", 2L);
        UpdateResult ur1 = new UpdateResult(true, "foo", (Object)"k", oldValue, newValue);
        UpdateResult ur2 = ur1.map(s -> s.length(), s -> s.length());
        TestCase.assertEquals((boolean)ur2.updated(), (boolean)ur1.updated());
        TestCase.assertEquals((String)ur1.mapName(), (String)ur2.mapName());
        TestCase.assertEquals((Object)new Integer(1), (Object)ur2.key());
        TestCase.assertEquals((Object)oldValue.map(s -> s.length()), (Object)ur2.oldValue());
        TestCase.assertEquals((Object)newValue.map(s -> s.length()), (Object)ur2.newValue());
        UpdateResult ur3 = new UpdateResult(true, "foo", (Object)"k", null, newValue);
        UpdateResult ur4 = ur3.map(s -> s.length(), s -> s.length());
        TestCase.assertEquals((boolean)ur3.updated(), (boolean)ur4.updated());
        TestCase.assertEquals((String)ur3.mapName(), (String)ur4.mapName());
        TestCase.assertEquals((Object)new Integer(1), (Object)ur4.key());
        TestCase.assertNull((Object)ur4.oldValue());
        TestCase.assertEquals((Object)newValue.map(s -> s.length()), (Object)ur4.newValue());
    }
}

