/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.joda.time.DateTime;
import org.onlab.packet.IpAddress;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterStore;
import org.onosproject.cluster.ClusterStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.cluster.impl.PhiAccrualFailureDetector;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.MessagingService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.KryoSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedClusterStore
extends AbstractStore<ClusterEvent, ClusterStoreDelegate>
implements ClusterStore {
    private static final Logger log = LoggerFactory.getLogger(DistributedClusterStore.class);
    public static final String HEARTBEAT_MESSAGE = "onos-cluster-heartbeat";
    private static final int HEARTBEAT_INTERVAL_MS = 100;
    private static final int PHI_FAILURE_THRESHOLD = 10;
    private static final KryoSerializer SERIALIZER = new KryoSerializer(){

        protected void setupKryoPool() {
            this.serializerPool = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{HeartbeatMessage.class}).build().populate(1);
        }
    };
    private static final String INSTANCE_ID_NULL = "Instance ID cannot be null";
    private final Map<NodeId, ControllerNode> allNodes = Maps.newConcurrentMap();
    private final Map<NodeId, ControllerNode.State> nodeStates = Maps.newConcurrentMap();
    private final Map<NodeId, DateTime> nodeStateLastUpdatedTimes = Maps.newConcurrentMap();
    private ScheduledExecutorService heartBeatSender = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/cluster/membership", (String)"heartbeat-sender"));
    private ExecutorService heartBeatMessageHandler = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/cluster/membership", (String)"heartbeat-receiver"));
    private PhiAccrualFailureDetector failureDetector;
    private ControllerNode localNode;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataService clusterMetadataService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MessagingService messagingService;

    @Activate
    public void activate() {
        this.localNode = this.clusterMetadataService.getLocalNode();
        this.messagingService.registerHandler(HEARTBEAT_MESSAGE, (Consumer)new HeartbeatMessageHandler(), (Executor)this.heartBeatMessageHandler);
        this.failureDetector = new PhiAccrualFailureDetector();
        this.heartBeatSender.scheduleWithFixedDelay(this::heartbeat, 0L, 100L, TimeUnit.MILLISECONDS);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.messagingService.unregisterHandler(HEARTBEAT_MESSAGE);
        this.heartBeatSender.shutdownNow();
        this.heartBeatMessageHandler.shutdownNow();
        log.info("Stopped");
    }

    public void setDelegate(ClusterStoreDelegate delegate) {
        Preconditions.checkNotNull((Object)delegate, (Object)"Delegate cannot be null");
        this.delegate = delegate;
    }

    public void unsetDelegate(ClusterStoreDelegate delegate) {
        this.delegate = null;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public ControllerNode getLocalNode() {
        return this.localNode;
    }

    public Set<ControllerNode> getNodes() {
        return ImmutableSet.copyOf(this.allNodes.values());
    }

    public ControllerNode getNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.allNodes.get(nodeId);
    }

    public ControllerNode.State getState(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        return this.nodeStates.get(nodeId);
    }

    public ControllerNode addNode(NodeId nodeId, IpAddress ip, int tcpPort) {
        DefaultControllerNode node = new DefaultControllerNode(nodeId, ip, tcpPort);
        this.addNode((ControllerNode)node);
        return node;
    }

    public void removeNode(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId, (Object)INSTANCE_ID_NULL);
        ControllerNode node = this.allNodes.remove(nodeId);
        if (node != null) {
            this.nodeStates.remove(nodeId);
            this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, node));
        }
    }

    private void addNode(ControllerNode node) {
        this.allNodes.put(node.id(), node);
        this.updateState(node.id(), node.equals(this.localNode) ? ControllerNode.State.ACTIVE : ControllerNode.State.INACTIVE);
        this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, node));
    }

    private void updateState(NodeId nodeId, ControllerNode.State newState) {
        this.nodeStates.put(nodeId, newState);
        this.nodeStateLastUpdatedTimes.put(nodeId, DateTime.now());
    }

    private void heartbeat() {
        try {
            Set<ControllerNode> peers = this.allNodes.values().stream().filter(node -> !node.id().equals((Object)this.localNode.id())).collect(Collectors.toSet());
            byte[] hbMessagePayload = SERIALIZER.encode((Object)new HeartbeatMessage(this.localNode, peers));
            peers.forEach(node -> {
                this.heartbeatToPeer(hbMessagePayload, (ControllerNode)node);
                ControllerNode.State currentState = this.nodeStates.get(node.id());
                double phi = this.failureDetector.phi(node.id());
                if (phi >= 10.0) {
                    if (currentState == ControllerNode.State.ACTIVE) {
                        this.updateState(node.id(), ControllerNode.State.INACTIVE);
                        this.notifyStateChange(node.id(), ControllerNode.State.ACTIVE, ControllerNode.State.INACTIVE);
                    }
                } else if (currentState == ControllerNode.State.INACTIVE) {
                    this.updateState(node.id(), ControllerNode.State.ACTIVE);
                    this.notifyStateChange(node.id(), ControllerNode.State.INACTIVE, ControllerNode.State.ACTIVE);
                }
            });
        }
        catch (Exception e) {
            log.debug("Failed to send heartbeat", (Throwable)e);
        }
    }

    private void notifyStateChange(NodeId nodeId, ControllerNode.State oldState, ControllerNode.State newState) {
        ControllerNode node = this.allNodes.get(nodeId);
        if (newState == ControllerNode.State.ACTIVE) {
            this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, node));
        } else {
            this.notifyDelegate((Event)new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, node));
        }
    }

    private void heartbeatToPeer(byte[] messagePayload, ControllerNode peer) {
        Endpoint remoteEp = new Endpoint(peer.ip(), peer.tcpPort());
        this.messagingService.sendAsync(remoteEp, HEARTBEAT_MESSAGE, messagePayload).whenComplete((result, error) -> {
            if (error != null) {
                log.trace("Sending heartbeat to {} failed", (Object)remoteEp, error);
            }
        });
    }

    public DateTime getLastUpdated(NodeId nodeId) {
        return this.nodeStateLastUpdatedTimes.get(nodeId);
    }

    protected void bindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        this.clusterMetadataService = clusterMetadataService;
    }

    protected void unbindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        if (this.clusterMetadataService == clusterMetadataService) {
            this.clusterMetadataService = null;
        }
    }

    protected void bindMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    protected void unbindMessagingService(MessagingService messagingService) {
        if (this.messagingService == messagingService) {
            this.messagingService = null;
        }
    }

    private static class HeartbeatMessage {
        private ControllerNode source;
        private Set<ControllerNode> knownPeers;

        public HeartbeatMessage(ControllerNode source, Set<ControllerNode> members) {
            this.source = source;
            this.knownPeers = ImmutableSet.copyOf(members);
        }

        public ControllerNode source() {
            return this.source;
        }

        public Set<ControllerNode> knownPeers() {
            return this.knownPeers;
        }
    }

    private class HeartbeatMessageHandler
    implements Consumer<byte[]> {
        private HeartbeatMessageHandler() {
        }

        @Override
        public void accept(byte[] message) {
            HeartbeatMessage hb = (HeartbeatMessage)SERIALIZER.decode(message);
            DistributedClusterStore.this.failureDetector.report(hb.source().id());
            hb.knownPeers().forEach(node -> DistributedClusterStore.this.allNodes.put(node.id(), node));
        }
    }
}

