/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ClusterMetadataEvent;
import org.onosproject.cluster.ClusterMetadataStore;
import org.onosproject.cluster.ClusterMetadataStoreDelegate;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class StaticClusterMetadataStore
extends AbstractStore<ClusterMetadataEvent, ClusterMetadataStoreDelegate>
implements ClusterMetadataStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String ONOS_IP = "ONOS_IP";
    private static final String ONOS_INTERFACE = "ONOS_INTERFACE";
    private static final String ONOS_ALLOW_IPV6 = "ONOS_ALLOW_IPV6";
    private static final String DEFAULT_ONOS_INTERFACE = "eth0";
    private static final String CLUSTER_METADATA_FILE = "../config/cluster.json";
    private static final int DEFAULT_ONOS_PORT = 9876;
    private final File metadataFile = new File("../config/cluster.json");
    private AtomicReference<ClusterMetadata> metadata = new AtomicReference();
    private ObjectMapper mapper;
    private long version;

    @Activate
    public void activate() {
        this.mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(NodeId.class, (JsonSerializer)new NodeIdSerializer());
        module.addDeserializer(NodeId.class, (JsonDeserializer)new NodeIdDeserializer());
        module.addSerializer(ControllerNode.class, (JsonSerializer)new ControllerNodeSerializer());
        module.addDeserializer(ControllerNode.class, (JsonDeserializer)new ControllerNodeDeserializer());
        this.mapper.registerModule((Module)module);
        File metadataFile = new File(CLUSTER_METADATA_FILE);
        if (metadataFile.exists()) {
            try {
                this.metadata.set((ClusterMetadata)this.mapper.readValue(metadataFile, ClusterMetadata.class));
                this.version = metadataFile.lastModified();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        } else {
            String localIp = StaticClusterMetadataStore.getSiteLocalAddress();
            DefaultControllerNode localNode = new DefaultControllerNode(new NodeId(localIp), IpAddress.valueOf((String)localIp), 9876);
            this.metadata.set(ClusterMetadata.builder().withName("default").withControllerNodes(Arrays.asList(localNode)).withPartitions((Collection)Lists.newArrayList((Object[])new Partition[]{new Partition("p1", (Collection)Lists.newArrayList((Object[])new NodeId[]{localNode.id()}))})).build());
            this.version = System.currentTimeMillis();
        }
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void setDelegate(ClusterMetadataStoreDelegate delegate) {
        Preconditions.checkNotNull((Object)delegate, (Object)"Delegate cannot be null");
        this.delegate = delegate;
    }

    public void unsetDelegate(ClusterMetadataStoreDelegate delegate) {
        this.delegate = null;
    }

    public boolean hasDelegate() {
        return this.delegate != null;
    }

    public Versioned<ClusterMetadata> getClusterMetadata() {
        return new Versioned((Object)this.metadata.get(), this.version);
    }

    public void setClusterMetadata(ClusterMetadata metadata) {
        Preconditions.checkNotNull((Object)metadata);
        try {
            Files.createParentDirs((File)this.metadataFile);
            this.mapper.writeValue(this.metadataFile, (Object)metadata);
            this.metadata.set(metadata);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void setActiveReplica(String partitionId, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    public void unsetActiveReplica(String partitionId, NodeId nodeId) {
        throw new UnsupportedOperationException();
    }

    public Collection<NodeId> getActiveReplicas(String partitionId) {
        return this.metadata.get().getPartitions().stream().filter(r -> r.getName().equals(partitionId)).findFirst().map(r -> r.getMembers()).orElse(null);
    }

    private static String getSiteLocalAddress() {
        String useOnosIp = System.getenv(ONOS_IP);
        if (useOnosIp != null) {
            return useOnosIp;
        }
        String useOnosInterface = System.getenv(ONOS_INTERFACE);
        if (useOnosInterface == null) {
            useOnosInterface = DEFAULT_ONOS_INTERFACE;
        }
        boolean allowIPv6 = System.getenv(ONOS_ALLOW_IPV6) != null;
        Function<NetworkInterface, IpAddress> ipLookup = nif -> {
            IpAddress fallback = null;
            if (nif != null) {
                for (InetAddress address : Collections.list(nif.getInetAddresses())) {
                    if (address.isSiteLocalAddress() && (allowIPv6 || address instanceof Inet4Address)) {
                        return IpAddress.valueOf((InetAddress)address);
                    }
                    if (fallback != null || address.isLoopbackAddress() || address.isMulticastAddress() || !allowIPv6 && !(address instanceof Inet4Address)) continue;
                    fallback = IpAddress.valueOf((InetAddress)address);
                }
            }
            return fallback;
        };
        try {
            IpAddress ip = ipLookup.apply(NetworkInterface.getByName(useOnosInterface));
            if (ip != null) {
                return ip.toString();
            }
            for (NetworkInterface nif2 : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (nif2.getName().equals(useOnosInterface) || (ip = ipLookup.apply(nif2)) == null) continue;
                return ip.toString();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get network interfaces", e);
        }
        return IpAddress.valueOf((InetAddress)InetAddress.getLoopbackAddress()).toString();
    }

    private class NodeIdDeserializer
    extends JsonDeserializer<NodeId> {
        private NodeIdDeserializer() {
        }

        public NodeId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            return new NodeId(node.asText());
        }
    }

    private static class NodeIdSerializer
    extends JsonSerializer<NodeId> {
        private NodeIdSerializer() {
        }

        public void serialize(NodeId nodeId, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(nodeId.toString());
        }
    }

    private static class ControllerNodeDeserializer
    extends JsonDeserializer<ControllerNode> {
        private ControllerNodeDeserializer() {
        }

        public ControllerNode deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            NodeId nodeId = new NodeId(node.get("id").textValue());
            IpAddress ip = IpAddress.valueOf((String)node.get("ip").textValue());
            int port = node.get("port").asInt();
            return new DefaultControllerNode(nodeId, ip, port);
        }
    }

    private static class ControllerNodeSerializer
    extends JsonSerializer<ControllerNode> {
        private ControllerNodeSerializer() {
        }

        public void serialize(ControllerNode node, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("id", node.id().toString());
            jgen.writeStringField("ip", node.ip().toString());
            jgen.writeNumberField("port", node.tcpPort());
            jgen.writeEndObject();
        }
    }
}

