/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.CompletableFuture;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;

public class AsyncCachingConsistentMap<K, V>
extends DefaultAsyncConsistentMap<K, V> {
    private final LoadingCache<K, CompletableFuture<Versioned<V>>> cache = CacheBuilder.newBuilder().maximumSize(10000L).build(new CacheLoader<K, CompletableFuture<Versioned<V>>>(){

        public CompletableFuture<Versioned<V>> load(K key) throws Exception {
            return AsyncCachingConsistentMap.super.get(key);
        }
    });

    public AsyncCachingConsistentMap(String name, ApplicationId applicationId, Database database, Serializer serializer, boolean readOnly, boolean purgeOnUninstall, boolean meteringEnabled) {
        super(name, applicationId, database, serializer, readOnly, purgeOnUninstall, meteringEnabled);
        this.addListener(event -> this.cache.invalidate(event.key()));
    }

    @Override
    public CompletableFuture<Versioned<V>> get(K key) {
        CompletableFuture cachedValue = (CompletableFuture)this.cache.getIfPresent(key);
        if (cachedValue != null) {
            if (cachedValue.isCompletedExceptionally()) {
                this.cache.invalidate(key);
            } else {
                return cachedValue;
            }
        }
        return (CompletableFuture)this.cache.getUnchecked(key);
    }

    @Override
    protected void beforeUpdate(K key) {
        super.beforeUpdate(key);
        this.cache.invalidate(key);
    }
}

