/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.typesafe.config.ConfigValueFactory;
import java.util.Map;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.internal.coordinator.CoordinatedResourceConfig;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.resource.ResourceConfig;
import net.kuujo.copycat.state.StateLogConfig;
import net.kuujo.copycat.util.internal.Assert;
import org.onosproject.store.consistent.impl.DefaultDatabase;

public class DatabaseConfig
extends ResourceConfig<DatabaseConfig> {
    private static final String DATABASE_CONSISTENCY = "consistency";
    private static final String DEFAULT_CONFIGURATION = "database-defaults";
    private static final String CONFIGURATION = "database";
    private String name;

    public DatabaseConfig() {
        super(new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public DatabaseConfig(Map<String, Object> config) {
        super(config, new String[]{CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    public DatabaseConfig(String resource) {
        super(new String[]{resource, CONFIGURATION, DEFAULT_CONFIGURATION});
    }

    protected DatabaseConfig(DatabaseConfig config) {
        super((ResourceConfig)config);
    }

    public DatabaseConfig copy() {
        return new DatabaseConfig(this);
    }

    public void setConsistency(String consistency) {
        this.config = this.config.withValue(DATABASE_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)Consistency.parse((String)((String)Assert.isNotNull((Object)consistency, (String)DATABASE_CONSISTENCY))).toString()));
    }

    public void setConsistency(Consistency consistency) {
        this.config = this.config.withValue(DATABASE_CONSISTENCY, ConfigValueFactory.fromAnyRef((Object)((Consistency)Assert.isNotNull((Object)consistency, (String)DATABASE_CONSISTENCY)).toString()));
    }

    public Consistency getConsistency() {
        return Consistency.parse((String)this.config.getString(DATABASE_CONSISTENCY));
    }

    public DatabaseConfig withConsistency(String consistency) {
        this.setConsistency(consistency);
        return this;
    }

    public DatabaseConfig withConsistency(Consistency consistency) {
        this.setConsistency(consistency);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DatabaseConfig withName(String name) {
        this.setName((String)Assert.isNotNull((Object)name, (String)"name"));
        return this;
    }

    public void setName(String name) {
        this.name = (String)Assert.isNotNull((Object)name, (String)"name");
    }

    public CoordinatedResourceConfig resolve(ClusterConfig cluster) {
        return new StateLogConfig(this.toMap()).resolve(cluster).withResourceType(DefaultDatabase.class);
    }
}

