/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.kuujo.copycat.CopycatConfig;
import net.kuujo.copycat.cluster.ClusterConfig;
import net.kuujo.copycat.cluster.Member;
import net.kuujo.copycat.cluster.internal.coordinator.ClusterCoordinator;
import net.kuujo.copycat.cluster.internal.coordinator.DefaultClusterCoordinator;
import net.kuujo.copycat.log.BufferedLog;
import net.kuujo.copycat.log.FileLog;
import net.kuujo.copycat.log.Log;
import net.kuujo.copycat.protocol.Consistency;
import net.kuujo.copycat.protocol.Protocol;
import net.kuujo.copycat.util.concurrent.NamedThreadFactory;
import net.kuujo.copycat.util.serializer.Serializer;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationListener;
import org.onosproject.app.ApplicationService;
import org.onosproject.cluster.ClusterMetadataService;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.EventListener;
import org.onosproject.persistence.PersistenceService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.consistent.impl.CopycatCommunicationProtocol;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DatabaseConfig;
import org.onosproject.store.consistent.impl.DatabaseSerializer;
import org.onosproject.store.consistent.impl.DefaultAsyncConsistentMap;
import org.onosproject.store.consistent.impl.DefaultAtomicCounterBuilder;
import org.onosproject.store.consistent.impl.DefaultAtomicValueBuilder;
import org.onosproject.store.consistent.impl.DefaultConsistentMapBuilder;
import org.onosproject.store.consistent.impl.DefaultDistributedQueueBuilder;
import org.onosproject.store.consistent.impl.DefaultDistributedSetBuilder;
import org.onosproject.store.consistent.impl.DefaultTransactionContextBuilder;
import org.onosproject.store.consistent.impl.PartitionedDatabase;
import org.onosproject.store.consistent.impl.TransactionManager;
import org.onosproject.store.ecmap.EventuallyConsistentMapBuilderImpl;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.AtomicValueBuilder;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.DistributedQueueBuilder;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.EventuallyConsistentMapBuilder;
import org.onosproject.store.service.MapInfo;
import org.onosproject.store.service.PartitionInfo;
import org.onosproject.store.service.StorageAdminService;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.TransactionContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DatabaseManager
implements StorageService,
StorageAdminService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String BASE_PARTITION_NAME = "p0";
    private static final int RAFT_ELECTION_TIMEOUT_MILLIS = 3000;
    private static final int DATABASE_OPERATION_TIMEOUT_MILLIS = 5000;
    private ClusterCoordinator coordinator;
    protected PartitionedDatabase partitionedDatabase;
    protected Database inMemoryDatabase;
    protected NodeId localNodeId;
    private TransactionManager transactionManager;
    private final IdGenerator transactionIdGenerator = () -> RandomUtils.nextLong();
    private ApplicationListener appListener = new InternalApplicationListener();
    private final Multimap<String, DefaultAsyncConsistentMap> maps = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    private final Multimap<ApplicationId, DefaultAsyncConsistentMap> mapsByApplication = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterMetadataService clusterMetadataService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    protected ApplicationService applicationService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PersistenceService persistenceService;

    protected String nodeIdToUri(NodeId nodeId) {
        ControllerNode node = this.clusterService.getNode(nodeId);
        return String.format("onos://%s:%d", node.ip(), node.tcpPort());
    }

    protected void bindApplicationService(ApplicationService service) {
        this.applicationService = service;
        this.applicationService.addListener((EventListener)this.appListener);
    }

    protected void unbindApplicationService(ApplicationService service) {
        this.applicationService.removeListener((EventListener)this.appListener);
        this.applicationService = null;
    }

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        HashMap partitionMap = Maps.newHashMap();
        this.clusterMetadataService.getClusterMetadata().getPartitions().forEach(p -> partitionMap.put(p.getName(), Sets.newHashSet((Iterable)p.getMembers())));
        String[] activeNodeUris = (String[])((Set)partitionMap.values().stream().reduce((s1, s2) -> Sets.union((Set)s1, (Set)s2)).get()).stream().map(this::nodeIdToUri).toArray(String[]::new);
        String localNodeUri = this.nodeIdToUri(this.clusterMetadataService.getLocalNode().id());
        CopycatCommunicationProtocol protocol = new CopycatCommunicationProtocol(this.clusterService, this.clusterCommunicator);
        ClusterConfig clusterConfig = new ClusterConfig().withProtocol((Protocol)protocol).withElectionTimeout(this.electionTimeoutMillis(activeNodeUris)).withHeartbeatInterval(this.heartbeatTimeoutMillis(activeNodeUris)).withMembers(activeNodeUris).withLocalMember(localNodeUri);
        CopycatConfig copycatConfig = new CopycatConfig().withName("onos").withClusterConfig(clusterConfig).withDefaultSerializer((Serializer)new DatabaseSerializer()).withDefaultExecutor((Executor)Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("copycat-coordinator-%d")));
        this.coordinator = new DefaultClusterCoordinator(copycatConfig.resolve());
        DatabaseConfig inMemoryDatabaseConfig = this.newDatabaseConfig(BASE_PARTITION_NAME, this.newInMemoryLog(), activeNodeUris);
        this.inMemoryDatabase = (Database)this.coordinator.getResource(inMemoryDatabaseConfig.getName(), inMemoryDatabaseConfig.resolve(clusterConfig).withSerializer(copycatConfig.getDefaultSerializer()).withDefaultExecutor(copycatConfig.getDefaultExecutor()));
        List<Database> partitions = partitionMap.entrySet().stream().map(entry -> {
            String[] replicas = (String[])((Set)entry.getValue()).stream().map(this::nodeIdToUri).toArray(String[]::new);
            return this.newDatabaseConfig((String)entry.getKey(), this.newPersistentLog(), replicas);
        }).map(config -> {
            Database db = (Database)this.coordinator.getResource(config.getName(), config.resolve(clusterConfig).withSerializer(copycatConfig.getDefaultSerializer()).withDefaultExecutor(copycatConfig.getDefaultExecutor()));
            return db;
        }).collect(Collectors.toList());
        this.partitionedDatabase = new PartitionedDatabase("onos-store", partitions);
        CompletionStage status = this.coordinator.open().thenCompose(v -> CompletableFuture.allOf(this.inMemoryDatabase.open(), this.partitionedDatabase.open()).whenComplete((db, error) -> {
            if (error != null) {
                this.log.error("Failed to initialize database.", error);
            } else {
                this.log.info("Successfully initialized database.");
            }
        }));
        Futures.getUnchecked((Future)((Object)status));
        this.transactionManager = new TransactionManager(this.partitionedDatabase, this.consistentMapBuilder());
        this.partitionedDatabase.setTransactionManager(this.transactionManager);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        ((CompletableFuture)CompletableFuture.allOf(this.inMemoryDatabase.close(), this.partitionedDatabase.close()).thenCompose(v -> this.coordinator.close())).whenComplete((result, error) -> {
            if (error != null) {
                this.log.warn("Failed to cleanly close databases.", error);
            } else {
                this.log.info("Successfully closed databases.");
            }
        });
        ImmutableList.copyOf((Collection)this.maps.values()).forEach(this::unregisterMap);
        if (this.applicationService != null) {
            this.applicationService.removeListener((EventListener)this.appListener);
        }
        this.log.info("Stopped");
    }

    public TransactionContextBuilder transactionContextBuilder() {
        return new DefaultTransactionContextBuilder(this, this.transactionIdGenerator.getNewId());
    }

    public List<PartitionInfo> getPartitionInfo() {
        return Lists.asList((Object)this.inMemoryDatabase, (Object[])this.partitionedDatabase.getPartitions().toArray(new Database[0])).stream().map(DatabaseManager::toPartitionInfo).collect(Collectors.toList());
    }

    private Log newPersistentLog() {
        String logDir = System.getProperty("karaf.data", "./data");
        return new FileLog().withDirectory(logDir).withSegmentSize(0x40000000).withFlushOnWrite(true).withSegmentInterval(Long.MAX_VALUE);
    }

    private Log newInMemoryLog() {
        return new BufferedLog().withFlushOnWrite(false).withFlushInterval(Long.MAX_VALUE).withSegmentSize(0xA00000).withSegmentInterval(Long.MAX_VALUE);
    }

    private DatabaseConfig newDatabaseConfig(String name, Log log, String[] replicas) {
        return (DatabaseConfig)((DatabaseConfig)((DatabaseConfig)((DatabaseConfig)((DatabaseConfig)new DatabaseConfig().withName(name).withElectionTimeout(this.electionTimeoutMillis(replicas))).withHeartbeatInterval(this.heartbeatTimeoutMillis(replicas))).withConsistency(Consistency.DEFAULT).withLog(log)).withDefaultSerializer((Serializer)new DatabaseSerializer())).withReplicas(replicas);
    }

    private long electionTimeoutMillis(String[] replicas) {
        return replicas.length == 1 ? 10L : 3000L;
    }

    private long heartbeatTimeoutMillis(String[] replicas) {
        return this.electionTimeoutMillis(replicas) / 2L;
    }

    private static PartitionInfo toPartitionInfo(Database database) {
        return new PartitionInfo(database.name(), database.cluster().term(), database.cluster().members().stream().filter(member -> Member.Type.ACTIVE.equals((Object)member.type())).map(Member::uri).sorted().collect(Collectors.toList()), database.cluster().leader() != null ? database.cluster().leader().uri() : null);
    }

    public <K, V> EventuallyConsistentMapBuilder<K, V> eventuallyConsistentMapBuilder() {
        return new EventuallyConsistentMapBuilderImpl(this.clusterService, this.clusterCommunicator, this.persistenceService);
    }

    public <K, V> ConsistentMapBuilder<K, V> consistentMapBuilder() {
        return new DefaultConsistentMapBuilder(this);
    }

    public <E> DistributedSetBuilder<E> setBuilder() {
        return new DefaultDistributedSetBuilder(this);
    }

    public <E> DistributedQueueBuilder<E> queueBuilder() {
        return new DefaultDistributedQueueBuilder(this);
    }

    public AtomicCounterBuilder atomicCounterBuilder() {
        return new DefaultAtomicCounterBuilder(this.inMemoryDatabase, this.partitionedDatabase);
    }

    public <V> AtomicValueBuilder<V> atomicValueBuilder() {
        return new DefaultAtomicValueBuilder(this);
    }

    public List<MapInfo> getMapInfo() {
        ArrayList maps = Lists.newArrayList();
        maps.addAll(this.getMapInfo(this.inMemoryDatabase));
        maps.addAll(this.getMapInfo(this.partitionedDatabase));
        return maps;
    }

    private List<MapInfo> getMapInfo(Database database) {
        return DatabaseManager.complete(database.maps()).stream().map(name -> new MapInfo(name, DatabaseManager.complete(database.mapSize((String)name)).intValue())).filter(info -> info.size() > 0).collect(Collectors.toList());
    }

    public Map<String, Long> getCounters() {
        HashMap counters = Maps.newHashMap();
        counters.putAll(DatabaseManager.complete(this.inMemoryDatabase.counters()));
        counters.putAll(DatabaseManager.complete(this.partitionedDatabase.counters()));
        return counters;
    }

    public Map<String, Long> getPartitionedDatabaseCounters() {
        HashMap counters = Maps.newHashMap();
        counters.putAll(DatabaseManager.complete(this.partitionedDatabase.counters()));
        return counters;
    }

    public Map<String, Long> getInMemoryDatabaseCounters() {
        HashMap counters = Maps.newHashMap();
        counters.putAll(DatabaseManager.complete(this.inMemoryDatabase.counters()));
        return counters;
    }

    public Collection<Transaction> getTransactions() {
        return DatabaseManager.complete(this.transactionManager.getTransactions());
    }

    private static <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ConsistentMapException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new ConsistentMapException.Timeout();
        }
        catch (ExecutionException e) {
            throw new ConsistentMapException(e.getCause());
        }
    }

    public void redriveTransactions() {
        this.getTransactions().stream().forEach(this.transactionManager::execute);
    }

    protected <K, V> DefaultAsyncConsistentMap<K, V> registerMap(DefaultAsyncConsistentMap<K, V> map) {
        this.maps.put((Object)map.name(), map);
        if (map.applicationId() != null) {
            this.mapsByApplication.put((Object)map.applicationId(), map);
        }
        return map;
    }

    protected <K, V> void unregisterMap(DefaultAsyncConsistentMap<K, V> map) {
        this.maps.remove((Object)map.name(), map);
        if (map.applicationId() != null) {
            this.mapsByApplication.remove((Object)map.applicationId(), map);
        }
    }

    protected void bindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        this.clusterMetadataService = clusterMetadataService;
    }

    protected void unbindClusterMetadataService(ClusterMetadataService clusterMetadataService) {
        if (this.clusterMetadataService == clusterMetadataService) {
            this.clusterMetadataService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected void unbindPersistenceService(PersistenceService persistenceService) {
        if (this.persistenceService == persistenceService) {
            this.persistenceService = null;
        }
    }

    private class InternalApplicationListener
    implements ApplicationListener {
        private InternalApplicationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(ApplicationEvent event) {
            if (event.type() == ApplicationEvent.Type.APP_UNINSTALLED || event.type() == ApplicationEvent.Type.APP_DEACTIVATED) {
                ImmutableList mapsToRemove;
                ApplicationId appId = ((Application)event.subject()).id();
                Multimap multimap = DatabaseManager.this.mapsByApplication;
                synchronized (multimap) {
                    mapsToRemove = ImmutableList.copyOf((Collection)DatabaseManager.this.mapsByApplication.get((Object)appId));
                }
                mapsToRemove.forEach(DatabaseManager.this::unregisterMap);
                if (event.type() == ApplicationEvent.Type.APP_UNINSTALLED) {
                    mapsToRemove.stream().filter(map -> map.purgeOnUninstall()).forEach(map -> map.clear());
                }
            }
        }
    }
}

