/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.CompletableFuture;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.MeteringAgent;
import org.onosproject.store.service.AsyncAtomicCounter;

public class DefaultAsyncAtomicCounter
implements AsyncAtomicCounter {
    private final String name;
    private final Database database;
    private final MeteringAgent monitor;
    private static final String PRIMITIVE_NAME = "atomicCounter";
    private static final String INCREMENT_AND_GET = "incrementAndGet";
    private static final String GET_AND_INCREMENT = "getAndIncrement";
    private static final String GET_AND_ADD = "getAndAdd";
    private static final String ADD_AND_GET = "addAndGet";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String COMPARE_AND_SET = "compareAndSet";

    public DefaultAsyncAtomicCounter(String name, Database database, boolean meteringEnabled) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.database = (Database)Preconditions.checkNotNull((Object)database);
        this.monitor = new MeteringAgent(PRIMITIVE_NAME, name, meteringEnabled);
    }

    public CompletableFuture<Long> incrementAndGet() {
        MeteringAgent.Context timer = this.monitor.startTimer(INCREMENT_AND_GET);
        return this.addAndGet(1L).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Long> get() {
        MeteringAgent.Context timer = this.monitor.startTimer(GET);
        return this.database.counterGet(this.name).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Long> getAndIncrement() {
        MeteringAgent.Context timer = this.monitor.startTimer(GET_AND_INCREMENT);
        return this.getAndAdd(1L).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Long> getAndAdd(long delta) {
        MeteringAgent.Context timer = this.monitor.startTimer(GET_AND_ADD);
        return this.database.counterGetAndAdd(this.name, delta).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        MeteringAgent.Context timer = this.monitor.startTimer(ADD_AND_GET);
        return this.database.counterAddAndGet(this.name, delta).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Void> set(long value) {
        MeteringAgent.Context timer = this.monitor.startTimer(SET);
        return this.database.counterSet(this.name, value).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Boolean> compareAndSet(long expectedValue, long updateValue) {
        MeteringAgent.Context timer = this.monitor.startTimer(COMPARE_AND_SET);
        return this.database.counterCompareAndSet(this.name, expectedValue, updateValue).whenComplete((r, e) -> timer.stop((Throwable)e));
    }
}

