/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.onlab.util.HexString;
import org.onlab.util.SharedExecutors;
import org.onlab.util.Tools;
import org.onosproject.core.ApplicationId;
import org.onosproject.store.consistent.impl.CommitResponse;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.MappingSet;
import org.onosproject.store.consistent.impl.Match;
import org.onosproject.store.consistent.impl.MeteringAgent;
import org.onosproject.store.consistent.impl.Result;
import org.onosproject.store.consistent.impl.StateMachineUpdate;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.service.AsyncConsistentMap;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncConsistentMap<K, V>
implements AsyncConsistentMap<K, V> {
    private final String name;
    private final ApplicationId applicationId;
    private final Database database;
    private final Serializer serializer;
    private final boolean readOnly;
    private final boolean purgeOnUninstall;
    private static final String PRIMITIVE_NAME = "consistentMap";
    private static final String SIZE = "size";
    private static final String IS_EMPTY = "isEmpty";
    private static final String CONTAINS_KEY = "containsKey";
    private static final String CONTAINS_VALUE = "containsValue";
    private static final String GET = "get";
    private static final String COMPUTE_IF = "computeIf";
    private static final String PUT = "put";
    private static final String PUT_AND_GET = "putAndGet";
    private static final String PUT_IF_ABSENT = "putIfAbsent";
    private static final String REMOVE = "remove";
    private static final String CLEAR = "clear";
    private static final String KEY_SET = "keySet";
    private static final String VALUES = "values";
    private static final String ENTRY_SET = "entrySet";
    private static final String REPLACE = "replace";
    private static final String COMPUTE_IF_ABSENT = "computeIfAbsent";
    private final Set<MapEventListener<K, V>> listeners = new CopyOnWriteArraySet<MapEventListener<K, V>>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MeteringAgent monitor;
    private static final String ERROR_NULL_KEY = "Key cannot be null";
    private static final String ERROR_NULL_VALUE = "Null values are not allowed";
    private final LoadingCache<String, K> keyCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<String, K>(){

        public K load(String key) {
            return DefaultAsyncConsistentMap.this.serializer.decode(HexString.fromHexString((String)key));
        }
    });

    protected String sK(K key) {
        String s = HexString.toHexString((byte[])this.serializer.encode(key));
        this.keyCache.put((Object)s, key);
        return s;
    }

    protected K dK(String key) {
        return (K)this.keyCache.getUnchecked((Object)key);
    }

    public DefaultAsyncConsistentMap(String name, ApplicationId applicationId, Database database, Serializer serializer, boolean readOnly, boolean purgeOnUninstall, boolean meteringEnabled) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"map name cannot be null");
        this.applicationId = applicationId;
        this.database = (Database)Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.readOnly = readOnly;
        this.purgeOnUninstall = purgeOnUninstall;
        this.database.registerConsumer(update -> SharedExecutors.getSingleThreadExecutor().execute(() -> {
            if (this.listeners.isEmpty()) {
                return;
            }
            try {
                CommitResponse response;
                if (update.target() == StateMachineUpdate.Target.MAP_UPDATE) {
                    Result result = (Result)update.output();
                    if (result.success() && ((UpdateResult)result.value()).mapName().equals(name)) {
                        MapEvent<Object, Object> mapEvent = ((UpdateResult)result.value()).map(this::dK, v -> serializer.decode(Tools.copyOf((byte[])v))).toMapEvent();
                        this.notifyListeners(mapEvent);
                    }
                } else if (update.target() == StateMachineUpdate.Target.TX_COMMIT && (response = (CommitResponse)update.output()).success()) {
                    response.updates().forEach(u -> {
                        if (u.mapName().equals(name)) {
                            MapEvent<Object, Object> mapEvent = u.map(this::dK, v -> serializer.decode(Tools.copyOf((byte[])v))).toMapEvent();
                            this.notifyListeners(mapEvent);
                        }
                    });
                }
            }
            catch (Exception e) {
                this.log.warn("Error notifying listeners", (Throwable)e);
            }
        }));
        this.monitor = new MeteringAgent(PRIMITIVE_NAME, name, meteringEnabled);
    }

    public String name() {
        return this.name;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public ApplicationId applicationId() {
        return this.applicationId;
    }

    public boolean purgeOnUninstall() {
        return this.purgeOnUninstall;
    }

    public CompletableFuture<Integer> size() {
        MeteringAgent.Context timer = this.monitor.startTimer(SIZE);
        return this.database.mapSize(this.name).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Boolean> isEmpty() {
        MeteringAgent.Context timer = this.monitor.startTimer(IS_EMPTY);
        return this.database.mapIsEmpty(this.name).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS_KEY);
        return this.database.mapContainsKey(this.name, this.sK(key)).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        MeteringAgent.Context timer = this.monitor.startTimer(CONTAINS_VALUE);
        return this.database.mapContainsValue(this.name, this.serializer.encode(value)).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Versioned<V>> get(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        MeteringAgent.Context timer = this.monitor.startTimer(GET);
        return ((CompletableFuture)this.database.mapGet(this.name, this.sK(key)).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v != null ? v.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0)) : null);
    }

    public CompletableFuture<Versioned<V>> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(mappingFunction, (Object)"Mapping function cannot be null");
        MeteringAgent.Context timer = this.monitor.startTimer(COMPUTE_IF_ABSENT);
        return ((CompletableFuture)this.updateAndGet(key, Match.ifNull(), Match.any(), mappingFunction.apply(key)).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v.newValue());
    }

    public CompletableFuture<Versioned<V>> computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, Objects::nonNull, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.computeIf(key, v -> true, remappingFunction);
    }

    public CompletableFuture<Versioned<V>> computeIf(K key, Predicate<? super V> condition, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(condition, (Object)"predicate function cannot be null");
        Preconditions.checkNotNull(remappingFunction, (Object)"Remapping function cannot be null");
        MeteringAgent.Context timer = this.monitor.startTimer(COMPUTE_IF);
        return this.get(key).thenCompose(r1 -> {
            Object existingValue;
            Object object2 = existingValue = r1 == null ? null : r1.value();
            if (!condition.test((V)existingValue)) {
                return CompletableFuture.completedFuture(r1);
            }
            AtomicReference computedValue = new AtomicReference();
            try {
                computedValue.set(remappingFunction.apply((K)key, (V)existingValue));
            }
            catch (Exception e2) {
                return Tools.exceptionalFuture((Throwable)e2);
            }
            if (computedValue.get() == null && r1 == null) {
                return CompletableFuture.completedFuture(null);
            }
            Match valueMatcher = r1 == null ? Match.ifNull() : Match.any();
            Match<Long> versionMatcher = r1 == null ? Match.any() : Match.ifValue(r1.version());
            return ((CompletableFuture)this.updateAndGet(key, valueMatcher, versionMatcher, computedValue.get()).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> {
                if (v.updated()) {
                    return v.newValue();
                }
                throw new ConsistentMapException.ConcurrentModification("Concurrent update to " + this.name + " detected");
            });
        });
    }

    public CompletableFuture<Versioned<V>> put(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        MeteringAgent.Context timer = this.monitor.startTimer(PUT);
        return ((CompletableFuture)this.updateAndGet(key, Match.any(), Match.any(), value).thenApply(v -> v.oldValue())).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Versioned<V>> putAndGet(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        MeteringAgent.Context timer = this.monitor.startTimer(PUT_AND_GET);
        return ((CompletableFuture)this.updateAndGet(key, Match.any(), Match.any(), value).thenApply(v -> v.newValue())).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Versioned<V>> remove(K key) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return ((CompletableFuture)this.updateAndGet(key, Match.any(), Match.any(), null).thenApply(v -> v.oldValue())).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Void> clear() {
        this.checkIfUnmodifiable();
        MeteringAgent.Context timer = this.monitor.startTimer(CLEAR);
        return ((CompletableFuture)this.database.mapClear(this.name).thenApply(this::unwrapResult)).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Set<K>> keySet() {
        MeteringAgent.Context timer = this.monitor.startTimer(KEY_SET);
        return ((CompletableFuture)this.database.mapKeySet(this.name).thenApply(s -> this.newMappingKeySet((Set<String>)s))).whenComplete((r, e) -> timer.stop((Throwable)e));
    }

    public CompletableFuture<Collection<Versioned<V>>> values() {
        MeteringAgent.Context timer = this.monitor.startTimer(VALUES);
        return ((CompletableFuture)this.database.mapValues(this.name).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(c -> c.stream().map(v -> v.map(arg_0 -> ((Serializer)this.serializer).decode(arg_0))).collect(Collectors.toList()));
    }

    public CompletableFuture<Set<Map.Entry<K, Versioned<V>>>> entrySet() {
        MeteringAgent.Context timer = this.monitor.startTimer(ENTRY_SET);
        return ((CompletableFuture)this.database.mapEntrySet(this.name).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(s -> this.newMappingEntrySet((Set<Map.Entry<String, Versioned<byte[]>>>)s));
    }

    public CompletableFuture<Versioned<V>> putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        MeteringAgent.Context timer = this.monitor.startTimer(PUT_IF_ABSENT);
        return ((CompletableFuture)this.updateAndGet(key, Match.ifNull(), Match.any(), value).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v.oldValue());
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(value, (Object)ERROR_NULL_VALUE);
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return ((CompletableFuture)this.updateAndGet(key, Match.ifValue(value), Match.any(), null).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> remove(K key, long version) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        MeteringAgent.Context timer = this.monitor.startTimer(REMOVE);
        return ((CompletableFuture)this.updateAndGet(key, Match.any(), Match.ifValue(version), null).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, (Object)ERROR_NULL_KEY);
        Preconditions.checkNotNull(oldValue, (Object)ERROR_NULL_VALUE);
        Preconditions.checkNotNull(newValue, (Object)ERROR_NULL_VALUE);
        MeteringAgent.Context timer = this.monitor.startTimer(REPLACE);
        return ((CompletableFuture)this.updateAndGet(key, Match.ifValue(oldValue), Match.any(), newValue).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v.updated());
    }

    public CompletableFuture<Boolean> replace(K key, long oldVersion, V newValue) {
        MeteringAgent.Context timer = this.monitor.startTimer(REPLACE);
        return ((CompletableFuture)this.updateAndGet(key, Match.any(), Match.ifValue(oldVersion), newValue).whenComplete((r, e) -> timer.stop((Throwable)e))).thenApply(v -> v.updated());
    }

    protected void beforeUpdate(K key) {
        this.checkIfUnmodifiable();
    }

    private Set<K> newMappingKeySet(Set<String> s) {
        return new MappingSet<String, Object>(s, Collections::unmodifiableSet, this::sK, this::dK);
    }

    private Set<Map.Entry<K, Versioned<V>>> newMappingEntrySet(Set<Map.Entry<String, Versioned<byte[]>>> s) {
        return new MappingSet<Map.Entry, Map.Entry>(s, Collections::unmodifiableSet, this::reverseMapRawEntry, this::mapRawEntry);
    }

    private Map.Entry<K, Versioned<V>> mapRawEntry(Map.Entry<String, Versioned<byte[]>> e) {
        return Maps.immutableEntry(this.dK(e.getKey()), (Object)e.getValue().map(arg_0 -> ((Serializer)this.serializer).decode(arg_0)));
    }

    private Map.Entry<String, Versioned<byte[]>> reverseMapRawEntry(Map.Entry<K, Versioned<V>> e) {
        return Maps.immutableEntry((Object)this.sK(e.getKey()), (Object)e.getValue().map(arg_0 -> ((Serializer)this.serializer).encode(arg_0)));
    }

    private CompletableFuture<UpdateResult<K, V>> updateAndGet(K key, Match<V> oldValueMatch, Match<Long> oldVersionMatch, V value) {
        this.beforeUpdate(key);
        return ((CompletableFuture)this.database.mapUpdate(this.name, this.sK(key), oldValueMatch.map(arg_0 -> ((Serializer)this.serializer).encode(arg_0)), oldVersionMatch, value == null ? null : this.serializer.encode(value)).thenApply(this::unwrapResult)).thenApply(r -> r.map(this::dK, arg_0 -> ((Serializer)this.serializer).decode(arg_0)));
    }

    private <T> T unwrapResult(Result<T> result) {
        if (result.status() == Result.Status.LOCKED) {
            throw new ConsistentMapException.ConcurrentModification();
        }
        if (result.success()) {
            return result.value();
        }
        throw new IllegalStateException("Must not be here");
    }

    private void checkIfUnmodifiable() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    public void addListener(MapEventListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MapEventListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners(MapEvent<K, V> event) {
        if (event == null) {
            return;
        }
        this.listeners.forEach(listener -> {
            try {
                listener.event(event);
            }
            catch (Exception e) {
                this.log.warn("Failure notifying listener about {}", (Object)event, (Object)e);
            }
        });
    }
}

