/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import org.onlab.util.KryoNamespace;
import org.onosproject.store.consistent.impl.DatabaseManager;
import org.onosproject.store.consistent.impl.DefaultAtomicValue;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AtomicValue;
import org.onosproject.store.service.AtomicValueBuilder;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;

public class DefaultAtomicValueBuilder<V>
implements AtomicValueBuilder<V> {
    private Serializer serializer;
    private String name;
    private ConsistentMapBuilder<String, byte[]> mapBuilder;
    private boolean metering = true;

    public DefaultAtomicValueBuilder(DatabaseManager manager) {
        this.mapBuilder = manager.consistentMapBuilder().withName("onos-atomic-values").withMeteringDisabled().withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.BASIC));
    }

    public AtomicValueBuilder<V> withName(String name) {
        this.name = name;
        return this;
    }

    public AtomicValueBuilder<V> withSerializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public AtomicValueBuilder<V> withPartitionsDisabled() {
        this.mapBuilder.withPartitionsDisabled();
        return this;
    }

    public AtomicValueBuilder<V> withMeteringDisabled() {
        this.metering = false;
        return this;
    }

    public AtomicValue<V> build() {
        return new DefaultAtomicValue((ConsistentMap<String, byte[]>)this.mapBuilder.build(), this.name, this.metering, this.serializer);
    }
}

