/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import org.onosproject.store.consistent.impl.DatabaseManager;
import org.onosproject.store.consistent.impl.DefaultTransactionContext;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionContextBuilder;

public class DefaultTransactionContextBuilder
implements TransactionContextBuilder {
    private boolean partitionsEnabled = true;
    private final DatabaseManager manager;
    private final long transactionId;

    public DefaultTransactionContextBuilder(DatabaseManager manager, long transactionId) {
        this.manager = manager;
        this.transactionId = transactionId;
    }

    public TransactionContextBuilder withPartitionsDisabled() {
        this.partitionsEnabled = false;
        return this;
    }

    public TransactionContext build() {
        return new DefaultTransactionContext(this.transactionId, this.partitionsEnabled ? this.manager.partitionedDatabase : this.manager.inMemoryDatabase, () -> this.partitionsEnabled ? this.manager.consistentMapBuilder() : this.manager.consistentMapBuilder().withPartitionsDisabled());
    }
}

