/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class MappingSet<BACK, OUT>
implements Set<OUT> {
    private final Set<BACK> backedSet;
    private final Function<OUT, BACK> toBack;
    private final Function<BACK, OUT> toOut;

    public MappingSet(Set<BACK> backedSet, Function<Set<BACK>, Set<BACK>> supplier, Function<OUT, BACK> toBack, Function<BACK, OUT> toOut) {
        this.backedSet = supplier.apply(backedSet);
        this.toBack = toBack;
        this.toOut = toOut;
    }

    @Override
    public int size() {
        return this.backedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backedSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backedSet.contains(this.toBack.apply(o));
    }

    @Override
    public Iterator<OUT> iterator() {
        return Iterators.transform(this.backedSet.iterator(), this.toOut::apply);
    }

    @Override
    public Object[] toArray() {
        return this.backedSet.stream().map(this.toOut).toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backedSet.stream().map(this.toOut).toArray((int size) -> {
            if (size < a.length) {
                return new Object[size];
            }
            Arrays.fill(a, null);
            return a;
        });
    }

    @Override
    public boolean add(OUT e) {
        return this.backedSet.add(this.toBack.apply(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.backedSet.remove(this.toBack.apply(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().map(e -> this.toBack.apply(e)).allMatch(this.backedSet::contains);
    }

    @Override
    public boolean addAll(Collection<? extends OUT> c) {
        return this.backedSet.addAll(c.stream().map(this.toBack).collect(Collectors.toList()));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.backedSet.retainAll(c.stream().map(x -> this.toBack.apply(x)).collect(Collectors.toList()));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.backedSet.removeAll(c.stream().map(x -> this.toBack.apply(x)).collect(Collectors.toList()));
    }

    @Override
    public void clear() {
        this.backedSet.clear();
    }
}

