/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.consistent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kuujo.copycat.Task;
import net.kuujo.copycat.cluster.Cluster;
import net.kuujo.copycat.resource.ResourceState;
import net.kuujo.copycat.util.Managed;
import org.onosproject.store.consistent.impl.CommitResponse;
import org.onosproject.store.consistent.impl.Database;
import org.onosproject.store.consistent.impl.DefaultTransaction;
import org.onosproject.store.consistent.impl.Match;
import org.onosproject.store.consistent.impl.Partitioner;
import org.onosproject.store.consistent.impl.Result;
import org.onosproject.store.consistent.impl.SimpleKeyHashPartitioner;
import org.onosproject.store.consistent.impl.StateMachineUpdate;
import org.onosproject.store.consistent.impl.TransactionManager;
import org.onosproject.store.consistent.impl.UpdateResult;
import org.onosproject.store.service.DatabaseUpdate;
import org.onosproject.store.service.Transaction;
import org.onosproject.store.service.Versioned;

public class PartitionedDatabase
implements Database {
    private final String name;
    private final Partitioner<String> partitioner;
    private final List<Database> partitions;
    private final AtomicBoolean isOpen = new AtomicBoolean(false);
    private static final String DB_NOT_OPEN = "Partitioned Database is not open";
    private TransactionManager transactionManager;

    public PartitionedDatabase(String name, Collection<Database> partitions) {
        this.name = name;
        this.partitions = partitions.stream().sorted((db1, db2) -> db1.name().compareTo(db2.name())).collect(Collectors.toList());
        this.partitioner = new SimpleKeyHashPartitioner(this.partitions);
    }

    public List<Database> getPartitions() {
        return this.partitions;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    @Override
    public CompletableFuture<Set<String>> maps() {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        Set mapNames = Sets.newConcurrentHashSet();
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(db -> db.maps().thenApply(mapNames::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> mapNames);
    }

    @Override
    public CompletableFuture<Map<String, Long>> counters() {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        ConcurrentMap counters = Maps.newConcurrentMap();
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(db -> db.counters().thenApply(m -> {
            counters.putAll(m);
            return null;
        })).toArray(CompletableFuture[]::new)).thenApply(v -> counters);
    }

    @Override
    public CompletableFuture<Integer> mapSize(String mapName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        AtomicInteger totalSize = new AtomicInteger(0);
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(p -> p.mapSize(mapName).thenApply(totalSize::addAndGet)).toArray(CompletableFuture[]::new)).thenApply(v -> totalSize.get());
    }

    @Override
    public CompletableFuture<Boolean> mapIsEmpty(String mapName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.mapSize(mapName).thenApply(size -> size == 0);
    }

    @Override
    public CompletableFuture<Boolean> mapContainsKey(String mapName, String key) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(mapName, key).mapContainsKey(mapName, key);
    }

    @Override
    public CompletableFuture<Boolean> mapContainsValue(String mapName, byte[] value) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        AtomicBoolean containsValue = new AtomicBoolean(false);
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(p -> p.mapContainsValue(mapName, value).thenApply(v -> containsValue.compareAndSet(false, (boolean)v))).toArray(CompletableFuture[]::new)).thenApply(v -> containsValue.get());
    }

    @Override
    public CompletableFuture<Versioned<byte[]>> mapGet(String mapName, String key) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(mapName, key).mapGet(mapName, key);
    }

    @Override
    public CompletableFuture<Result<UpdateResult<String, byte[]>>> mapUpdate(String mapName, String key, Match<byte[]> valueMatch, Match<Long> versionMatch, byte[] value) {
        return this.partitioner.getPartition(mapName, key).mapUpdate(mapName, key, valueMatch, versionMatch, value);
    }

    @Override
    public CompletableFuture<Result<Void>> mapClear(String mapName) {
        AtomicBoolean isLocked = new AtomicBoolean(false);
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(p -> p.mapClear(mapName).thenApply(v -> isLocked.compareAndSet(false, Result.Status.LOCKED == v.status()))).toArray(CompletableFuture[]::new)).thenApply(v -> isLocked.get() ? Result.locked() : Result.ok(null));
    }

    @Override
    public CompletableFuture<Set<String>> mapKeySet(String mapName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        Set keySet = Sets.newConcurrentHashSet();
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(p -> p.mapKeySet(mapName).thenApply(keySet::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> keySet);
    }

    @Override
    public CompletableFuture<Collection<Versioned<byte[]>>> mapValues(String mapName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        CopyOnWriteArrayList values = new CopyOnWriteArrayList();
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(p -> p.mapValues(mapName).thenApply(values::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> values);
    }

    @Override
    public CompletableFuture<Set<Map.Entry<String, Versioned<byte[]>>>> mapEntrySet(String mapName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        Set entrySet = Sets.newConcurrentHashSet();
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(p -> p.mapEntrySet(mapName).thenApply(entrySet::addAll)).toArray(CompletableFuture[]::new)).thenApply(v -> entrySet);
    }

    @Override
    public CompletableFuture<Long> counterGet(String counterName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(counterName, counterName).counterGet(counterName);
    }

    @Override
    public CompletableFuture<Long> counterAddAndGet(String counterName, long delta) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(counterName, counterName).counterAddAndGet(counterName, delta);
    }

    @Override
    public CompletableFuture<Long> counterGetAndAdd(String counterName, long delta) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(counterName, counterName).counterGetAndAdd(counterName, delta);
    }

    @Override
    public CompletableFuture<Void> counterSet(String counterName, long value) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(counterName, counterName).counterSet(counterName, value);
    }

    @Override
    public CompletableFuture<Boolean> counterCompareAndSet(String counterName, long expectedValue, long updateValue) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(counterName, counterName).counterCompareAndSet(counterName, expectedValue, updateValue);
    }

    @Override
    public CompletableFuture<Long> queueSize(String queueName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(queueName, queueName).queueSize(queueName);
    }

    @Override
    public CompletableFuture<Void> queuePush(String queueName, byte[] entry) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(queueName, queueName).queuePush(queueName, entry);
    }

    @Override
    public CompletableFuture<byte[]> queuePop(String queueName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(queueName, queueName).queuePop(queueName);
    }

    @Override
    public CompletableFuture<byte[]> queuePeek(String queueName) {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return this.partitioner.getPartition(queueName, queueName).queuePeek(queueName);
    }

    @Override
    public CompletableFuture<CommitResponse> prepareAndCommit(Transaction transaction) {
        Map<Database, Transaction> subTransactions = this.createSubTransactions(transaction);
        if (subTransactions.isEmpty()) {
            return CompletableFuture.completedFuture(CommitResponse.success((List<UpdateResult<String, byte[]>>)ImmutableList.of()));
        }
        if (subTransactions.size() == 1) {
            Map.Entry<Database, Transaction> entry = subTransactions.entrySet().iterator().next();
            return entry.getKey().prepareAndCommit(entry.getValue());
        }
        if (this.transactionManager == null) {
            throw new IllegalStateException("TransactionManager is not initialized");
        }
        return this.transactionManager.execute(transaction);
    }

    @Override
    public CompletableFuture<Boolean> prepare(Transaction transaction) {
        Map<Database, Transaction> subTransactions = this.createSubTransactions(transaction);
        AtomicBoolean status = new AtomicBoolean(true);
        return CompletableFuture.allOf((CompletableFuture[])subTransactions.entrySet().stream().map(entry -> ((Database)entry.getKey()).prepare((Transaction)entry.getValue()).thenApply(v -> status.compareAndSet(true, (boolean)v))).toArray(CompletableFuture[]::new)).thenApply(v -> status.get());
    }

    @Override
    public CompletableFuture<CommitResponse> commit(Transaction transaction) {
        Map<Database, Transaction> subTransactions = this.createSubTransactions(transaction);
        AtomicBoolean success = new AtomicBoolean(true);
        ArrayList allUpdates = Lists.newArrayList();
        return CompletableFuture.allOf((CompletableFuture[])subTransactions.entrySet().stream().map(entry -> ((Database)entry.getKey()).commit((Transaction)entry.getValue()).thenAccept(response -> {
            success.set(success.get() && response.success());
            if (success.get()) {
                allUpdates.addAll(response.updates());
            }
        })).toArray(CompletableFuture[]::new)).thenApply(v -> success.get() ? CommitResponse.success(allUpdates) : CommitResponse.failure());
    }

    @Override
    public CompletableFuture<Boolean> rollback(Transaction transaction) {
        Map<Database, Transaction> subTransactions = this.createSubTransactions(transaction);
        return CompletableFuture.allOf((CompletableFuture[])subTransactions.entrySet().stream().map(entry -> ((Database)entry.getKey()).rollback((Transaction)entry.getValue())).toArray(CompletableFuture[]::new)).thenApply(v -> true);
    }

    public CompletableFuture<Database> open() {
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(Managed::open).toArray(CompletableFuture[]::new)).thenApply(v -> {
            this.isOpen.set(true);
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        Preconditions.checkState((boolean)this.isOpen.get(), (Object)DB_NOT_OPEN);
        return CompletableFuture.allOf((CompletableFuture[])this.partitions.stream().map(database -> database.close()).toArray(CompletableFuture[]::new));
    }

    public boolean isClosed() {
        return !this.isOpen.get();
    }

    public String name() {
        return this.name;
    }

    public Cluster cluster() {
        throw new UnsupportedOperationException();
    }

    public Database addStartupTask(Task<CompletableFuture<Void>> task) {
        throw new UnsupportedOperationException();
    }

    public Database addShutdownTask(Task<CompletableFuture<Void>> task) {
        throw new UnsupportedOperationException();
    }

    public ResourceState state() {
        throw new UnsupportedOperationException();
    }

    private Map<Database, Transaction> createSubTransactions(Transaction transaction) {
        HashMap perPartitionUpdates = Maps.newHashMap();
        for (DatabaseUpdate update : transaction.updates()) {
            Database partition = this.partitioner.getPartition(update.mapName(), update.key());
            List partitionUpdates = perPartitionUpdates.computeIfAbsent(partition, k -> Lists.newLinkedList());
            partitionUpdates.add(update);
        }
        HashMap subTransactions = Maps.newHashMap();
        perPartitionUpdates.forEach((k, v) -> {
            Transaction cfr_ignored_0 = subTransactions.put(k, new DefaultTransaction(transaction.id(), (List<DatabaseUpdate>)v));
        });
        return subTransactions;
    }

    protected void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public void registerConsumer(Consumer<StateMachineUpdate> consumer) {
        this.partitions.forEach(p -> p.registerConsumer(consumer));
    }

    @Override
    public void unregisterConsumer(Consumer<StateMachineUpdate> consumer) {
        this.partitions.forEach(p -> p.unregisterConsumer(consumer));
    }
}

