/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.annotations.Beta;
import java.util.HashSet;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.device.IntentSetMultimap;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
@Beta
public class ConsistentIntentSetMultimap
implements IntentSetMultimap {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String INTENT_MAPPING = "IntentMapping";
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespaces.API);
    private ConsistentMap<IntentId, Set<IntentId>> intentMapping;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.intentMapping = this.storageService.consistentMapBuilder().withName(INTENT_MAPPING).withSerializer(SERIALIZER).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public Set<IntentId> getMapping(IntentId intentId) {
        Versioned result = this.intentMapping.get((Object)intentId);
        if (result != null) {
            return (Set)result.value();
        }
        return null;
    }

    public boolean allocateMapping(IntentId keyIntentId, IntentId valIntentId) {
        Versioned versionedIntents = this.intentMapping.get((Object)keyIntentId);
        if (versionedIntents == null) {
            HashSet<IntentId> newSet = new HashSet<IntentId>();
            newSet.add(valIntentId);
            this.intentMapping.put((Object)keyIntentId, newSet);
        } else {
            ((Set)versionedIntents.value()).add(valIntentId);
        }
        return true;
    }

    public void releaseMapping(IntentId intentId) {
        for (IntentId intent : this.intentMapping.keySet()) {
            Set mapping = (Set)this.intentMapping.get((Object)intent).value();
            if (!mapping.remove(intentId)) continue;
            return;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

