/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.serializers.custom;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.MessageSubject;

public final class ClusterMessageSerializer
extends Serializer<ClusterMessage> {
    public ClusterMessageSerializer() {
        super(false);
    }

    public void write(Kryo kryo, Output output, ClusterMessage message) {
        kryo.writeClassAndObject(output, (Object)message.sender());
        kryo.writeClassAndObject(output, (Object)message.subject());
        output.writeInt(message.payload().length);
        output.writeBytes(message.payload());
    }

    public ClusterMessage read(Kryo kryo, Input input, Class<ClusterMessage> type) {
        NodeId sender = (NodeId)kryo.readClassAndObject(input);
        MessageSubject subject = (MessageSubject)kryo.readClassAndObject(input);
        int payloadSize = input.readInt();
        byte[] payload = input.readBytes(payloadSize);
        return new ClusterMessage(sender, subject, payload);
    }
}

