/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.impl.ClusterNodesDelegate;
import org.onosproject.store.cluster.messaging.impl.ClusterCommunicationManager;
import org.onosproject.store.cluster.messaging.impl.NettyMessagingManager;

public class ClusterCommunicationManagerTest {
    private static final NodeId N1 = new NodeId("n1");
    private static final NodeId N2 = new NodeId("n2");
    private static final int P1 = 9881;
    private static final int P2 = 9882;
    private static final IpAddress IP = IpAddress.valueOf((String)"127.0.0.1");
    private ClusterCommunicationManager ccm1;
    private ClusterCommunicationManager ccm2;
    private TestDelegate cnd1 = new TestDelegate();
    private TestDelegate cnd2 = new TestDelegate();
    private DefaultControllerNode node1 = new DefaultControllerNode(N1, IP, 9881);
    private DefaultControllerNode node2 = new DefaultControllerNode(N2, IP, 9882);

    @Before
    public void setUp() throws Exception {
        NettyMessagingManager messagingService = new NettyMessagingManager();
        messagingService.activate();
        this.ccm1 = new ClusterCommunicationManager();
        this.ccm1.activate();
        this.ccm2 = new ClusterCommunicationManager();
        this.ccm2.activate();
    }

    @After
    public void tearDown() {
        this.ccm1.deactivate();
        this.ccm2.deactivate();
    }

    @Ignore(value="FIXME: failing randomly?")
    @Test
    public void connect() throws Exception {
        this.cnd1.latch = new CountDownLatch(1);
        this.cnd2.latch = new CountDownLatch(1);
        this.validateDelegateEvent(this.cnd1, Op.DETECTED, this.node2.id());
        this.validateDelegateEvent(this.cnd2, Op.DETECTED, this.node1.id());
    }

    @Test
    @Ignore
    public void disconnect() throws Exception {
        this.cnd1.latch = new CountDownLatch(1);
        this.cnd2.latch = new CountDownLatch(1);
        this.validateDelegateEvent(this.cnd1, Op.DETECTED, this.node2.id());
        this.validateDelegateEvent(this.cnd2, Op.DETECTED, this.node1.id());
        this.cnd1.latch = new CountDownLatch(1);
        this.cnd2.latch = new CountDownLatch(1);
        this.ccm1.deactivate();
    }

    private void validateDelegateEvent(TestDelegate delegate, Op op, NodeId nodeId) throws InterruptedException {
        Assert.assertTrue((String)"did not connect in time", (boolean)delegate.latch.await(2500L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((String)"incorrect event", (Object)((Object)op), (Object)((Object)delegate.op));
        Assert.assertEquals((String)"incorrect event node", (Object)nodeId, (Object)delegate.nodeId);
    }

    private class TestDelegate
    implements ClusterNodesDelegate {
        Op op;
        CountDownLatch latch;
        NodeId nodeId;

        private TestDelegate() {
        }

        public DefaultControllerNode nodeDetected(NodeId nodeId, IpAddress ip, int tcpPort) {
            this.latch(nodeId, Op.DETECTED);
            return new DefaultControllerNode(nodeId, ip, tcpPort);
        }

        public void nodeVanished(NodeId nodeId) {
            this.latch(nodeId, Op.VANISHED);
        }

        public void nodeRemoved(NodeId nodeId) {
            this.latch(nodeId, Op.REMOVED);
        }

        private void latch(NodeId nodeId, Op op) {
            this.op = op;
            this.nodeId = nodeId;
            this.latch.countDown();
        }
    }

    static enum Op {
        DETECTED,
        VANISHED,
        REMOVED;

    }
}

