/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.group.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.TestUtils;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.DeviceId;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupEvent;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.group.GroupStoreDelegate;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.cluster.messaging.ClusterCommunicationServiceAdapter;
import org.onosproject.store.group.impl.DistributedGroupStore;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.TestStorageService;

public class DistributedGroupStoreTest {
    DeviceId deviceId1 = NetTestTools.did((String)"dev1");
    DeviceId deviceId2 = NetTestTools.did((String)"dev2");
    GroupId groupId1 = new DefaultGroupId(1);
    GroupId groupId2 = new DefaultGroupId(2);
    GroupId groupId3 = new DefaultGroupId(3);
    GroupKey groupKey1 = new DefaultGroupKey("abc".getBytes());
    GroupKey groupKey2 = new DefaultGroupKey("def".getBytes());
    GroupKey groupKey3 = new DefaultGroupKey("ghi".getBytes());
    TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
    GroupBucket selectGroupBucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment);
    GroupBucket failoverGroupBucket = DefaultGroupBucket.createFailoverGroupBucket((TrafficTreatment)this.treatment, (PortNumber)PortNumber.IN_PORT, (GroupId)this.groupId1);
    GroupBuckets buckets = new GroupBuckets((List)ImmutableList.of((Object)this.selectGroupBucket));
    GroupDescription groupDescription1 = new DefaultGroupDescription(this.deviceId1, GroupDescription.Type.INDIRECT, this.buckets, this.groupKey1, Integer.valueOf(this.groupId1.id()), NetTestTools.APP_ID);
    GroupDescription groupDescription2 = new DefaultGroupDescription(this.deviceId2, GroupDescription.Type.INDIRECT, this.buckets, this.groupKey2, Integer.valueOf(this.groupId2.id()), NetTestTools.APP_ID);
    GroupDescription groupDescription3 = new DefaultGroupDescription(this.deviceId2, GroupDescription.Type.INDIRECT, this.buckets, this.groupKey3, Integer.valueOf(this.groupId3.id()), NetTestTools.APP_ID);
    DistributedGroupStore groupStoreImpl;
    GroupStore groupStore;
    ConsistentMap auditPendingReqQueue;

    @Before
    public void setUp() throws Exception {
        this.groupStoreImpl = new DistributedGroupStore();
        this.groupStoreImpl.storageService = new TestStorageService();
        this.groupStoreImpl.clusterCommunicator = new ClusterCommunicationServiceAdapter();
        this.groupStoreImpl.mastershipService = new MasterOfAll();
        this.groupStoreImpl.activate();
        this.groupStore = this.groupStoreImpl;
        this.auditPendingReqQueue = (ConsistentMap)TestUtils.getField((Object)this.groupStoreImpl, (String)"auditPendingReqQueue");
    }

    @After
    public void tearDown() throws Exception {
        this.groupStoreImpl.deactivate();
    }

    @Test
    public void testEmptyStore() {
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupId1), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupKey1), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAddPendingGroup() throws Exception {
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)0));
        this.groupStore.storeGroupDescription(this.groupDescription1);
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupId1), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupKey1), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)1));
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testAddRemoveGroup() throws Exception {
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        MatcherAssert.assertThat((Object)this.groupStore.deviceInitialAuditStatus(this.deviceId1), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)0));
        this.groupStore.storeGroupDescription(this.groupDescription1);
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupId1), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupKey1), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)0));
        Group groupById = this.groupStore.getGroup(this.deviceId1, this.groupId1);
        Group groupByKey = this.groupStore.getGroup(this.deviceId1, this.groupKey1);
        MatcherAssert.assertThat((Object)groupById, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)groupByKey, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)groupById, (Matcher)Matchers.is((Object)groupByKey));
        MatcherAssert.assertThat((Object)groupById.deviceId(), (Matcher)Matchers.is((Object)NetTestTools.did((String)"dev1")));
        this.groupStore.removeGroupEntry(groupById);
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupId1), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.groupStore.getGroup(this.deviceId1, this.groupKey1), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRemoveGroupOnDevice() throws Exception {
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        MatcherAssert.assertThat((Object)this.groupStore.deviceInitialAuditStatus(this.deviceId1), (Matcher)Matchers.is((Object)true));
        this.groupStore.deviceInitialAuditCompleted(this.deviceId2, true);
        MatcherAssert.assertThat((Object)this.groupStore.deviceInitialAuditStatus(this.deviceId2), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.auditPendingReqQueue.size(), (Matcher)Matchers.is((Object)0));
        this.groupStore.storeGroupDescription(this.groupDescription1);
        this.groupStore.storeGroupDescription(this.groupDescription2);
        this.groupStore.storeGroupDescription(this.groupDescription3);
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId2), (Matcher)Matchers.is((Object)2));
        this.groupStore.purgeGroupEntry(this.deviceId2);
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId2), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testRemoveGroupDescription() throws Exception {
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        this.groupStore.storeGroupDescription(this.groupDescription1);
        this.groupStore.deleteGroupDescription(this.deviceId1, this.groupKey1);
        MatcherAssert.assertThat((Object)this.groupStore.getGroupCount(this.deviceId1), (Matcher)Matchers.is((Object)1));
        Group queriedGroup = this.groupStore.getGroup(this.deviceId1, this.groupId1);
        MatcherAssert.assertThat((Object)queriedGroup.state(), (Matcher)Matchers.is((Object)Group.GroupState.PENDING_DELETE));
    }

    @Test
    public void testPushGroupMetrics() {
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        this.groupStore.deviceInitialAuditCompleted(this.deviceId2, true);
        DefaultGroupDescription groupDescription3 = new DefaultGroupDescription(this.deviceId1, GroupDescription.Type.SELECT, this.buckets, (GroupKey)new DefaultGroupKey("aaa".getBytes()), null, NetTestTools.APP_ID);
        this.groupStore.storeGroupDescription(this.groupDescription1);
        this.groupStore.storeGroupDescription(this.groupDescription2);
        this.groupStore.storeGroupDescription((GroupDescription)groupDescription3);
        Group group1 = this.groupStore.getGroup(this.deviceId1, this.groupId1);
        MatcherAssert.assertThat((Object)group1, (Matcher)Matchers.instanceOf(DefaultGroup.class));
        DefaultGroup defaultGroup1 = (DefaultGroup)group1;
        defaultGroup1.setPackets(55L);
        defaultGroup1.setBytes(66L);
        this.groupStore.pushGroupMetrics(this.deviceId1, (Collection)ImmutableList.of((Object)group1));
        Group requeryGroup1 = this.groupStore.getGroup(this.deviceId1, this.groupId1);
        MatcherAssert.assertThat((Object)requeryGroup1.packets(), (Matcher)Matchers.is((Object)55L));
        MatcherAssert.assertThat((Object)requeryGroup1.bytes(), (Matcher)Matchers.is((Object)66L));
    }

    @Test
    public void testGroupOperationFailed() {
        TestDelegate delegate = new TestDelegate();
        this.groupStore.setDelegate((StoreDelegate)delegate);
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        this.groupStore.deviceInitialAuditCompleted(this.deviceId2, true);
        this.groupStore.storeGroupDescription(this.groupDescription1);
        this.groupStore.storeGroupDescription(this.groupDescription2);
        List<GroupEvent> eventsAfterAdds = delegate.eventsSeen();
        MatcherAssert.assertThat(eventsAfterAdds, (Matcher)Matchers.hasSize((int)2));
        eventsAfterAdds.stream().forEach(event -> MatcherAssert.assertThat((Object)event.type(), (Matcher)Matchers.is((Object)GroupEvent.Type.GROUP_ADD_REQUESTED)));
        delegate.resetEvents();
        GroupOperation opAdd = GroupOperation.createAddGroupOperation((GroupId)this.groupId1, (GroupDescription.Type)GroupDescription.Type.INDIRECT, (GroupBuckets)this.buckets);
        this.groupStore.groupOperationFailed(this.deviceId1, opAdd);
        List<GroupEvent> eventsAfterAddFailed = delegate.eventsSeen();
        MatcherAssert.assertThat(eventsAfterAddFailed, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)eventsAfterAddFailed.get(0).type(), (Matcher)Matchers.is((Object)GroupEvent.Type.GROUP_ADD_FAILED));
        MatcherAssert.assertThat((Object)eventsAfterAddFailed.get(1).type(), (Matcher)Matchers.is((Object)GroupEvent.Type.GROUP_REMOVED));
        delegate.resetEvents();
        GroupOperation opModify = GroupOperation.createModifyGroupOperation((GroupId)this.groupId2, (GroupDescription.Type)GroupDescription.Type.INDIRECT, (GroupBuckets)this.buckets);
        this.groupStore.groupOperationFailed(this.deviceId2, opModify);
        List<GroupEvent> eventsAfterModifyFailed = delegate.eventsSeen();
        MatcherAssert.assertThat(eventsAfterModifyFailed, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)eventsAfterModifyFailed.get(0).type(), (Matcher)Matchers.is((Object)GroupEvent.Type.GROUP_UPDATE_FAILED));
        delegate.resetEvents();
        GroupOperation opDelete = GroupOperation.createDeleteGroupOperation((GroupId)this.groupId2, (GroupDescription.Type)GroupDescription.Type.INDIRECT);
        this.groupStore.groupOperationFailed(this.deviceId2, opDelete);
        List<GroupEvent> eventsAfterDeleteFailed = delegate.eventsSeen();
        MatcherAssert.assertThat(eventsAfterDeleteFailed, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)eventsAfterDeleteFailed.get(0).type(), (Matcher)Matchers.is((Object)GroupEvent.Type.GROUP_REMOVE_FAILED));
        delegate.resetEvents();
    }

    @Test
    public void testExtraneousOperations() {
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        this.groupStore.storeGroupDescription(this.groupDescription1);
        Group group1 = this.groupStore.getGroup(this.deviceId1, this.groupId1);
        ArrayList extraneous = Lists.newArrayList((Iterable)this.groupStore.getExtraneousGroups(this.deviceId1));
        MatcherAssert.assertThat((Object)extraneous, (Matcher)Matchers.hasSize((int)0));
        this.groupStore.addOrUpdateExtraneousGroupEntry(group1);
        extraneous = Lists.newArrayList((Iterable)this.groupStore.getExtraneousGroups(this.deviceId1));
        MatcherAssert.assertThat((Object)extraneous, (Matcher)Matchers.hasSize((int)1));
        this.groupStore.removeExtraneousGroupEntry(group1);
        extraneous = Lists.newArrayList((Iterable)this.groupStore.getExtraneousGroups(this.deviceId1));
        MatcherAssert.assertThat((Object)extraneous, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testUpdateGroupDescription() {
        GroupBuckets buckets = new GroupBuckets((List)ImmutableList.of((Object)this.failoverGroupBucket));
        this.groupStore.deviceInitialAuditCompleted(this.deviceId1, true);
        this.groupStore.storeGroupDescription(this.groupDescription1);
        DefaultGroupKey newKey = new DefaultGroupKey("123".getBytes());
        this.groupStore.updateGroupDescription(this.deviceId1, this.groupKey1, GroupStore.UpdateType.ADD, buckets, (GroupKey)newKey);
        Group group1 = this.groupStore.getGroup(this.deviceId1, this.groupId1);
        MatcherAssert.assertThat((Object)group1.appCookie(), (Matcher)Matchers.is((Object)newKey));
        MatcherAssert.assertThat((Object)group1.buckets().buckets(), (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void testEqualsGroupStoreIdMapKey() {
        DistributedGroupStore.GroupStoreIdMapKey key1 = new DistributedGroupStore.GroupStoreIdMapKey(this.deviceId1, this.groupId1);
        DistributedGroupStore.GroupStoreIdMapKey sameAsKey1 = new DistributedGroupStore.GroupStoreIdMapKey(this.deviceId1, this.groupId1);
        DistributedGroupStore.GroupStoreIdMapKey key2 = new DistributedGroupStore.GroupStoreIdMapKey(this.deviceId2, this.groupId1);
        DistributedGroupStore.GroupStoreIdMapKey key3 = new DistributedGroupStore.GroupStoreIdMapKey(this.deviceId1, this.groupId2);
        new EqualsTester().addEqualityGroup(new Object[]{key1, sameAsKey1}).addEqualityGroup(new Object[]{key2}).addEqualityGroup(new Object[]{key3}).testEquals();
    }

    @Test
    public void testEqualsGroupStoreKeyMapKey() {
        DistributedGroupStore.GroupStoreKeyMapKey key1 = new DistributedGroupStore.GroupStoreKeyMapKey(this.deviceId1, this.groupKey1);
        DistributedGroupStore.GroupStoreKeyMapKey sameAsKey1 = new DistributedGroupStore.GroupStoreKeyMapKey(this.deviceId1, this.groupKey1);
        DistributedGroupStore.GroupStoreKeyMapKey key2 = new DistributedGroupStore.GroupStoreKeyMapKey(this.deviceId2, this.groupKey1);
        DistributedGroupStore.GroupStoreKeyMapKey key3 = new DistributedGroupStore.GroupStoreKeyMapKey(this.deviceId1, this.groupKey2);
        new EqualsTester().addEqualityGroup(new Object[]{key1, sameAsKey1}).addEqualityGroup(new Object[]{key2}).addEqualityGroup(new Object[]{key3}).testEquals();
    }

    @Test
    public void testEqualsGroupStoreMapKey() {
        DistributedGroupStore.GroupStoreMapKey key1 = new DistributedGroupStore.GroupStoreMapKey(this.deviceId1);
        DistributedGroupStore.GroupStoreMapKey sameAsKey1 = new DistributedGroupStore.GroupStoreMapKey(this.deviceId1);
        DistributedGroupStore.GroupStoreMapKey key2 = new DistributedGroupStore.GroupStoreMapKey(this.deviceId2);
        DistributedGroupStore.GroupStoreMapKey key3 = new DistributedGroupStore.GroupStoreMapKey(NetTestTools.did((String)"dev3"));
        new EqualsTester().addEqualityGroup(new Object[]{key1, sameAsKey1}).addEqualityGroup(new Object[]{key2}).addEqualityGroup(new Object[]{key3}).testEquals();
    }

    class TestDelegate
    implements GroupStoreDelegate {
        private List<GroupEvent> eventsSeen = new LinkedList<GroupEvent>();

        TestDelegate() {
        }

        public void notify(GroupEvent event) {
            this.eventsSeen.add(event);
        }

        public List<GroupEvent> eventsSeen() {
            return this.eventsSeen;
        }

        public void resetEvents() {
            this.eventsSeen.clear();
        }
    }

    static class MasterOfAll
    extends MastershipServiceAdapter {
        MasterOfAll() {
        }

        public MastershipRole getLocalRole(DeviceId deviceId) {
            return MastershipRole.MASTER;
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return new NodeId("foo");
        }
    }
}

