/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.region.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.util.ItemNotFoundException;
import org.onosproject.cluster.NodeId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionEvent;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionStoreDelegate;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.region.impl.DistributedRegionStore;
import org.onosproject.store.service.TestStorageService;

public class DistributedRegionStoreTest {
    private static final RegionId RID1 = RegionId.regionId((String)"r1");
    private static final RegionId RID2 = RegionId.regionId((String)"r2");
    private static final DeviceId DID1 = DeviceId.deviceId((String)"foo:d1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"foo:d2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"foo:d3");
    private static final NodeId NID1 = NodeId.nodeId((String)"n1");
    private static final List<Set<NodeId>> MASTERS = ImmutableList.of((Object)ImmutableSet.of((Object)NID1));
    private TestStore store;
    private RegionEvent event;

    @Before
    public void setUp() {
        this.store = new TestStore();
        this.store.storageService = new TestStorageService();
        this.store.setDelegate((StoreDelegate)((RegionStoreDelegate)e -> {
            this.event = e;
        }));
        this.store.activate();
    }

    @After
    public void tearDown() {
        this.store.deactivate();
    }

    @Test
    public void basics() {
        Region r1 = this.store.createRegion(RID1, "R1", Region.Type.METRO, MASTERS);
        Assert.assertEquals((String)"incorrect id", (Object)RID1, (Object)r1.id());
        Assert.assertEquals((String)"incorrect event", (Object)RegionEvent.Type.REGION_ADDED, (Object)this.event.type());
        Region r2 = this.store.createRegion(RID2, "R2", Region.Type.CAMPUS, MASTERS);
        Assert.assertEquals((String)"incorrect id", (Object)RID2, (Object)r2.id());
        Assert.assertEquals((String)"incorrect type", (Object)Region.Type.CAMPUS, (Object)r2.type());
        Assert.assertEquals((String)"incorrect event", (Object)RegionEvent.Type.REGION_ADDED, (Object)this.event.type());
        r2 = this.store.updateRegion(RID2, "R2", Region.Type.COUNTRY, MASTERS);
        Assert.assertEquals((String)"incorrect type", (Object)Region.Type.COUNTRY, (Object)r2.type());
        Assert.assertEquals((String)"incorrect event", (Object)RegionEvent.Type.REGION_UPDATED, (Object)this.event.type());
        Set regions = this.store.getRegions();
        Assert.assertEquals((String)"incorrect size", (long)2L, (long)regions.size());
        Assert.assertTrue((String)"missing r1", (boolean)regions.contains(r1));
        Assert.assertTrue((String)"missing r2", (boolean)regions.contains(r2));
        r1 = this.store.getRegion(RID1);
        Assert.assertEquals((String)"incorrect id", (Object)RID1, (Object)r1.id());
        this.store.removeRegion(RID1);
        regions = this.store.getRegions();
        Assert.assertEquals((String)"incorrect size", (long)1L, (long)regions.size());
        Assert.assertTrue((String)"missing r2", (boolean)regions.contains(r2));
        Assert.assertEquals((String)"incorrect event", (Object)RegionEvent.Type.REGION_REMOVED, (Object)this.event.type());
    }

    @Test(expected=IllegalArgumentException.class)
    public void duplicateCreate() {
        this.store.createRegion(RID1, "R1", Region.Type.METRO, MASTERS);
        this.store.createRegion(RID1, "R2", Region.Type.CAMPUS, MASTERS);
    }

    @Test(expected=ItemNotFoundException.class)
    public void missingUpdate() {
        this.store.updateRegion(RID1, "R1", Region.Type.METRO, MASTERS);
    }

    @Test
    public void membership() {
        Region r = this.store.createRegion(RID1, "R1", Region.Type.METRO, MASTERS);
        Assert.assertTrue((String)"no devices expected", (boolean)this.store.getRegionDevices(RID1).isEmpty());
        Assert.assertNull((String)"no region expected", (Object)this.store.getRegionForDevice(DID1));
        this.store.addDevices(RID1, (Collection)ImmutableSet.of((Object)DID1, (Object)DID2));
        Set deviceIds = this.store.getRegionDevices(RID1);
        Assert.assertEquals((String)"incorrect device count", (long)2L, (long)deviceIds.size());
        Assert.assertTrue((String)"missing d1", (boolean)deviceIds.contains(DID1));
        Assert.assertTrue((String)"missing d2", (boolean)deviceIds.contains(DID2));
        Assert.assertEquals((String)"wrong region", (Object)r, (Object)this.store.getRegionForDevice(DID1));
        this.store.addDevices(RID1, (Collection)ImmutableSet.of((Object)DID3));
        deviceIds = this.store.getRegionDevices(RID1);
        Assert.assertEquals((String)"incorrect device count", (long)3L, (long)deviceIds.size());
        Assert.assertTrue((String)"missing d3", (boolean)deviceIds.contains(DID3));
        this.store.addDevices(RID1, (Collection)ImmutableSet.of((Object)DID3, (Object)DID1));
        deviceIds = this.store.getRegionDevices(RID1);
        Assert.assertEquals((String)"incorrect device count", (long)3L, (long)deviceIds.size());
        Region r2 = this.store.createRegion(RID2, "R2", Region.Type.CAMPUS, MASTERS);
        this.store.addDevices(RID2, (Collection)ImmutableSet.of((Object)DID3));
        deviceIds = this.store.getRegionDevices(RID1);
        Assert.assertEquals((String)"incorrect device count", (long)2L, (long)deviceIds.size());
        deviceIds = this.store.getRegionDevices(RID2);
        Assert.assertEquals((String)"incorrect device count", (long)1L, (long)deviceIds.size());
        this.store.removeDevices(RID1, (Collection)ImmutableSet.of((Object)DID2, (Object)DID3));
        deviceIds = this.store.getRegionDevices(RID1);
        Assert.assertEquals((String)"incorrect device count", (long)1L, (long)deviceIds.size());
        Assert.assertTrue((String)"missing d1", (boolean)deviceIds.contains(DID1));
        this.store.removeDevices(RID1, (Collection)ImmutableSet.of((Object)DID1, (Object)DID3));
        Assert.assertTrue((String)"no devices expected", (boolean)this.store.getRegionDevices(RID1).isEmpty());
        this.store.removeDevices(RID1, (Collection)ImmutableSet.of((Object)DID2));
        Assert.assertTrue((String)"no devices expected", (boolean)this.store.getRegionDevices(RID1).isEmpty());
    }

    class TestStore
    extends DistributedRegionStore {
        TestStore() {
        }
    }
}

