/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.app;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.app.ApplicationDescription;
import org.onosproject.app.ApplicationEvent;
import org.onosproject.app.ApplicationException;
import org.onosproject.app.ApplicationState;
import org.onosproject.app.ApplicationStore;
import org.onosproject.app.ApplicationStoreDelegate;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.common.app.ApplicationArchive;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplication;
import org.onosproject.event.Event;
import org.onosproject.security.Permission;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class GossipApplicationStore
extends ApplicationArchive
implements ApplicationStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final MessageSubject APP_BITS_REQUEST = new MessageSubject("app-bits-request");
    private static final int MAX_LOAD_RETRIES = 5;
    private static final int RETRY_DELAY_MS = 2000;
    private static final int FETCH_TIMEOUT_MS = 10000;
    private static final int APP_LOAD_DELAY_MS = 500;
    private ScheduledExecutorService executor;
    private ExecutorService messageHandlingExecutor;
    private EventuallyConsistentMap<ApplicationId, Application> apps;
    private EventuallyConsistentMap<Application, InternalState> states;
    private EventuallyConsistentMap<Application, Set<Permission>> permissions;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService clusterCommunicator;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ApplicationIdStore idStore;
    private final Multimap<ApplicationId, ApplicationId> requiredBy = Multimaps.synchronizedSetMultimap((SetMultimap)Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet));
    private ApplicationId coreAppId;

    @Activate
    public void activate() {
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{InternalState.class});
        this.executor = Executors.newSingleThreadScheduledExecutor(Tools.groupedThreads((String)"onos/app", (String)"store"));
        this.messageHandlingExecutor = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/store/app", (String)"message-handler"));
        this.clusterCommunicator.addSubscriber(APP_BITS_REQUEST, bytes -> new String((byte[])bytes, Charsets.UTF_8), name -> {
            try {
                return ByteStreams.toByteArray((InputStream)this.getApplicationInputStream((String)name));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }, Function.identity(), (Executor)this.messageHandlingExecutor);
        this.apps = this.storageService.eventuallyConsistentMapBuilder().withName("apps").withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.states = this.storageService.eventuallyConsistentMapBuilder().withName("app-states").withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.states.addListener((EventuallyConsistentMapListener)new InternalAppStatesListener());
        this.permissions = this.storageService.eventuallyConsistentMapBuilder().withName("app-permissions").withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.coreAppId = this.getId("org.onosproject.core");
        this.log.info("Started");
    }

    private void loadFromDisk() {
        this.getApplicationNames().forEach(appName -> {
            Application app = this.loadFromDisk((String)appName);
            if (app != null && this.isActive(app.id().name())) {
                this.activate(app.id(), false);
            }
        });
    }

    private Application loadFromDisk(String appName) {
        for (int i = 0; i < 5; ++i) {
            try {
                Application application;
                ApplicationId appId = this.getId(appName);
                if (appId != null && (application = this.getApplication(appId)) != null) {
                    return application;
                }
                ApplicationDescription appDesc = this.getApplicationDescription(appName);
                boolean success = appDesc.requiredApps().stream().noneMatch(requiredApp -> this.loadFromDisk((String)requiredApp) == null);
                return success ? this.create(appDesc, false) : null;
            }
            catch (Exception e) {
                this.log.warn("Unable to load application {} from disk; retrying", (Object)appName);
                Tools.randomDelay((int)2000);
                continue;
            }
        }
        return null;
    }

    @Deactivate
    public void deactivate() {
        this.clusterCommunicator.removeSubscriber(APP_BITS_REQUEST);
        this.messageHandlingExecutor.shutdown();
        this.executor.shutdown();
        this.apps.destroy();
        this.states.destroy();
        this.permissions.destroy();
        this.log.info("Stopped");
    }

    public void setDelegate(ApplicationStoreDelegate delegate) {
        super.setDelegate((StoreDelegate)delegate);
        this.executor.schedule(() -> this.loadFromDisk(), 500L, TimeUnit.MILLISECONDS);
    }

    public Set<Application> getApplications() {
        return ImmutableSet.copyOf((Collection)this.apps.values());
    }

    public ApplicationId getId(String name) {
        return this.idStore.getAppId(name);
    }

    public Application getApplication(ApplicationId appId) {
        return (Application)this.apps.get((Object)appId);
    }

    public ApplicationState getState(ApplicationId appId) {
        InternalState s;
        Application app = (Application)this.apps.get((Object)appId);
        InternalState internalState = s = app == null ? null : (InternalState)((Object)this.states.get((Object)app));
        return s == null ? null : (s == InternalState.ACTIVATED ? ApplicationState.ACTIVE : ApplicationState.INSTALLED);
    }

    public Application create(InputStream appDescStream) {
        ApplicationDescription appDesc = this.saveApplication(appDescStream);
        if (this.hasPrerequisites(appDesc)) {
            return this.create(appDesc, true);
        }
        throw new ApplicationException("Missing dependencies for app " + appDesc.name());
    }

    private boolean hasPrerequisites(ApplicationDescription app) {
        return !app.requiredApps().stream().map(n -> this.getId((String)n)).anyMatch(id -> id == null || this.getApplication((ApplicationId)id) == null);
    }

    private Application create(ApplicationDescription appDesc, boolean updateTime) {
        Application app = this.registerApp(appDesc);
        if (updateTime) {
            this.updateTime(app.id().name());
        }
        this.apps.put((Object)app.id(), (Object)app);
        this.states.put((Object)app, (Object)InternalState.INSTALLED);
        return app;
    }

    public void remove(ApplicationId appId) {
        Application app = (Application)this.apps.get((Object)appId);
        if (app != null) {
            this.uninstallDependentApps(app);
            this.apps.remove((Object)appId);
            this.states.remove((Object)app);
            this.permissions.remove((Object)app);
        }
    }

    private void uninstallDependentApps(Application app) {
        this.getApplications().stream().filter(a -> a.requiredApps().contains(app.id().name())).forEach(a -> this.remove(a.id()));
    }

    public void activate(ApplicationId appId) {
        this.activate(appId, this.coreAppId);
    }

    private void activate(ApplicationId appId, ApplicationId forAppId) {
        this.requiredBy.put((Object)appId, (Object)forAppId);
        this.activate(appId, true);
    }

    private void activate(ApplicationId appId, boolean updateTime) {
        Application app = (Application)this.apps.get((Object)appId);
        if (app != null) {
            if (updateTime) {
                this.updateTime(appId.name());
            }
            this.activateRequiredApps(app);
            this.states.put((Object)app, (Object)InternalState.ACTIVATED);
        }
    }

    private void activateRequiredApps(Application app) {
        app.requiredApps().stream().map(this::getId).forEach(id -> this.activate((ApplicationId)id, app.id()));
    }

    public void deactivate(ApplicationId appId) {
        this.deactivateDependentApps(this.getApplication(appId));
        this.deactivate(appId, this.coreAppId);
    }

    private void deactivate(ApplicationId appId, ApplicationId forAppId) {
        Application app;
        this.requiredBy.remove((Object)appId, (Object)forAppId);
        if (this.requiredBy.get((Object)appId).isEmpty() && (app = (Application)this.apps.get((Object)appId)) != null) {
            this.updateTime(appId.name());
            this.states.put((Object)app, (Object)InternalState.DEACTIVATED);
            this.deactivateRequiredApps(app);
        }
    }

    private void deactivateDependentApps(Application app) {
        this.getApplications().stream().filter(a -> this.states.get(a) == InternalState.ACTIVATED).filter(a -> a.requiredApps().contains(app.id().name())).forEach(a -> this.deactivate(a.id()));
    }

    private void deactivateRequiredApps(Application app) {
        app.requiredApps().stream().map(this::getId).map(this::getApplication).filter(a -> this.states.get(a) == InternalState.ACTIVATED).forEach(a -> this.deactivate(a.id(), app.id()));
    }

    public Set<Permission> getPermissions(ApplicationId appId) {
        Application app = (Application)this.apps.get((Object)appId);
        return app != null ? (Set)this.permissions.get((Object)app) : null;
    }

    public void setPermissions(ApplicationId appId, Set<Permission> permissions) {
        Application app = this.getApplication(appId);
        if (app != null) {
            this.permissions.put((Object)app, permissions);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_PERMISSIONS_CHANGED, app));
        }
    }

    private boolean appBitsAvailable(Application app) {
        try {
            ApplicationDescription appDesc = this.getApplicationDescription(app.id().name());
            return appDesc.version().equals((Object)app.version());
        }
        catch (ApplicationException e) {
            return false;
        }
    }

    private void fetchBitsIfNeeded(Application app) {
        if (!this.appBitsAvailable(app)) {
            this.fetchBits(app);
        }
    }

    private void installAppIfNeeded(Application app) {
        if (!this.appBitsAvailable(app)) {
            this.fetchBits(app);
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, app));
        }
    }

    private void fetchBits(Application app) {
        ControllerNode localNode = this.clusterService.getLocalNode();
        CountDownLatch latch = new CountDownLatch(1);
        this.log.info("Downloading bits for application {}", (Object)app.id().name());
        for (ControllerNode node : this.clusterService.getNodes()) {
            if (latch.getCount() == 0L) break;
            if (node.equals(localNode)) continue;
            this.clusterCommunicator.sendAndReceive((Object)app.id().name(), APP_BITS_REQUEST, s -> s.getBytes(Charsets.UTF_8), Function.identity(), node.id()).whenCompleteAsync((bits, error) -> {
                if (error == null && latch.getCount() > 0L) {
                    this.saveApplication(new ByteArrayInputStream((byte[])bits));
                    this.log.info("Downloaded bits for application {} from node {}", (Object)app.id().name(), (Object)node.id());
                    latch.countDown();
                } else if (error != null) {
                    this.log.warn("Unable to fetch bits for application {} from node {}", (Object)app.id().name(), (Object)node.id());
                }
            }, (Executor)this.executor);
        }
        try {
            if (!latch.await(10000L, TimeUnit.MILLISECONDS)) {
                this.log.warn("Unable to fetch bits for application {}", (Object)app.id().name());
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted while fetching bits for application {}", (Object)app.id().name());
        }
    }

    private void pruneUninstalledApps() {
        for (String name : this.getApplicationNames()) {
            if (this.getApplication(this.getId(name)) != null) continue;
            Application app = this.registerApp(this.getApplicationDescription(name));
            ((ApplicationStoreDelegate)this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_UNINSTALLED, app));
            this.purgeApplication(app.id().name());
        }
    }

    private Application registerApp(ApplicationDescription appDesc) {
        ApplicationId appId = this.idStore.registerApplication(appDesc.name());
        return new DefaultApplication(appId, appDesc.version(), appDesc.title(), appDesc.description(), appDesc.origin(), appDesc.category(), appDesc.url(), appDesc.readme(), appDesc.icon(), appDesc.role(), appDesc.permissions(), appDesc.featuresRepo(), appDesc.features(), appDesc.requiredApps());
    }

    protected void bindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        this.clusterCommunicator = clusterCommunicationService;
    }

    protected void unbindClusterCommunicator(ClusterCommunicationService clusterCommunicationService) {
        if (this.clusterCommunicator == clusterCommunicationService) {
            this.clusterCommunicator = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    protected void bindIdStore(ApplicationIdStore applicationIdStore) {
        this.idStore = applicationIdStore;
    }

    protected void unbindIdStore(ApplicationIdStore applicationIdStore) {
        if (this.idStore == applicationIdStore) {
            this.idStore = null;
        }
    }

    private final class InternalAppStatesListener
    implements EventuallyConsistentMapListener<Application, InternalState> {
        private InternalAppStatesListener() {
        }

        public void event(EventuallyConsistentMapEvent<Application, InternalState> event) {
            if (GossipApplicationStore.this.delegate == null) {
                return;
            }
            Application app = (Application)event.key();
            InternalState state = (InternalState)((Object)event.value());
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                if (state == InternalState.INSTALLED) {
                    GossipApplicationStore.this.fetchBitsIfNeeded(app);
                    ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_INSTALLED, app));
                } else if (state == InternalState.ACTIVATED) {
                    GossipApplicationStore.this.installAppIfNeeded(app);
                    GossipApplicationStore.this.setActive(app.id().name());
                    ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_ACTIVATED, app));
                } else if (state == InternalState.DEACTIVATED) {
                    GossipApplicationStore.this.clearActive(app.id().name());
                    ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_DEACTIVATED, app));
                }
            } else if (event.type() == EventuallyConsistentMapEvent.Type.REMOVE) {
                ((ApplicationStoreDelegate)GossipApplicationStore.this.delegate).notify((Event)new ApplicationEvent(ApplicationEvent.Type.APP_UNINSTALLED, app));
                GossipApplicationStore.this.purgeApplication(app.id().name());
            }
        }
    }

    public static enum InternalState {
        INSTALLED,
        ACTIVATED,
        DEACTIVATED;

    }
}

