/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leader;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipStore;
import org.onosproject.cluster.LeadershipStoreDelegate;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true, enabled=true)
public class DistributedLeadershipStore
extends AbstractStore<LeadershipEvent, LeadershipStoreDelegate>
implements LeadershipStore {
    private static final Logger log = LoggerFactory.getLogger(DistributedLeadershipStore.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    protected NodeId localNodeId;
    protected ConsistentMap<String, InternalLeadership> leadershipMap;
    protected Map<String, Versioned<InternalLeadership>> leadershipCache = Maps.newConcurrentMap();
    private final MapEventListener<String, InternalLeadership> leadershipChangeListener = event -> {
        Leadership oldValue = InternalLeadership.toLeadership((InternalLeadership)Versioned.valueOrNull((Versioned)event.oldValue()));
        Leadership newValue = InternalLeadership.toLeadership((InternalLeadership)Versioned.valueOrNull((Versioned)event.newValue()));
        boolean leaderChanged = !Objects.equal((Object)(oldValue == null ? null : oldValue.leader()), (Object)newValue.leader());
        boolean candidatesChanged = !Sets.symmetricDifference((Set)Sets.newHashSet((Iterable)(oldValue == null ? ImmutableSet.of() : oldValue.candidates())), (Set)Sets.newHashSet((Iterable)newValue.candidates())).isEmpty();
        LeadershipEvent.Type eventType = null;
        if (leaderChanged && candidatesChanged) {
            eventType = LeadershipEvent.Type.LEADER_AND_CANDIDATES_CHANGED;
        }
        if (leaderChanged && !candidatesChanged) {
            eventType = LeadershipEvent.Type.LEADER_CHANGED;
        }
        if (!leaderChanged && candidatesChanged) {
            eventType = LeadershipEvent.Type.CANDIDATES_CHANGED;
        }
        this.leadershipCache.compute((String)event.key(), (k, v) -> {
            if (v == null || v.version() < event.newValue().version()) {
                return event.newValue();
            }
            return v;
        });
        this.notifyDelegate((Event)new LeadershipEvent(eventType, newValue));
    };

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leadershipMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-leadership")).withPartitionsDisabled()).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API, (Class[])new Class[]{InternalLeadership.class}))).build();
        this.leadershipMap.entrySet().forEach(e -> this.leadershipCache.put((String)e.getKey(), (Versioned<InternalLeadership>)e.getValue()));
        this.leadershipMap.addListener(this.leadershipChangeListener);
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.leadershipMap.removeListener(this.leadershipChangeListener);
        log.info("Stopped");
    }

    public Leadership addRegistration(String topic) {
        Versioned internalLeadership = this.leadershipMap.computeIf((Object)topic, v -> v == null || !v.candidates().contains(this.localNodeId), (k, v) -> {
            if (v == null || v.candidates().isEmpty()) {
                return new InternalLeadership(topic, this.localNodeId, v == null ? 1L : v.term() + 1L, System.currentTimeMillis(), (List<NodeId>)ImmutableList.of((Object)this.localNodeId));
            }
            ArrayList<NodeId> newCandidates = new ArrayList<NodeId>(v.candidates());
            newCandidates.add(this.localNodeId);
            return new InternalLeadership(topic, v.leader(), v.term(), v.termStartTime(), newCandidates);
        });
        return InternalLeadership.toLeadership((InternalLeadership)Versioned.valueOrNull((Versioned)internalLeadership));
    }

    public void removeRegistration(String topic) {
        this.removeRegistration(topic, this.localNodeId);
    }

    private void removeRegistration(String topic, NodeId nodeId) {
        this.leadershipMap.computeIf((Object)topic, v -> v != null && v.candidates().contains(nodeId), (k, v) -> {
            List<NodeId> newCandidates = v.candidates().stream().filter(id -> !nodeId.equals(id)).collect(Collectors.toList());
            NodeId newLeader = nodeId.equals((Object)v.leader()) ? (newCandidates.size() > 0 ? (NodeId)newCandidates.get(0) : null) : v.leader();
            long newTerm = newLeader == null || Objects.equal((Object)newLeader, (Object)v.leader()) ? v.term() : v.term() + 1L;
            long newTermStartTime = newLeader == null || Objects.equal((Object)newLeader, (Object)v.leader()) ? v.termStartTime() : System.currentTimeMillis();
            return new InternalLeadership(topic, newLeader, newTerm, newTermStartTime, newCandidates);
        });
    }

    public void removeRegistration(NodeId nodeId) {
        this.leadershipMap.entrySet().stream().filter(e -> ((InternalLeadership)((Versioned)e.getValue()).value()).candidates().contains(nodeId)).map(e -> (String)e.getKey()).forEach(topic -> this.removeRegistration((String)topic, nodeId));
    }

    public boolean moveLeadership(String topic, NodeId toNodeId) {
        Versioned internalLeadership = this.leadershipMap.computeIf((Object)topic, v -> v != null && v.candidates().contains(toNodeId) && !Objects.equal((Object)v.leader(), (Object)toNodeId), (k, v) -> {
            ArrayList<NodeId> newCandidates = new ArrayList<NodeId>();
            newCandidates.add(toNodeId);
            newCandidates.addAll(v.candidates().stream().filter(id -> !toNodeId.equals(id)).collect(Collectors.toList()));
            return new InternalLeadership(topic, toNodeId, v.term() + 1L, System.currentTimeMillis(), newCandidates);
        });
        return Objects.equal((Object)toNodeId, (Object)((InternalLeadership)Versioned.valueOrNull((Versioned)internalLeadership)).leader());
    }

    public boolean makeTopCandidate(String topic, NodeId nodeId) {
        Versioned internalLeadership = this.leadershipMap.computeIf((Object)topic, v -> v != null && v.candidates().contains(nodeId) && !v.candidates().get(0).equals((Object)nodeId), (k, v) -> {
            ArrayList<NodeId> newCandidates = new ArrayList<NodeId>();
            newCandidates.add(nodeId);
            newCandidates.addAll(v.candidates().stream().filter(id -> !nodeId.equals(id)).collect(Collectors.toList()));
            return new InternalLeadership(topic, v.leader(), v.term(), System.currentTimeMillis(), newCandidates);
        });
        return internalLeadership != null && nodeId.equals((Object)((InternalLeadership)internalLeadership.value()).candidates().get(0));
    }

    public Leadership getLeadership(String topic) {
        InternalLeadership internalLeadership = (InternalLeadership)Versioned.valueOrNull((Versioned)this.leadershipMap.get((Object)topic));
        return internalLeadership == null ? null : internalLeadership.asLeadership();
    }

    public Map<String, Leadership> getLeaderships() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.leadershipCache, v -> ((InternalLeadership)v.value()).asLeadership()));
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private static class InternalLeadership {
        private final String topic;
        private final NodeId leader;
        private final long term;
        private final long termStartTime;
        private final List<NodeId> candidates;

        public InternalLeadership(String topic, NodeId leader, long term, long termStartTime, List<NodeId> candidates) {
            this.topic = topic;
            this.leader = leader;
            this.term = term;
            this.termStartTime = termStartTime;
            this.candidates = ImmutableList.copyOf(candidates);
        }

        public NodeId leader() {
            return this.leader;
        }

        public long term() {
            return this.term;
        }

        public long termStartTime() {
            return this.termStartTime;
        }

        public List<NodeId> candidates() {
            return this.candidates;
        }

        public Leadership asLeadership() {
            return new Leadership(this.topic, this.leader == null ? null : new Leader(this.leader, this.term, this.termStartTime), this.candidates);
        }

        public static Leadership toLeadership(InternalLeadership internalLeadership) {
            return internalLeadership == null ? null : internalLeadership.asLeadership();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("leader", (Object)this.leader).add("term", this.term).add("termStartTime", this.termStartTime).add("candidates", this.candidates).toString();
        }
    }
}

