/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flow;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import org.onosproject.cluster.NodeId;

public final class ReplicaInfo {
    private final Optional<NodeId> master;
    private final List<NodeId> backups;

    public ReplicaInfo(NodeId master, List<NodeId> backups) {
        this.master = Optional.fromNullable((Object)master);
        this.backups = (List)Preconditions.checkNotNull(backups);
    }

    public Optional<NodeId> master() {
        return this.master;
    }

    public List<NodeId> backups() {
        return this.backups;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.master, this.backups});
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReplicaInfo)) {
            return false;
        }
        ReplicaInfo that = (ReplicaInfo)other;
        return Objects.equal(this.master, that.master) && Objects.equal(this.backups, that.backups);
    }

    private ReplicaInfo() {
        this.master = Optional.absent();
        this.backups = Collections.emptyList();
    }
}

