/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flowobjective.impl;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.Event;
import org.onosproject.net.behaviour.DefaultNextGroup;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.FlowObjectiveStoreDelegate;
import org.onosproject.net.flowobjective.ObjectiveEvent;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.service.AsyncAtomicCounter;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.AtomicCounterBuilder;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DistributedFlowObjectiveStore
extends AbstractStore<ObjectiveEvent, FlowObjectiveStoreDelegate>
implements FlowObjectiveStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ConsistentMap<Integer, byte[]> nextGroups;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private AtomicCounter nextIds;

    @Activate
    public void activate() {
        this.nextGroups = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("flowobjective-groups")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(new Class[]{byte[].class}).register(new Class[]{Versioned.class}).build()))).build();
        this.nextIds = ((AsyncAtomicCounter)((AtomicCounterBuilder)this.storageService.atomicCounterBuilder().withName("next-objective-counter")).build()).asAtomicCounter();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public void putNextGroup(Integer nextId, NextGroup group) {
        this.nextGroups.put((Object)nextId, (Object)group.data());
        this.notifyDelegate((Event)new ObjectiveEvent(ObjectiveEvent.Type.ADD, nextId));
    }

    public NextGroup getNextGroup(Integer nextId) {
        Versioned versionGroup = this.nextGroups.get((Object)nextId);
        if (versionGroup != null) {
            return new DefaultNextGroup((byte[])versionGroup.value());
        }
        return null;
    }

    public NextGroup removeNextGroup(Integer nextId) {
        Versioned versionGroup = this.nextGroups.remove((Object)nextId);
        if (versionGroup != null) {
            this.notifyDelegate((Event)new ObjectiveEvent(ObjectiveEvent.Type.REMOVE, nextId));
            return new DefaultNextGroup((byte[])versionGroup.value());
        }
        return null;
    }

    public int allocateNextId() {
        return (int)this.nextIds.incrementAndGet();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

