/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.group.impl;

import org.onosproject.net.DeviceId;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupStore;

public final class GroupStoreMessage {
    private final DeviceId deviceId;
    private final GroupKey appCookie;
    private final GroupDescription groupDesc;
    private final GroupStore.UpdateType updateType;
    private final GroupBuckets updateBuckets;
    private final GroupKey newAppCookie;
    private final Type type;

    private GroupStoreMessage(Type type, DeviceId deviceId, GroupKey appCookie, GroupDescription groupDesc, GroupStore.UpdateType updateType, GroupBuckets updateBuckets, GroupKey newAppCookie) {
        this.type = type;
        this.deviceId = deviceId;
        this.appCookie = appCookie;
        this.groupDesc = groupDesc;
        this.updateType = updateType;
        this.updateBuckets = updateBuckets;
        this.newAppCookie = newAppCookie;
    }

    public static GroupStoreMessage createGroupAddRequestMsg(DeviceId deviceId, GroupDescription desc) {
        return new GroupStoreMessage(Type.ADD, deviceId, null, desc, null, null, null);
    }

    public static GroupStoreMessage createGroupUpdateRequestMsg(DeviceId deviceId, GroupKey appCookie, GroupStore.UpdateType updateType, GroupBuckets updateBuckets, GroupKey newAppCookie) {
        return new GroupStoreMessage(Type.UPDATE, deviceId, appCookie, null, updateType, updateBuckets, newAppCookie);
    }

    public static GroupStoreMessage createGroupDeleteRequestMsg(DeviceId deviceId, GroupKey appCookie) {
        return new GroupStoreMessage(Type.DELETE, deviceId, appCookie, null, null, null, null);
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public GroupKey appCookie() {
        return this.appCookie;
    }

    public GroupDescription groupDesc() {
        return this.groupDesc;
    }

    public GroupBuckets updateBuckets() {
        return this.updateBuckets;
    }

    public GroupStore.UpdateType updateType() {
        return this.updateType;
    }

    public GroupKey newAppCookie() {
        return this.newAppCookie;
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        ADD,
        UPDATE,
        DELETE;

    }
}

