/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostStore;
import org.onosproject.net.host.HostStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedHostStore
extends AbstractStore<HostEvent, HostStoreDelegate>
implements HostStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<HostId, DefaultHost> host;
    private Map<HostId, DefaultHost> hosts;
    private final ConcurrentHashMap<HostId, DefaultHost> prevHosts = new ConcurrentHashMap();
    private MapEventListener<HostId, DefaultHost> hostLocationTracker = new HostLocationTracker();

    @Activate
    public void activate() {
        KryoNamespace.Builder hostSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API);
        this.host = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-hosts")).withRelaxedReadConsistency()).withSerializer(Serializer.using((KryoNamespace)hostSerializer.build()))).build();
        this.hosts = this.host.asJavaMap();
        this.prevHosts.putAll(this.hosts);
        this.host.addListener(this.hostLocationTracker);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.host.removeListener(this.hostLocationTracker);
        this.prevHosts.clear();
        this.log.info("Stopped");
    }

    private boolean shouldUpdate(DefaultHost existingHost, ProviderId providerId, HostId hostId, HostDescription hostDescription, boolean replaceIPs) {
        if (existingHost == null) {
            return true;
        }
        if (!(Objects.equals(existingHost.providerId(), providerId) && Objects.equals(existingHost.mac(), hostDescription.hwAddress()) && Objects.equals(existingHost.vlan(), hostDescription.vlan()) && Objects.equals(existingHost.location(), hostDescription.location()))) {
            return true;
        }
        if (replaceIPs ? !Objects.equals(hostDescription.ipAddress(), existingHost.ipAddresses()) : !existingHost.ipAddresses().containsAll(hostDescription.ipAddress())) {
            return true;
        }
        return hostDescription.annotations().keys().stream().anyMatch(k -> !Objects.equals(hostDescription.annotations().value(k), existingHost.annotations().value(k)));
    }

    public HostEvent createOrUpdateHost(ProviderId providerId, HostId hostId, HostDescription hostDescription, boolean replaceIPs) {
        Supplier<Versioned> supplier = () -> this.host.computeIf((Object)hostId, existingHost -> this.shouldUpdate((DefaultHost)existingHost, providerId, hostId, hostDescription, replaceIPs), (id, existingHost) -> {
            Object addresses;
            HostLocation location = hostDescription.location();
            if (existingHost == null || replaceIPs) {
                addresses = ImmutableSet.copyOf((Collection)hostDescription.ipAddress());
            } else {
                addresses = Sets.newHashSet((Iterable)existingHost.ipAddresses());
                addresses.addAll(hostDescription.ipAddress());
            }
            Object annotations = existingHost != null ? DefaultAnnotations.merge((DefaultAnnotations)((DefaultAnnotations)existingHost.annotations()), (SparseAnnotations)hostDescription.annotations()) : hostDescription.annotations();
            return new DefaultHost(providerId, hostId, hostDescription.hwAddress(), hostDescription.vlan(), location, (Set)addresses, new Annotations[]{annotations});
        });
        Tools.retryable(supplier, ConsistentMapException.ConcurrentModification.class, (int)Integer.MAX_VALUE, (int)50).get();
        return null;
    }

    public HostEvent removeHost(HostId hostId) {
        this.hosts.remove(hostId);
        return null;
    }

    public HostEvent removeIp(HostId hostId, IpAddress ipAddress) {
        this.hosts.compute(hostId, (id, existingHost) -> {
            if (existingHost != null) {
                Preconditions.checkState((boolean)Objects.equals(hostId.mac(), existingHost.mac()), (Object)"Existing and new MAC addresses differ.");
                Preconditions.checkState((boolean)Objects.equals(hostId.vlanId(), existingHost.vlan()), (Object)"Existing and new VLANs differ.");
                HashSet addresses = existingHost.ipAddresses();
                if (addresses != null && addresses.contains(ipAddress)) {
                    addresses = new HashSet(existingHost.ipAddresses());
                    addresses.remove(ipAddress);
                    return new DefaultHost(existingHost.providerId(), hostId, existingHost.mac(), existingHost.vlan(), existingHost.location(), (Set)ImmutableSet.copyOf(addresses), new Annotations[]{existingHost.annotations()});
                }
                return existingHost;
            }
            return null;
        });
        return null;
    }

    public int getHostCount() {
        return this.hosts.size();
    }

    public Iterable<Host> getHosts() {
        return ImmutableSet.copyOf(this.hosts.values());
    }

    public Host getHost(HostId hostId) {
        return (Host)this.hosts.get(hostId);
    }

    public Set<Host> getHosts(VlanId vlanId) {
        return this.filter(this.hosts.values(), host -> Objects.equals(host.vlan(), vlanId));
    }

    public Set<Host> getHosts(MacAddress mac) {
        return this.filter(this.hosts.values(), host -> Objects.equals(host.mac(), mac));
    }

    public Set<Host> getHosts(IpAddress ip) {
        return this.filter(this.hosts.values(), host -> host.ipAddresses().contains(ip));
    }

    public Set<Host> getConnectedHosts(ConnectPoint connectPoint) {
        Set filtered = this.hosts.entrySet().stream().filter(entry -> ((DefaultHost)entry.getValue()).location().equals((Object)connectPoint)).map(Map.Entry::getValue).collect(Collectors.toSet());
        return ImmutableSet.copyOf(filtered);
    }

    public Set<Host> getConnectedHosts(DeviceId deviceId) {
        Set filtered = this.hosts.entrySet().stream().filter(entry -> ((DefaultHost)entry.getValue()).location().deviceId().equals((Object)deviceId)).map(Map.Entry::getValue).collect(Collectors.toSet());
        return ImmutableSet.copyOf(filtered);
    }

    private Set<Host> filter(Collection<DefaultHost> collection, Predicate<DefaultHost> predicate) {
        return collection.stream().filter(predicate).collect(Collectors.toSet());
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class HostLocationTracker
    implements MapEventListener<HostId, DefaultHost> {
        private HostLocationTracker() {
        }

        public void event(MapEvent<HostId, DefaultHost> event) {
            DefaultHost host = (DefaultHost)Preconditions.checkNotNull((Object)event.value().value());
            Host prevHost = (Host)DistributedHostStore.this.prevHosts.put(host.id(), host);
            switch (event.type()) {
                case INSERT: {
                    DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_ADDED, (Host)host));
                    break;
                }
                case UPDATE: {
                    if (!Objects.equals(prevHost.location(), host.location())) {
                        DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_MOVED, (Host)host, prevHost));
                        break;
                    }
                    if (Objects.equals(prevHost, host)) break;
                    DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_UPDATED, (Host)host, prevHost));
                    break;
                }
                case REMOVE: {
                    if (DistributedHostStore.this.prevHosts.remove(host.id()) == null) break;
                    DistributedHostStore.this.notifyDelegate((Event)new HostEvent(HostEvent.Type.HOST_REMOVED, (Host)host));
                    break;
                }
                default: {
                    DistributedHostStore.this.log.warn("Unknown map event type: {}", (Object)event.type());
                }
            }
        }
    }
}

