/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.newresource.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.GuavaCollectors;
import org.onlab.util.Tools;
import org.onosproject.net.newresource.ContinuousResource;
import org.onosproject.net.newresource.ContinuousResourceId;
import org.onosproject.net.newresource.DiscreteResource;
import org.onosproject.net.newresource.DiscreteResourceId;
import org.onosproject.net.newresource.Resource;
import org.onosproject.net.newresource.ResourceAllocation;
import org.onosproject.net.newresource.ResourceConsumer;
import org.onosproject.net.newresource.ResourceEvent;
import org.onosproject.net.newresource.ResourceId;
import org.onosproject.net.newresource.ResourceStore;
import org.onosproject.net.newresource.ResourceStoreDelegate;
import org.onosproject.net.newresource.Resources;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.ConsistentMapException;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
@Beta
public class ConsistentResourceStore
extends AbstractStore<ResourceEvent, ResourceStoreDelegate>
implements ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(ConsistentResourceStore.class);
    private static final String DISCRETE_CONSUMER_MAP = "onos-discrete-consumers";
    private static final String CONTINUOUS_CONSUMER_MAP = "onos-continuous-consumers";
    private static final String CHILD_MAP = "onos-resource-children";
    private static final Serializer SERIALIZER = Serializer.using(Arrays.asList(KryoNamespaces.BASIC, KryoNamespaces.API), (Class[])new Class[]{ContinuousResourceAllocation.class});
    private static final int MAX_RETRIES = 5;
    private static final int RETRY_DELAY = 1000;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService service;
    private ConsistentMap<DiscreteResourceId, ResourceConsumer> discreteConsumers;
    private ConsistentMap<ContinuousResourceId, ContinuousResourceAllocation> continuousConsumers;
    private ConsistentMap<DiscreteResourceId, Set<Resource>> childMap;

    @Activate
    public void activate() {
        this.discreteConsumers = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.service.consistentMapBuilder().withName(DISCRETE_CONSUMER_MAP)).withSerializer(SERIALIZER)).build();
        this.continuousConsumers = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.service.consistentMapBuilder().withName(CONTINUOUS_CONSUMER_MAP)).withSerializer(SERIALIZER)).build();
        this.childMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.service.consistentMapBuilder().withName(CHILD_MAP)).withSerializer(SERIALIZER)).build();
        Tools.retryable(() -> this.childMap.put((Object)Resource.ROOT.id(), new LinkedHashSet()), ConsistentMapException.class, (int)5, (int)1000);
        log.info("Started");
    }

    public List<ResourceAllocation> getResourceAllocations(ResourceId id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((id instanceof DiscreteResourceId || id instanceof ContinuousResourceId ? 1 : 0) != 0);
        if (id instanceof DiscreteResourceId) {
            return this.getResourceAllocations((DiscreteResourceId)id);
        }
        return this.getResourceAllocations((ContinuousResourceId)id);
    }

    private List<ResourceAllocation> getResourceAllocations(DiscreteResourceId resource) {
        Versioned consumer = this.discreteConsumers.get((Object)resource);
        if (consumer == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new ResourceAllocation((Resource)Resources.discrete((DiscreteResourceId)resource).resource(), (ResourceConsumer)consumer.value()));
    }

    private List<ResourceAllocation> getResourceAllocations(ContinuousResourceId resource) {
        Versioned allocations = this.continuousConsumers.get((Object)resource);
        if (allocations == null) {
            return ImmutableList.of();
        }
        return (List)((ContinuousResourceAllocation)allocations.value()).allocations().stream().filter(x -> x.resource().id().equals(resource)).collect(GuavaCollectors.toImmutableList());
    }

    public boolean register(List<Resource> resources) {
        Preconditions.checkNotNull(resources);
        if (log.isTraceEnabled()) {
            resources.forEach(r -> log.trace("registering {}", r));
        }
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalMap childTxMap = tx.getTransactionalMap(CHILD_MAP, SERIALIZER);
        Map resourceMap = resources.stream().filter(x -> x.parent().isPresent()).collect(Collectors.groupingBy(x -> (DiscreteResource)x.parent().get(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : resourceMap.entrySet()) {
            if (!this.lookup((TransactionalMap<DiscreteResourceId, Set<Resource>>)childTxMap, (ResourceId)((DiscreteResource)entry.getKey()).id()).isPresent()) {
                return this.abortTransaction(tx);
            }
            if (this.appendValues((TransactionalMap<DiscreteResourceId, Set<Resource>>)childTxMap, ((DiscreteResource)entry.getKey()).id(), (List)entry.getValue())) continue;
            return this.abortTransaction(tx);
        }
        boolean success = tx.commit();
        if (success) {
            log.trace("Transaction commit succeeded on registration: resources={}", resources);
            List events = resources.stream().filter(x -> x.parent().isPresent()).map(x -> new ResourceEvent(ResourceEvent.Type.RESOURCE_ADDED, x)).collect(Collectors.toList());
            this.notifyDelegate(events);
        } else {
            log.debug("Transaction commit failed on registration: resources={}", resources);
        }
        return success;
    }

    public boolean unregister(List<ResourceId> ids) {
        Preconditions.checkNotNull(ids);
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalMap childTxMap = tx.getTransactionalMap(CHILD_MAP, SERIALIZER);
        TransactionalMap discreteConsumerTxMap = tx.getTransactionalMap(DISCRETE_CONSUMER_MAP, SERIALIZER);
        TransactionalMap continuousConsumerTxMap = tx.getTransactionalMap(CONTINUOUS_CONSUMER_MAP, SERIALIZER);
        List resources = ids.stream().filter(x -> x.parent().isPresent()).map(x -> {
            if (x instanceof DiscreteResourceId) {
                return Optional.of(Resources.discrete((DiscreteResourceId)((DiscreteResourceId)x)).resource());
            }
            return this.lookup((TransactionalMap<DiscreteResourceId, Set<Resource>>)childTxMap, (ResourceId)x);
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        Map resourceMap = resources.stream().collect(Collectors.groupingBy(x -> ((DiscreteResource)x.parent().get()).id(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : resourceMap.entrySet()) {
            boolean allocated = ((List)entry.getValue()).stream().anyMatch(x -> {
                if (x instanceof DiscreteResource) {
                    return discreteConsumerTxMap.get((Object)((DiscreteResource)x).id()) != null;
                }
                if (x instanceof ContinuousResource) {
                    ContinuousResourceAllocation allocations = (ContinuousResourceAllocation)continuousConsumerTxMap.get((Object)((ContinuousResource)x).id());
                    return allocations != null && !allocations.allocations().isEmpty();
                }
                return false;
            });
            if (allocated) {
                log.warn("Failed to unregister {}: allocation exists", entry.getKey());
                return this.abortTransaction(tx);
            }
            if (this.removeValues((TransactionalMap<DiscreteResourceId, Set<Resource>>)childTxMap, (DiscreteResourceId)entry.getKey(), (List)entry.getValue())) continue;
            log.warn("Failed to unregister {}: Failed to remove {} values.", entry.getKey(), (Object)((List)entry.getValue()).size());
            log.debug("Failed to unregister {}: Failed to remove values: {}", entry.getKey(), entry.getValue());
            return this.abortTransaction(tx);
        }
        boolean success = tx.commit();
        if (success) {
            List events = resources.stream().filter(x -> x.parent().isPresent()).map(x -> new ResourceEvent(ResourceEvent.Type.RESOURCE_REMOVED, x)).collect(Collectors.toList());
            this.notifyDelegate(events);
        } else {
            log.warn("Failed to unregister {}: Commit failed.", ids);
        }
        return success;
    }

    public boolean allocate(List<Resource> resources, ResourceConsumer consumer) {
        Preconditions.checkNotNull(resources);
        Preconditions.checkNotNull((Object)consumer);
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalMap childTxMap = tx.getTransactionalMap(CHILD_MAP, SERIALIZER);
        TransactionalMap discreteConsumerTxMap = tx.getTransactionalMap(DISCRETE_CONSUMER_MAP, SERIALIZER);
        TransactionalMap continuousConsumerTxMap = tx.getTransactionalMap(CONTINUOUS_CONSUMER_MAP, SERIALIZER);
        for (Resource resource : resources) {
            ContinuousResourceAllocation allocations;
            Optional<Resource> lookedUp = this.lookup((TransactionalMap<DiscreteResourceId, Set<Resource>>)childTxMap, resource.id());
            if (!lookedUp.isPresent()) {
                return this.abortTransaction(tx);
            }
            if (resource instanceof DiscreteResource) {
                ResourceConsumer oldValue = (ResourceConsumer)discreteConsumerTxMap.put((Object)((DiscreteResource)resource).id(), (Object)consumer);
                if (oldValue == null) continue;
                return this.abortTransaction(tx);
            }
            if (!(resource instanceof ContinuousResource)) continue;
            ContinuousResource continuous = (ContinuousResource)lookedUp.get();
            if (!this.hasEnoughResource(continuous, (ContinuousResource)resource, allocations = (ContinuousResourceAllocation)continuousConsumerTxMap.get((Object)continuous.id()))) {
                return this.abortTransaction(tx);
            }
            boolean success = this.appendValue((TransactionalMap<ContinuousResourceId, ContinuousResourceAllocation>)continuousConsumerTxMap, continuous, new ResourceAllocation((Resource)continuous, consumer));
            if (success) continue;
            return this.abortTransaction(tx);
        }
        return tx.commit();
    }

    public boolean release(List<ResourceAllocation> allocations) {
        Preconditions.checkNotNull(allocations);
        TransactionContext tx = (TransactionContext)this.service.transactionContextBuilder().build();
        tx.begin();
        TransactionalMap discreteConsumerTxMap = tx.getTransactionalMap(DISCRETE_CONSUMER_MAP, SERIALIZER);
        TransactionalMap continuousConsumerTxMap = tx.getTransactionalMap(CONTINUOUS_CONSUMER_MAP, SERIALIZER);
        for (ResourceAllocation allocation : allocations) {
            Resource resource = allocation.resource();
            ResourceConsumer consumer = allocation.consumer();
            if (resource instanceof DiscreteResource) {
                if (discreteConsumerTxMap.remove((Object)((DiscreteResource)resource).id(), (Object)consumer)) continue;
                return this.abortTransaction(tx);
            }
            if (!(resource instanceof ContinuousResource)) continue;
            ContinuousResource continuous = (ContinuousResource)resource;
            ContinuousResourceAllocation continuousAllocation = (ContinuousResourceAllocation)continuousConsumerTxMap.get((Object)continuous.id());
            ImmutableList newAllocations = (ImmutableList)continuousAllocation.allocations().stream().filter(x -> !x.consumer().equals(consumer) || ((ContinuousResource)x.resource()).value() != continuous.value()).collect(GuavaCollectors.toImmutableList());
            if (continuousConsumerTxMap.replace((Object)continuous.id(), (Object)continuousAllocation, (Object)new ContinuousResourceAllocation(continuousAllocation.original(), newAllocations))) continue;
            return this.abortTransaction(tx);
        }
        return tx.commit();
    }

    public boolean isAvailable(Resource resource) {
        Preconditions.checkNotNull((Object)resource);
        Preconditions.checkArgument((resource instanceof DiscreteResource || resource instanceof ContinuousResource ? 1 : 0) != 0);
        if (resource instanceof DiscreteResource) {
            return this.getResourceAllocations(resource.id()).isEmpty();
        }
        return this.isAvailable((ContinuousResource)resource);
    }

    private boolean isAvailable(ContinuousResource resource) {
        Versioned children = this.childMap.get((Object)((DiscreteResource)resource.parent().get()).id());
        if (children == null) {
            return false;
        }
        ContinuousResource registered = ((Set)children.value()).stream().filter(c -> c.id().equals(resource.id())).findFirst().map(c -> (ContinuousResource)c).get();
        if (registered.value() < resource.value()) {
            return false;
        }
        Versioned allocation = this.continuousConsumers.get((Object)resource.id());
        if (allocation == null) {
            return true;
        }
        return this.hasEnoughResource(((ContinuousResourceAllocation)allocation.value()).original(), resource, (ContinuousResourceAllocation)allocation.value());
    }

    public Collection<Resource> getResources(ResourceConsumer consumer) {
        Preconditions.checkNotNull((Object)consumer);
        Stream<DiscreteResource> discreteStream = this.discreteConsumers.entrySet().stream().filter(x -> ((ResourceConsumer)((Versioned)x.getValue()).value()).equals(consumer)).map(Map.Entry::getKey).map(x -> Resources.discrete((DiscreteResourceId)x).resource());
        Stream<ContinuousResource> continuousStream = this.continuousConsumers.values().stream().flatMap(x -> ((ContinuousResourceAllocation)x.value()).allocations().stream().map(y -> Maps.immutableEntry((Object)((ContinuousResourceAllocation)x.value()).original(), (Object)y))).filter(x -> ((ResourceAllocation)x.getValue()).consumer().equals(consumer)).map(x -> (ContinuousResource)x.getKey());
        return Stream.concat(discreteStream, continuousStream).collect(Collectors.toList());
    }

    public Set<Resource> getChildResources(DiscreteResourceId parent) {
        Preconditions.checkNotNull((Object)parent);
        Versioned children = this.childMap.get((Object)parent);
        if (children == null) {
            return ImmutableSet.of();
        }
        return (Set)children.value();
    }

    public <T> Collection<Resource> getAllocatedResources(DiscreteResourceId parent, Class<T> cls) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull(cls);
        Versioned children = this.childMap.get((Object)parent);
        if (children == null) {
            return ImmutableList.of();
        }
        Stream<DiscreteResource> discrete = ((Set)children.value()).stream().filter(x -> x.isTypeOf(cls)).filter(x -> x instanceof DiscreteResource).map(x -> (DiscreteResource)x).filter(x -> this.discreteConsumers.containsKey((Object)x.id()));
        Stream<ContinuousResource> continuous = ((Set)children.value()).stream().filter(x -> x.id().equals(parent.child(cls))).filter(x -> x instanceof ContinuousResource).map(x -> (ContinuousResource)x).filter(resource -> {
            Versioned allocation = this.continuousConsumers.get((Object)resource.id());
            if (allocation == null) {
                return false;
            }
            return !((ContinuousResourceAllocation)allocation.value()).allocations().isEmpty();
        });
        return Stream.concat(discrete, continuous).collect(Collectors.toList());
    }

    private boolean abortTransaction(TransactionContext tx) {
        tx.abort();
        return false;
    }

    private boolean appendValue(TransactionalMap<ContinuousResourceId, ContinuousResourceAllocation> map, ContinuousResource original, ResourceAllocation value) {
        ContinuousResourceAllocation oldValue = (ContinuousResourceAllocation)map.putIfAbsent((Object)original.id(), (Object)new ContinuousResourceAllocation(original, ImmutableList.of((Object)value)));
        if (oldValue == null) {
            return true;
        }
        if (oldValue.allocations().contains((Object)value)) {
            return true;
        }
        ContinuousResourceAllocation newValue = new ContinuousResourceAllocation(original, ImmutableList.builder().addAll((Iterable)oldValue.allocations()).add((Object)value).build());
        return map.replace((Object)original.id(), (Object)oldValue, (Object)newValue);
    }

    private boolean appendValues(TransactionalMap<DiscreteResourceId, Set<Resource>> map, DiscreteResourceId key, List<Resource> values) {
        LinkedHashSet<Resource> requested = new LinkedHashSet<Resource>(values);
        Set oldValues = (Set)map.putIfAbsent((Object)key, requested);
        if (oldValues == null) {
            return true;
        }
        Sets.SetView addedValues = Sets.difference(requested, (Set)oldValues);
        if (addedValues.isEmpty()) {
            return true;
        }
        Set addedIds = addedValues.stream().map(Resource::id).collect(Collectors.toSet());
        if (oldValues.stream().anyMatch(x -> addedIds.contains(x.id()))) {
            return false;
        }
        LinkedHashSet newValues = new LinkedHashSet(oldValues);
        newValues.addAll(addedValues);
        return map.replace((Object)key, (Object)oldValues, newValues);
    }

    private boolean removeValues(TransactionalMap<DiscreteResourceId, Set<Resource>> map, DiscreteResourceId key, List<Resource> values) {
        Set oldValues = (Set)map.putIfAbsent((Object)key, new LinkedHashSet());
        if (oldValues == null) {
            log.trace("No-Op removing values. key {} did not exist", (Object)key);
            return true;
        }
        if (values.stream().allMatch(x -> !oldValues.contains(x))) {
            log.trace("No-Op removing values. key {} did not contain {}", (Object)key, values);
            return true;
        }
        LinkedHashSet newValues = new LinkedHashSet(oldValues);
        newValues.removeAll(values);
        return map.replace((Object)key, (Object)oldValues, newValues);
    }

    private Optional<Resource> lookup(TransactionalMap<DiscreteResourceId, Set<Resource>> childTxMap, ResourceId id) {
        if (!id.parent().isPresent()) {
            return Optional.of(Resource.ROOT);
        }
        Set values = (Set)childTxMap.get(id.parent().get());
        if (values == null) {
            return Optional.empty();
        }
        if (id instanceof DiscreteResourceId) {
            DiscreteResource discrete = Resources.discrete((DiscreteResourceId)((DiscreteResourceId)id)).resource();
            if (values.contains(discrete)) {
                return Optional.of(discrete);
            }
            return Optional.empty();
        }
        return values.stream().filter(x -> x.id().equals(id)).findFirst();
    }

    private boolean hasEnoughResource(ContinuousResource original, ContinuousResource request, ContinuousResourceAllocation allocation) {
        if (allocation == null) {
            return request.value() <= original.value();
        }
        double allocated = allocation.allocations().stream().filter(x -> x.resource() instanceof ContinuousResource).map(x -> (ContinuousResource)x.resource()).mapToDouble(ContinuousResource::value).sum();
        double left = original.value() - allocated;
        return request.value() <= left;
    }

    protected void bindService(StorageService storageService) {
        this.service = storageService;
    }

    protected void unbindService(StorageService storageService) {
        if (this.service == storageService) {
            this.service = null;
        }
    }

    private static final class ContinuousResourceAllocation {
        private final ContinuousResource original;
        private final ImmutableList<ResourceAllocation> allocations;

        private ContinuousResourceAllocation(ContinuousResource original, ImmutableList<ResourceAllocation> allocations) {
            this.original = original;
            this.allocations = allocations;
        }

        private ContinuousResource original() {
            return this.original;
        }

        private ImmutableList<ResourceAllocation> allocations() {
            return this.allocations;
        }
    }
}

