/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.region.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Identifier;
import org.onlab.util.Tools;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.net.DeviceId;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionEvent;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionStore;
import org.onosproject.net.region.RegionStoreDelegate;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedRegionStore
extends AbstractStore<RegionEvent, RegionStoreDelegate>
implements RegionStore {
    private static final String NO_REGION = "Region does not exist";
    private static final String DUPLICATE_REGION = "Region already exists";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<RegionId, Region> regionsRepo;
    private Map<RegionId, Region> regionsById;
    private ConsistentMap<RegionId, Set<DeviceId>> membershipRepo;
    private Map<RegionId, Set<DeviceId>> regionDevices;
    private Map<DeviceId, Region> regionsByDevice = new HashMap<DeviceId, Region>();
    private final MapEventListener<RegionId, Region> listener = new InternalRegionListener();
    private final MapEventListener<RegionId, Set<DeviceId>> membershipListener = new InternalMembershipListener();

    @Activate
    protected void activate() {
        Serializer serializer = Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{Identifier.class, RegionId.class, Region.class, DefaultRegion.class, Region.Type.class});
        this.regionsRepo = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(serializer)).withName("onos-regions")).withRelaxedReadConsistency()).build();
        this.regionsRepo.addListener(this.listener);
        this.regionsById = this.regionsRepo.asJavaMap();
        this.membershipRepo = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(serializer)).withName("onos-region-devices")).withRelaxedReadConsistency()).build();
        this.membershipRepo.addListener(this.membershipListener);
        this.regionDevices = this.membershipRepo.asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.regionsRepo.removeListener(this.listener);
        this.membershipRepo.removeListener(this.membershipListener);
        this.regionsByDevice.clear();
        this.log.info("Stopped");
    }

    public Set<Region> getRegions() {
        return ImmutableSet.copyOf(this.regionsById.values());
    }

    public Region getRegion(RegionId regionId) {
        return (Region)Tools.nullIsNotFound((Object)this.regionsById.get(regionId), (String)NO_REGION);
    }

    public Region getRegionForDevice(DeviceId deviceId) {
        return this.regionsByDevice.get(deviceId);
    }

    public Set<DeviceId> getRegionDevices(RegionId regionId) {
        Set<DeviceId> deviceIds = this.regionDevices.get(regionId);
        return deviceIds != null ? ImmutableSet.copyOf(deviceIds) : ImmutableSet.of();
    }

    public Region createRegion(RegionId regionId, String name, Region.Type type, List<Set<NodeId>> masterNodeIds) {
        return (Region)this.regionsRepo.compute((Object)regionId, (id, region) -> {
            Preconditions.checkArgument((region == null ? 1 : 0) != 0, (Object)DUPLICATE_REGION);
            return new DefaultRegion(regionId, name, type, masterNodeIds);
        }).value();
    }

    public Region updateRegion(RegionId regionId, String name, Region.Type type, List<Set<NodeId>> masterNodeIds) {
        return (Region)this.regionsRepo.compute((Object)regionId, (id, region) -> {
            Tools.nullIsNotFound((Object)region, (String)NO_REGION);
            return new DefaultRegion(regionId, name, type, masterNodeIds);
        }).value();
    }

    public void removeRegion(RegionId regionId) {
        this.membershipRepo.remove((Object)regionId);
        this.regionsRepo.remove((Object)regionId);
    }

    public void addDevices(RegionId regionId, Collection<DeviceId> deviceIds) {
        for (DeviceId deviceId2 : deviceIds) {
            Region region = this.getRegionForDevice(deviceId2);
            if (region == null || ((String)regionId.id()).equals(region.id().id())) continue;
            ImmutableSet deviceIdSet1 = ImmutableSet.of((Object)deviceId2);
            this.removeDevices(region.id(), (Collection<DeviceId>)deviceIdSet1);
        }
        this.membershipRepo.compute((Object)regionId, (id, existingDevices) -> {
            if (existingDevices == null) {
                return ImmutableSet.copyOf((Collection)deviceIds);
            }
            if (!existingDevices.containsAll(deviceIds)) {
                return ImmutableSet.builder().addAll((Iterable)existingDevices).addAll((Iterable)deviceIds).build();
            }
            return existingDevices;
        });
        Region region = this.regionsById.get(regionId);
        deviceIds.forEach(deviceId -> this.regionsByDevice.put((DeviceId)deviceId, region));
    }

    public void removeDevices(RegionId regionId, Collection<DeviceId> deviceIds) {
        this.membershipRepo.compute((Object)regionId, (id, existingDevices) -> {
            if (existingDevices == null || existingDevices.isEmpty()) {
                return ImmutableSet.of();
            }
            return ImmutableSet.builder().addAll((Iterable)Sets.difference((Set)existingDevices, (Set)ImmutableSet.copyOf((Collection)deviceIds))).build();
        });
        deviceIds.forEach(deviceId -> this.regionsByDevice.remove(deviceId));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InternalMembershipListener
    implements MapEventListener<RegionId, Set<DeviceId>> {
        private InternalMembershipListener() {
        }

        public void event(MapEvent<RegionId, Set<DeviceId>> event) {
            if (event.type() != MapEvent.Type.REMOVE) {
                DistributedRegionStore.this.notifyDelegate((Event)new RegionEvent(RegionEvent.Type.REGION_MEMBERSHIP_CHANGED, (Region)DistributedRegionStore.this.regionsById.get(event.key()), (Set)event.newValue().value()));
            }
        }
    }

    private class InternalRegionListener
    implements MapEventListener<RegionId, Region> {
        private InternalRegionListener() {
        }

        public void event(MapEvent<RegionId, Region> event) {
            Region region = null;
            RegionEvent.Type type = null;
            switch (event.type()) {
                case INSERT: {
                    type = RegionEvent.Type.REGION_ADDED;
                    region = (Region)Preconditions.checkNotNull((Object)event.newValue().value());
                    break;
                }
                case UPDATE: {
                    type = RegionEvent.Type.REGION_UPDATED;
                    region = (Region)Preconditions.checkNotNull((Object)event.newValue().value());
                    break;
                }
                case REMOVE: {
                    type = RegionEvent.Type.REGION_REMOVED;
                    region = (Region)Preconditions.checkNotNull((Object)event.oldValue().value());
                    break;
                }
                default: {
                    DistributedRegionStore.this.log.error("Unsupported event type: " + event.type());
                }
            }
            DistributedRegionStore.this.notifyDelegate((Event)new RegionEvent(type, region));
        }
    }
}

