/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.Bandwidth;
import org.onlab.util.KryoNamespace;
import org.onlab.util.PositionalParameterStringFormatter;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.OmsPort;
import org.onosproject.net.Port;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceAllocationException;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.resource.link.BandwidthResource;
import org.onosproject.net.resource.link.BandwidthResourceAllocation;
import org.onosproject.net.resource.link.LambdaResource;
import org.onosproject.net.resource.link.LambdaResourceAllocation;
import org.onosproject.net.resource.link.LinkResourceAllocations;
import org.onosproject.net.resource.link.LinkResourceEvent;
import org.onosproject.net.resource.link.LinkResourceStore;
import org.onosproject.net.resource.link.LinkResourceStoreDelegate;
import org.onosproject.net.resource.link.MplsLabel;
import org.onosproject.net.resource.link.MplsLabelResourceAllocation;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(immediate=true, enabled=true)
@Service
public class ConsistentLinkResourceStore
extends AbstractStore<LinkResourceEvent, LinkResourceStoreDelegate>
implements LinkResourceStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final BandwidthResource DEFAULT_BANDWIDTH = new BandwidthResource(Bandwidth.mbps((long)1000L));
    private static final BandwidthResource EMPTY_BW = new BandwidthResource(Bandwidth.bps((long)0L));
    private static final int MIN_UNRESERVED_LABEL = 16;
    private static final int MAX_UNRESERVED_LABEL = 239;
    private static final String LINK_RESOURCE_ALLOCATIONS = "LinkAllocations";
    private static final String INTENT_ALLOCATIONS = "LinkIntentAllocations";
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)KryoNamespaces.API);
    private ConsistentMap<IntentId, LinkResourceAllocations> intentAllocMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;

    @Activate
    public void activate() {
        this.intentAllocMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName(INTENT_ALLOCATIONS)).withSerializer(SERIALIZER)).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    private TransactionalMap<IntentId, LinkResourceAllocations> getIntentAllocs(TransactionContext tx) {
        return tx.getTransactionalMap(INTENT_ALLOCATIONS, SERIALIZER);
    }

    private TransactionalMap<LinkKey, List<LinkResourceAllocations>> getLinkAllocs(TransactionContext tx) {
        return tx.getTransactionalMap(LINK_RESOURCE_ALLOCATIONS, SERIALIZER);
    }

    private TransactionContext getTxContext() {
        return (TransactionContext)this.storageService.transactionContextBuilder().build();
    }

    private Set<ResourceAllocation> getResourceCapacity(ResourceType type, Link link) {
        switch (type) {
            case BANDWIDTH: {
                return ImmutableSet.of((Object)this.getBandwidthResourceCapacity(link));
            }
            case LAMBDA: {
                return this.getLambdaResourceCapacity(link);
            }
            case MPLS_LABEL: {
                return this.getMplsResourceCapacity();
            }
        }
        return ImmutableSet.of();
    }

    private Set<ResourceAllocation> getLambdaResourceCapacity(Link link) {
        Port port = this.deviceService.getPort(link.src().deviceId(), link.src().port());
        if (!(port instanceof OmsPort)) {
            return Collections.emptySet();
        }
        OmsPort omsPort = (OmsPort)port;
        HashSet<ResourceAllocation> allocations = new HashSet<ResourceAllocation>();
        for (int i = 0; i < omsPort.totalChannels(); ++i) {
            allocations.add((ResourceAllocation)new LambdaResourceAllocation(LambdaResource.valueOf((int)i)));
        }
        return allocations;
    }

    private BandwidthResourceAllocation getBandwidthResourceCapacity(Link link) {
        BandwidthResource bandwidth = DEFAULT_BANDWIDTH;
        String strBw = link.annotations().value("bandwidth");
        if (strBw == null) {
            return new BandwidthResourceAllocation(bandwidth);
        }
        try {
            bandwidth = new BandwidthResource(Bandwidth.mbps((double)Double.parseDouble(strBw)));
        }
        catch (NumberFormatException e) {
            bandwidth = DEFAULT_BANDWIDTH;
        }
        return new BandwidthResourceAllocation(bandwidth);
    }

    private Set<ResourceAllocation> getMplsResourceCapacity() {
        HashSet<ResourceAllocation> allocations = new HashSet<ResourceAllocation>();
        for (int i = 16; i <= 239; ++i) {
            allocations.add((ResourceAllocation)new MplsLabelResourceAllocation(MplsLabel.valueOf((int)i)));
        }
        return allocations;
    }

    private Map<ResourceType, Set<ResourceAllocation>> getResourceCapacity(Link link) {
        HashMap<ResourceType, Set<ResourceAllocation>> caps = new HashMap<ResourceType, Set<ResourceAllocation>>();
        for (ResourceType type : ResourceType.values()) {
            Set<ResourceAllocation> cap = this.getResourceCapacity(type, link);
            caps.put(type, cap);
        }
        return caps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ResourceAllocation> getFreeResources(Link link) {
        TransactionContext tx = this.getTxContext();
        tx.begin();
        try {
            Map<ResourceType, Set<ResourceAllocation>> freeResources = this.getFreeResourcesEx(tx, link);
            Set<ResourceAllocation> set = freeResources.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            return set;
        }
        finally {
            tx.abort();
        }
    }

    private Map<ResourceType, Set<ResourceAllocation>> getFreeResourcesEx(TransactionContext tx, Link link) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)link);
        HashMap<ResourceType, Set<ResourceAllocation>> free = new HashMap<ResourceType, Set<ResourceAllocation>>();
        Map<ResourceType, Set<ResourceAllocation>> caps = this.getResourceCapacity(link);
        ImmutableList allocations = ImmutableList.copyOf(this.getAllocations(tx, link));
        Set<ResourceAllocation> bw = caps.get(ResourceType.BANDWIDTH);
        Set<ResourceAllocation> value = this.getFreeBandwidthResources(link, bw, (List<LinkResourceAllocations>)allocations);
        free.put(ResourceType.BANDWIDTH, value);
        Set<ResourceAllocation> lmd = caps.get(ResourceType.LAMBDA);
        Set<ResourceAllocation> freeL = this.getFreeResources(link, lmd, (List<LinkResourceAllocations>)allocations, LambdaResourceAllocation.class);
        free.put(ResourceType.LAMBDA, freeL);
        Set<ResourceAllocation> mpls = caps.get(ResourceType.MPLS_LABEL);
        Set<ResourceAllocation> freeLabel = this.getFreeResources(link, mpls, (List<LinkResourceAllocations>)allocations, MplsLabelResourceAllocation.class);
        free.put(ResourceType.MPLS_LABEL, freeLabel);
        return free;
    }

    private Set<ResourceAllocation> getFreeBandwidthResources(Link link, Set<ResourceAllocation> bw, List<LinkResourceAllocations> allocations) {
        if (bw == null || bw.isEmpty()) {
            bw = Sets.newHashSet((Object[])new ResourceAllocation[]{new BandwidthResourceAllocation(EMPTY_BW)});
        }
        BandwidthResourceAllocation cap = (BandwidthResourceAllocation)bw.iterator().next();
        double freeBw = cap.bandwidth().toDouble();
        double allocatedBw = allocations.stream().flatMap(x -> x.getResourceAllocation(link).stream()).filter(x -> x instanceof BandwidthResourceAllocation).map(x -> (BandwidthResourceAllocation)x).mapToDouble(x -> x.bandwidth().toDouble()).sum();
        return Sets.newHashSet((Object[])new ResourceAllocation[]{new BandwidthResourceAllocation(new BandwidthResource(Bandwidth.bps((double)(freeBw -= allocatedBw))))});
    }

    private Set<ResourceAllocation> getFreeResources(Link link, Set<ResourceAllocation> resources, List<LinkResourceAllocations> allocations, Class<? extends ResourceAllocation> cls) {
        if (resources == null || resources.isEmpty()) {
            return Collections.emptySet();
        }
        Set<ResourceAllocation> freeL = resources.stream().filter(cls::isInstance).collect(Collectors.toSet());
        List allocated = allocations.stream().flatMap(x -> x.getResourceAllocation(link).stream()).filter(cls::isInstance).collect(Collectors.toList());
        freeL.removeAll(allocated);
        return freeL;
    }

    public void allocateResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        TransactionContext tx = this.getTxContext();
        tx.begin();
        try {
            TransactionalMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
            intentAllocs.put((Object)allocations.intentId(), (Object)allocations);
            allocations.links().forEach(link -> this.allocateLinkResource(tx, (Link)link, allocations));
            tx.commit();
        }
        catch (ResourceAllocationException e) {
            this.log.error("Exception thrown, rolling back", (Throwable)e);
            tx.abort();
        }
        catch (Exception e) {
            this.log.error("Exception thrown, rolling back", (Throwable)e);
            tx.abort();
            throw e;
        }
    }

    private void allocateLinkResource(TransactionContext tx, Link link, LinkResourceAllocations allocations) {
        Set reqs = allocations.getResourceAllocation(link);
        Map<ResourceType, Set<ResourceAllocation>> available = this.getFreeResourcesEx(tx, link);
        for (ResourceAllocation req : reqs) {
            Set<ResourceAllocation> avail = available.get(req.type());
            if (req instanceof BandwidthResourceAllocation) {
                if (avail.isEmpty()) {
                    throw new ResourceAllocationException(String.format("There's no Bandwidth resource on %s?", link));
                }
                BandwidthResourceAllocation bw = (BandwidthResourceAllocation)avail.iterator().next();
                double bwLeft = bw.bandwidth().toDouble();
                BandwidthResourceAllocation bwReq = (BandwidthResourceAllocation)req;
                if (!((bwLeft -= bwReq.bandwidth().toDouble()) < 0.0)) continue;
                throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate bandwidth for link {}  requested amount is {} current allocation is {}", (Object[])new Object[]{link, bwReq.bandwidth().toDouble(), bw}));
            }
            if (req instanceof LambdaResourceAllocation) {
                LambdaResourceAllocation lambdaAllocation = (LambdaResourceAllocation)req;
                if (avail.contains(req)) continue;
                throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate lambda for link {} lambda is {}", (Object[])new Object[]{link, lambdaAllocation.lambda().toInt()}));
            }
            if (!(req instanceof MplsLabelResourceAllocation)) continue;
            MplsLabelResourceAllocation mplsAllocation = (MplsLabelResourceAllocation)req;
            if (avail.contains(req)) continue;
            throw new ResourceAllocationException(PositionalParameterStringFormatter.format((String)"Unable to allocate MPLS label for link {} MPLS label is {}", (Object[])new Object[]{link, mplsAllocation.mplsLabel().toString()}));
        }
        LinkKey linkKey = LinkKey.linkKey((Link)link);
        TransactionalMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
        List before = (List)linkAllocs.get((Object)linkKey);
        if (before == null) {
            ArrayList<LinkResourceAllocations> after = new ArrayList<LinkResourceAllocations>();
            after.add(allocations);
            linkAllocs.putIfAbsent((Object)linkKey, after);
        } else {
            boolean overlapped = before.stream().flatMap(x -> x.getResourceAllocation(link).stream()).anyMatch(x -> allocations.getResourceAllocation(link).contains(x));
            if (overlapped) {
                throw new ResourceAllocationException(String.format("Resource allocations are overlapped between %s and %s", before, allocations));
            }
            ArrayList<LinkResourceAllocations> after = new ArrayList<LinkResourceAllocations>(before.size() + 1);
            after.addAll(before);
            after.add(allocations);
            linkAllocs.replace((Object)linkKey, (Object)before, after);
        }
    }

    public LinkResourceEvent releaseResources(LinkResourceAllocations allocations) {
        Preconditions.checkNotNull((Object)allocations);
        IntentId intentId = allocations.intentId();
        Collection links = allocations.links();
        boolean success = false;
        do {
            TransactionContext tx = this.getTxContext();
            tx.begin();
            try {
                TransactionalMap<IntentId, LinkResourceAllocations> intentAllocs = this.getIntentAllocs(tx);
                intentAllocs.remove((Object)intentId);
                TransactionalMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
                links.forEach(link -> {
                    LinkKey linkId = LinkKey.linkKey((Link)link);
                    List before = (List)linkAllocs.get((Object)linkId);
                    if (before == null || before.isEmpty()) {
                        this.log.warn("There was no resource left to release on {}", (Object)linkId);
                        return;
                    }
                    ArrayList after = new ArrayList(before);
                    after.remove(allocations);
                    linkAllocs.replace((Object)linkId, (Object)before, after);
                });
                success = tx.commit();
            }
            catch (Exception e) {
                this.log.error("Exception thrown during releaseResource {}", (Object)allocations, (Object)e);
                tx.abort();
                throw e;
            }
        } while (!success);
        ImmutableList releasedResources = ImmutableList.of((Object)allocations);
        return new LinkResourceEvent(LinkResourceEvent.Type.ADDITIONAL_RESOURCES_AVAILABLE, (Collection)releasedResources);
    }

    public LinkResourceAllocations getAllocations(IntentId intentId) {
        Preconditions.checkNotNull((Object)intentId);
        Versioned alloc = null;
        try {
            alloc = this.intentAllocMap.get((Object)intentId);
        }
        catch (Exception e) {
            this.log.warn("Could not read resource allocation information", (Throwable)e);
        }
        return alloc == null ? null : (LinkResourceAllocations)alloc.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<LinkResourceAllocations> getAllocations(Link link) {
        Preconditions.checkNotNull((Object)link);
        TransactionContext tx = this.getTxContext();
        Iterable<LinkResourceAllocations> res = null;
        tx.begin();
        try {
            res = this.getAllocations(tx, link);
        }
        finally {
            tx.abort();
        }
        return res == null ? Collections.emptyList() : res;
    }

    public Iterable<LinkResourceAllocations> getAllocations() {
        try {
            Set allocs = this.intentAllocMap.values().stream().map(Versioned::value).collect(Collectors.toSet());
            return ImmutableSet.copyOf(allocs);
        }
        catch (Exception e) {
            this.log.warn("Could not read resource allocation information", (Throwable)e);
            return ImmutableSet.of();
        }
    }

    private Iterable<LinkResourceAllocations> getAllocations(TransactionContext tx, Link link) {
        Preconditions.checkNotNull((Object)tx);
        Preconditions.checkNotNull((Object)link);
        LinkKey key = LinkKey.linkKey((Link)link);
        TransactionalMap<LinkKey, List<LinkResourceAllocations>> linkAllocs = this.getLinkAllocs(tx);
        List res = (List)linkAllocs.get((Object)key);
        if (res != null) {
            return res;
        }
        res = (List)linkAllocs.putIfAbsent((Object)key, new ArrayList());
        if (res == null) {
            return Collections.emptyList();
        }
        return res;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }
}

