/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.impl;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.LeadershipEvent;
import org.onosproject.cluster.LeadershipStore;
import org.onosproject.cluster.LeadershipStoreDelegate;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.event.Event;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.LeaderElector;
import org.onosproject.store.service.LeaderElectorBuilder;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true, enabled=true)
public class DistributedLeadershipStore
extends AbstractStore<LeadershipEvent, LeadershipStoreDelegate>
implements LeadershipStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private NodeId localNodeId;
    private LeaderElector leaderElector;
    private final Consumer<Change<Leadership>> leadershipChangeListener = change -> {
        Leadership oldValue = (Leadership)change.oldValue();
        Leadership newValue = (Leadership)change.newValue();
        boolean leaderChanged = !Objects.equals(oldValue.leader(), newValue.leader());
        boolean candidatesChanged = !Objects.equals(oldValue.candidates(), newValue.candidates());
        LeadershipEvent.Type eventType = null;
        if (leaderChanged && candidatesChanged) {
            eventType = LeadershipEvent.Type.LEADER_AND_CANDIDATES_CHANGED;
        }
        if (leaderChanged && !candidatesChanged) {
            eventType = LeadershipEvent.Type.LEADER_CHANGED;
        }
        if (!leaderChanged && candidatesChanged) {
            eventType = LeadershipEvent.Type.CANDIDATES_CHANGED;
        }
        this.notifyDelegate((Event)new LeadershipEvent(eventType, (Leadership)change.newValue()));
    };

    @Activate
    public void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.leaderElector = ((AsyncLeaderElector)((LeaderElectorBuilder)this.storageService.leaderElectorBuilder().withName("onos-leadership-elections")).build()).asLeaderElector();
        this.leaderElector.addChangeListener(this.leadershipChangeListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.leaderElector.removeChangeListener(this.leadershipChangeListener);
        this.log.info("Stopped");
    }

    public Leadership addRegistration(String topic) {
        return this.leaderElector.run(topic, this.localNodeId);
    }

    public void removeRegistration(String topic) {
        this.leaderElector.withdraw(topic);
    }

    public void removeRegistration(NodeId nodeId) {
        this.leaderElector.evict(nodeId);
    }

    public boolean moveLeadership(String topic, NodeId toNodeId) {
        return this.leaderElector.anoint(topic, toNodeId);
    }

    public boolean makeTopCandidate(String topic, NodeId nodeId) {
        return this.leaderElector.promote(topic, nodeId);
    }

    public Leadership getLeadership(String topic) {
        return this.leaderElector.getLeadership(topic);
    }

    public Map<String, Leadership> getLeaderships() {
        return this.leaderElector.getLeaderships();
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

