/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging.impl;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onosproject.store.cluster.messaging.Endpoint;
import org.onosproject.store.cluster.messaging.impl.DecoderState;
import org.onosproject.store.cluster.messaging.impl.InternalMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ReplayingDecoder<DecoderState> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private long messageId;
    private int preamble;
    private IpAddress.Version ipVersion;
    private IpAddress senderIp;
    private int senderPort;
    private int messageTypeLength;
    private String messageType;
    private InternalMessage.Status status;
    private int contentLength;

    public MessageDecoder() {
        super((Object)DecoderState.READ_MESSAGE_PREAMBLE);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) throws Exception {
        switch ((DecoderState)((Object)this.state())) {
            case READ_MESSAGE_PREAMBLE: {
                this.preamble = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_MESSAGE_ID);
            }
            case READ_MESSAGE_ID: {
                this.messageId = buffer.readLong();
                this.checkpoint((Object)DecoderState.READ_SENDER_IP_VERSION);
            }
            case READ_SENDER_IP_VERSION: {
                this.ipVersion = buffer.readByte() == 0 ? IpAddress.Version.INET : IpAddress.Version.INET6;
                this.checkpoint((Object)DecoderState.READ_SENDER_IP);
            }
            case READ_SENDER_IP: {
                byte[] octets = new byte[IpAddress.byteLength((IpAddress.Version)this.ipVersion)];
                buffer.readBytes(octets);
                this.senderIp = IpAddress.valueOf((IpAddress.Version)this.ipVersion, (byte[])octets);
                this.checkpoint((Object)DecoderState.READ_SENDER_PORT);
            }
            case READ_SENDER_PORT: {
                this.senderPort = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_MESSAGE_TYPE_LENGTH);
            }
            case READ_MESSAGE_TYPE_LENGTH: {
                this.messageTypeLength = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_MESSAGE_TYPE);
            }
            case READ_MESSAGE_TYPE: {
                byte[] messageTypeBytes = new byte[this.messageTypeLength];
                buffer.readBytes(messageTypeBytes);
                this.messageType = new String(messageTypeBytes, Charsets.UTF_8);
                this.checkpoint((Object)DecoderState.READ_MESSAGE_STATUS);
            }
            case READ_MESSAGE_STATUS: {
                this.status = InternalMessage.Status.values()[buffer.readInt()];
                this.checkpoint((Object)DecoderState.READ_CONTENT_LENGTH);
            }
            case READ_CONTENT_LENGTH: {
                this.contentLength = buffer.readInt();
                this.checkpoint((Object)DecoderState.READ_CONTENT);
            }
            case READ_CONTENT: {
                byte[] payload;
                if (this.contentLength > 0) {
                    payload = new byte[this.contentLength];
                    buffer.readBytes(payload);
                } else {
                    payload = new byte[]{};
                }
                InternalMessage message = new InternalMessage(this.preamble, this.messageId, new Endpoint(this.senderIp, this.senderPort), this.messageType, payload, this.status);
                out.add(message);
                this.checkpoint((Object)DecoderState.READ_MESSAGE_PREAMBLE);
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
        this.log.error("Exception inside channel handling pipeline.", cause);
        context.close();
    }
}

