/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.core.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.ApplicationIdStore;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class DistributedApplicationIdStore
implements ApplicationIdStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private AtomicCounter appIdCounter;
    private ConsistentMap<String, ApplicationId> registeredIds;
    private Map<Short, ApplicationId> idToAppIdCache = Maps.newConcurrentMap();
    private MapEventListener<String, ApplicationId> mapEventListener = event -> {
        if (event.type() == MapEvent.Type.INSERT) {
            this.idToAppIdCache.put(((ApplicationId)event.newValue().value()).id(), (ApplicationId)event.newValue().value());
        }
    };

    @Activate
    public void activate() {
        this.appIdCounter = this.storageService.getAtomicCounter("onos-app-id-counter");
        this.registeredIds = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-app-ids")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).withRelaxedReadConsistency()).build();
        this.primeIdToAppIdCache();
        this.registeredIds.addListener(this.mapEventListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.registeredIds.removeListener(this.mapEventListener);
        this.log.info("Stopped");
    }

    public Set<ApplicationId> getAppIds() {
        return ImmutableSet.copyOf(this.registeredIds.asJavaMap().values());
    }

    public ApplicationId getAppId(Short id) {
        if (!this.idToAppIdCache.containsKey(id)) {
            this.primeIdToAppIdCache();
        }
        return this.idToAppIdCache.get(id);
    }

    public ApplicationId getAppId(String name) {
        return (ApplicationId)this.registeredIds.asJavaMap().get(name);
    }

    public ApplicationId registerApplication(String name) {
        ApplicationId exisitingAppId = (ApplicationId)this.registeredIds.asJavaMap().get(name);
        if (exisitingAppId == null) {
            DefaultApplicationId newAppId = new DefaultApplicationId((int)this.appIdCounter.incrementAndGet(), name);
            exisitingAppId = (ApplicationId)this.registeredIds.asJavaMap().putIfAbsent(name, newAppId);
            return exisitingAppId == null ? newAppId : exisitingAppId;
        }
        return exisitingAppId;
    }

    private void primeIdToAppIdCache() {
        this.registeredIds.asJavaMap().values().forEach(appId -> this.idToAppIdCache.putIfAbsent(appId.id(), (ApplicationId)appId));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

