/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.intent.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentPartitionService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentStore;
import org.onosproject.net.intent.IntentStoreDelegate;
import org.onosproject.net.intent.Key;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.Timestamp;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, enabled=true)
@Service
public class GossipIntentStore
extends AbstractStore<IntentEvent, IntentStoreDelegate>
implements IntentStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private EventuallyConsistentMap<Key, IntentData> currentMap;
    private EventuallyConsistentMap<Key, IntentData> pendingMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentPartitionService partitionService;
    private final AtomicLong sequenceNumber = new AtomicLong(0L);

    @Activate
    public void activate() {
        KryoNamespace.Builder intentSerializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(500).register(new Class[]{IntentData.class}).register(new Class[]{MultiValuedTimestamp.class});
        this.currentMap = this.storageService.eventuallyConsistentMapBuilder().withName("intent-current").withSerializer(intentSerializer).withTimestampProvider((key, intentData) -> new MultiValuedTimestamp((Comparable)intentData.version(), (Comparable)Long.valueOf(this.sequenceNumber.getAndIncrement()))).withPeerUpdateFunction((key, intentData) -> this.getPeerNodes((Key)key, (IntentData)intentData)).build();
        this.pendingMap = this.storageService.eventuallyConsistentMapBuilder().withName("intent-pending").withSerializer(intentSerializer).withTimestampProvider((key, intentData) -> new MultiValuedTimestamp((Comparable)intentData.version(), (Comparable)Long.valueOf(System.nanoTime()))).withPeerUpdateFunction((key, intentData) -> this.getPeerNodes((Key)key, (IntentData)intentData)).build();
        this.currentMap.addListener((EventuallyConsistentMapListener)new InternalCurrentListener());
        this.pendingMap.addListener((EventuallyConsistentMapListener)new InternalPendingListener());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.currentMap.destroy();
        this.pendingMap.destroy();
        this.log.info("Stopped");
    }

    public long getIntentCount() {
        return this.currentMap.size();
    }

    public Iterable<Intent> getIntents() {
        return this.currentMap.values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public Iterable<IntentData> getIntentData(boolean localOnly, long olderThan) {
        if (localOnly || olderThan > 0L) {
            long now = System.currentTimeMillis();
            WallClockTimestamp time = new WallClockTimestamp(now - olderThan);
            return this.currentMap.values().stream().filter(data -> data.version().isOlderThan((Timestamp)time) && (!localOnly || this.isMaster(data.key()))).collect(Collectors.toList());
        }
        return this.currentMap.values();
    }

    public IntentState getIntentState(Key intentKey) {
        IntentData data = (IntentData)this.currentMap.get((Object)intentKey);
        if (data != null) {
            return data.state();
        }
        return null;
    }

    public List<Intent> getInstallableIntents(Key intentKey) {
        IntentData data = (IntentData)this.currentMap.get((Object)intentKey);
        if (data != null) {
            return data.installables();
        }
        return ImmutableList.of();
    }

    public void write(IntentData newData) {
        Preconditions.checkNotNull((Object)newData);
        IntentData currentData = (IntentData)this.currentMap.get((Object)newData.key());
        if (IntentData.isUpdateAcceptable((IntentData)currentData, (IntentData)newData)) {
            if (newData.state() == IntentState.PURGE_REQ) {
                if (currentData != null) {
                    this.currentMap.remove((Object)newData.key(), (Object)currentData);
                } else {
                    this.log.info("Gratuitous purge request for intent: {}", (Object)newData.key());
                }
            } else {
                this.currentMap.put((Object)newData.key(), (Object)new IntentData(newData));
            }
            this.pendingMap.remove((Object)newData.key(), (Object)newData);
        }
    }

    private Collection<NodeId> getPeerNodes(Key key, IntentData data) {
        NodeId origin;
        NodeId master = this.partitionService.getLeader(key);
        NodeId nodeId = origin = data != null ? data.origin() : null;
        if (data != null && (master == null || origin == null)) {
            this.log.debug("Intent {} missing master and/or origin; master = {}, origin = {}", new Object[]{key, master, origin});
        }
        NodeId me = this.clusterService.getLocalNode().id();
        boolean isMaster = Objects.equals(master, me);
        boolean isOrigin = Objects.equals(origin, me);
        if (isMaster && isOrigin) {
            return this.getRandomNode();
        }
        if (isMaster) {
            return origin != null ? ImmutableList.of((Object)origin) : this.getRandomNode();
        }
        if (isOrigin) {
            return master != null ? ImmutableList.of((Object)master) : this.getRandomNode();
        }
        this.log.warn("No master or origin for intent {}", (Object)key);
        return master != null ? ImmutableList.of((Object)master) : this.getRandomNode();
    }

    private List<NodeId> getRandomNode() {
        NodeId me = this.clusterService.getLocalNode().id();
        List nodes = this.clusterService.getNodes().stream().map(ControllerNode::id).filter(node -> !Objects.equals(node, me)).collect(Collectors.toList());
        if (nodes.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.of(nodes.get(RandomUtils.nextInt((int)nodes.size())));
    }

    public void batchWrite(Iterable<IntentData> updates) {
        updates.forEach(this::write);
    }

    public Intent getIntent(Key key) {
        IntentData data = (IntentData)this.currentMap.get((Object)key);
        if (data != null) {
            return data.intent();
        }
        return null;
    }

    public IntentData getIntentData(Key key) {
        IntentData current = (IntentData)this.currentMap.get((Object)key);
        if (current == null) {
            return null;
        }
        return new IntentData(current);
    }

    public void addPending(IntentData data) {
        Preconditions.checkNotNull((Object)data);
        if (data.version() == null) {
            this.pendingMap.put((Object)data.key(), (Object)new IntentData(data.intent(), data.state(), (Timestamp)new WallClockTimestamp(), this.clusterService.getLocalNode().id()));
        } else {
            this.pendingMap.put((Object)data.key(), (Object)new IntentData(data.intent(), data.state(), data.version(), this.clusterService.getLocalNode().id()));
        }
    }

    public boolean isMaster(Key intentKey) {
        return this.partitionService.isMine(intentKey);
    }

    public Iterable<Intent> getPending() {
        return this.pendingMap.values().stream().map(IntentData::intent).collect(Collectors.toList());
    }

    public Iterable<IntentData> getPendingData() {
        return this.pendingMap.values();
    }

    public Iterable<IntentData> getPendingData(boolean localOnly, long olderThan) {
        long now = System.currentTimeMillis();
        WallClockTimestamp time = new WallClockTimestamp(now - olderThan);
        return this.pendingMap.values().stream().filter(data -> data.version().isOlderThan((Timestamp)time) && (!localOnly || this.isMaster(data.key()))).collect(Collectors.toList());
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindPartitionService(IntentPartitionService intentPartitionService) {
        this.partitionService = intentPartitionService;
    }

    protected void unbindPartitionService(IntentPartitionService intentPartitionService) {
        if (this.partitionService == intentPartitionService) {
            this.partitionService = null;
        }
    }

    private final class InternalPendingListener
    implements EventuallyConsistentMapListener<Key, IntentData> {
        private InternalPendingListener() {
        }

        public void event(EventuallyConsistentMapEvent<Key, IntentData> event) {
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                if (GossipIntentStore.this.isMaster(((IntentData)event.value()).intent().key()) && GossipIntentStore.this.delegate != null) {
                    ((IntentStoreDelegate)GossipIntentStore.this.delegate).process(new IntentData((IntentData)event.value()));
                }
                IntentEvent.getEvent((IntentData)((IntentData)event.value())).ifPresent(e -> GossipIntentStore.this.notifyDelegate((Event)e));
            }
        }
    }

    private final class InternalCurrentListener
    implements EventuallyConsistentMapListener<Key, IntentData> {
        private InternalCurrentListener() {
        }

        public void event(EventuallyConsistentMapEvent<Key, IntentData> event) {
            IntentData intentData = (IntentData)event.value();
            if (event.type() == EventuallyConsistentMapEvent.Type.PUT) {
                if (GossipIntentStore.this.delegate != null && GossipIntentStore.this.isMaster(((IntentData)event.value()).intent().key())) {
                    ((IntentStoreDelegate)GossipIntentStore.this.delegate).onUpdate(new IntentData(intentData));
                }
                IntentEvent.getEvent((IntentData)intentData).ifPresent(e -> GossipIntentStore.this.notifyDelegate((Event)e));
            }
        }
    }
}

