/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.proxyarp.impl;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.BoundedThreadPool;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.proxyarp.ProxyArpStore;
import org.onosproject.net.proxyarp.ProxyArpStoreDelegate;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.serializers.StoreSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedProxyArpStore
implements ProxyArpStore {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final MessageSubject ARP_RESPONSE_MESSAGE = new MessageSubject("onos-arp-response");
    protected final StoreSerializer serializer = StoreSerializer.using((KryoNamespace)KryoNamespace.newBuilder().register(KryoNamespaces.API).nextId(500).register(new Class[]{ArpResponseMessage.class}).register(new Class[]{ByteBuffer.class}).build("ProxyArpStore"));
    private ProxyArpStoreDelegate delegate;
    private Map<HostId, ArpResponseMessage> pendingMessages = Maps.newConcurrentMap();
    private ExecutorService executor = BoundedThreadPool.newFixedThreadPool((int)4, (ThreadFactory)Tools.groupedThreads((String)"onos/arp", (String)"sender-%d", (Logger)this.log));
    private NodeId localNodeId;
    private HostListener hostListener = new InternalHostListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService commService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;

    @Activate
    protected void activate() {
        this.localNodeId = this.clusterService.getLocalNode().id();
        this.hostService.addListener((EventListener)this.hostListener);
        this.commService.addSubscriber(ARP_RESPONSE_MESSAGE, arg_0 -> ((StoreSerializer)this.serializer).decode(arg_0), this::processArpResponse, (Executor)this.executor);
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.commService.removeSubscriber(ARP_RESPONSE_MESSAGE);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.log.info("Stopped");
    }

    public void forward(ConnectPoint outPort, Host subject, ByteBuffer packet) {
        this.delegate.emitResponse(outPort, packet);
    }

    public void setDelegate(ProxyArpStoreDelegate delegate) {
        this.delegate = delegate;
    }

    private void processArpResponse(ArpResponseMessage msg) {
        this.pendingMessages.put(msg.subject.id(), msg);
        if (this.hostService.getHost(msg.subject.id()) != null) {
            this.checkPendingArps(msg.subject.id());
        }
    }

    private void checkPendingArps(HostId id) {
        ArpResponseMessage msg = this.pendingMessages.remove(id);
        if (msg != null && this.delegate != null) {
            this.log.info("Emitting ARP response from {} to {}", (Object)id, (Object)msg.outPort);
            this.delegate.emitResponse(msg.outPort, ByteBuffer.wrap(msg.packet));
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCommService(ClusterCommunicationService clusterCommunicationService) {
        this.commService = clusterCommunicationService;
    }

    protected void unbindCommService(ClusterCommunicationService clusterCommunicationService) {
        if (this.commService == clusterCommunicationService) {
            this.commService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    private class InternalHostListener
    implements HostListener {
        private InternalHostListener() {
        }

        public void event(HostEvent event) {
            DistributedProxyArpStore.this.checkPendingArps(((Host)event.subject()).id());
        }
    }

    private static class ArpResponseMessage {
        private ConnectPoint outPort;
        private Host subject;
        private byte[] packet;

        public ArpResponseMessage(ConnectPoint outPort, Host subject, byte[] packet) {
            this.outPort = outPort;
            this.subject = subject;
            this.packet = packet;
        }

        private ArpResponseMessage() {
        }
    }
}

