/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceCodec;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.Codecs;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.EncodedDiscreteResources;

final class EncodableDiscreteResources
implements DiscreteResources {
    private static final Codecs CODECS = Codecs.getInstance();
    private final DiscreteResource parent;
    private final Map<Class<?>, EncodedDiscreteResources> values;

    private static Class<?> getClass(DiscreteResource resource) {
        return resource.valueAs(Object.class).map(Object::getClass).get();
    }

    static DiscreteResources of(Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return DiscreteResources.empty();
        }
        DiscreteResource parent = (DiscreteResource)resources.iterator().next().parent().get();
        return EncodableDiscreteResources.of(parent, resources);
    }

    static EncodableDiscreteResources of(DiscreteResource parent, Set<DiscreteResource> resources) {
        Map<Class, Set> grouped = resources.stream().collect(Collectors.groupingBy(x -> EncodableDiscreteResources.getClass(x), Collectors.toCollection(LinkedHashSet::new)));
        LinkedHashMap values = new LinkedHashMap();
        for (Map.Entry<Class, Set> entry : grouped.entrySet()) {
            DiscreteResourceCodec<?> codec = CODECS.getCodec(entry.getKey());
            values.put(entry.getKey(), EncodedDiscreteResources.of(entry.getValue(), codec));
        }
        return new EncodableDiscreteResources(parent, values);
    }

    private EncodableDiscreteResources(DiscreteResource parent, Map<Class<?>, EncodedDiscreteResources> values) {
        this.parent = parent;
        this.values = values;
    }

    private EncodableDiscreteResources() {
        this.parent = null;
        this.values = null;
    }

    @Override
    public Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        DiscreteResource resource = Resources.discrete((DiscreteResourceId)id).resource();
        Class<?> cls = EncodableDiscreteResources.getClass(resource);
        return Optional.ofNullable(this.values.get(cls)).filter(x -> x.contains(resource)).map(x -> resource);
    }

    @Override
    public DiscreteResources difference(DiscreteResources other) {
        Sets.SetView diff = Sets.difference(this.values(), other.values());
        return EncodableDiscreteResources.of(this.parent, (Set<DiscreteResource>)diff);
    }

    @Override
    public boolean isEmpty() {
        return this.values.values().stream().allMatch(x -> x.isEmpty());
    }

    @Override
    public boolean containsAny(List<DiscreteResource> other) {
        return other.stream().anyMatch(x -> this.values().contains(x));
    }

    @Override
    public DiscreteResources add(DiscreteResources other) {
        Sets.SetView union = Sets.union(this.values(), other.values());
        return EncodableDiscreteResources.of(this.parent, (Set<DiscreteResource>)union);
    }

    @Override
    public DiscreteResources remove(List<DiscreteResource> removed) {
        return EncodableDiscreteResources.of(this.parent, (Set<DiscreteResource>)Sets.difference(this.values(), new LinkedHashSet<DiscreteResource>(removed)));
    }

    @Override
    public Set<DiscreteResource> values() {
        return this.values.values().stream().flatMap(x -> x.values(this.parent.id()).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    DiscreteResource parent() {
        return this.parent;
    }

    Map<Class<?>, EncodedDiscreteResources> rawValues() {
        return this.values;
    }
}

