/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.onlab.util.Tools;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceCodec;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;

final class EncodedDiscreteResources {
    private final RangeSet<Integer> rangeSet;
    private final DiscreteResourceCodec codec;

    EncodedDiscreteResources(RangeSet<Integer> rangeSet, DiscreteResourceCodec codec) {
        this.rangeSet = rangeSet;
        this.codec = codec;
    }

    static EncodedDiscreteResources of(Set<DiscreteResource> resources, DiscreteResourceCodec codec) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        resources.stream().map(x -> x.valueAs(Object.class)).flatMap(Tools::stream).map(x -> codec.encode(x)).map(Range::singleton).map(x -> x.canonical(DiscreteDomain.integers())).forEach(arg_0 -> ((RangeSet)rangeSet).add(arg_0));
        return new EncodedDiscreteResources((RangeSet<Integer>)rangeSet, codec);
    }

    RangeSet<Integer> rangeSet() {
        return this.rangeSet;
    }

    DiscreteResourceCodec codec() {
        return this.codec;
    }

    Set<DiscreteResource> values(DiscreteResourceId parent) {
        return this.rangeSet.asRanges().stream().flatMapToInt(x1 -> IntStream.range((Integer)x1.lowerEndpoint(), (Integer)x1.upperEndpoint())).boxed().map(x -> this.codec.decode(x.intValue())).map(x -> Resources.discrete((DiscreteResourceId)parent, (Object)x).resource()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    boolean contains(DiscreteResource resource) {
        return resource.valueAs(Object.class).map(x -> this.codec.encode(x)).map(arg_0 -> this.rangeSet.contains(arg_0)).orElse(false);
    }

    boolean isEmpty() {
        return this.rangeSet.isEmpty();
    }
}

