/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.DiscreteResources;

final class GenericDiscreteResources
implements DiscreteResources {
    private final Set<DiscreteResource> values;

    static DiscreteResources of(Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return DiscreteResources.empty();
        }
        return new GenericDiscreteResources(resources);
    }

    private GenericDiscreteResources(Set<DiscreteResource> values) {
        this.values = values;
    }

    private GenericDiscreteResources() {
        this.values = null;
    }

    @Override
    public Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        DiscreteResource resource = Resources.discrete((DiscreteResourceId)id).resource();
        if (this.values.contains(resource)) {
            return Optional.of(resource);
        }
        return Optional.empty();
    }

    @Override
    public DiscreteResources difference(DiscreteResources other) {
        return new GenericDiscreteResources((Set<DiscreteResource>)Sets.difference(this.values, other.values()));
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsAny(List<DiscreteResource> other) {
        return other.stream().anyMatch(this.values::contains);
    }

    @Override
    public DiscreteResources add(DiscreteResources other) {
        LinkedHashSet<DiscreteResource> newValues = new LinkedHashSet<DiscreteResource>(this.values);
        newValues.addAll(other.values());
        return new GenericDiscreteResources(newValues);
    }

    @Override
    public DiscreteResources remove(List<DiscreteResource> removed) {
        LinkedHashSet<DiscreteResource> newValues = new LinkedHashSet<DiscreteResource>(this.values);
        newValues.removeAll(removed);
        return new GenericDiscreteResources(newValues);
    }

    @Override
    public Set<DiscreteResource> values() {
        return this.values;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericDiscreteResources other = (GenericDiscreteResources)obj;
        return Objects.equals(this.values, other.values);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("values", this.values).toString();
    }
}

