/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionalDiscreteResourceSubStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TransactionalMap<DiscreteResourceId, DiscreteResources> childMap;
    private final TransactionalMap<DiscreteResourceId, ResourceConsumerId> consumers;

    TransactionalDiscreteResourceSubStore(TransactionContext tx) {
        this.childMap = tx.getTransactionalMap("onos-resource-discrete-children", ConsistentResourceStore.SERIALIZER);
        this.consumers = tx.getTransactionalMap("onos-discrete-consumers", ConsistentResourceStore.SERIALIZER);
    }

    Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        if (!id.parent().isPresent()) {
            return Optional.of(Resource.ROOT);
        }
        DiscreteResources values = (DiscreteResources)this.childMap.get(id.parent().get());
        if (values == null) {
            return Optional.empty();
        }
        return values.lookup(id);
    }

    boolean register(DiscreteResourceId key, List<DiscreteResource> values) {
        if (values.isEmpty()) {
            return true;
        }
        DiscreteResources requested = DiscreteResources.of(new LinkedHashSet<DiscreteResource>(values));
        DiscreteResources oldValues = (DiscreteResources)this.childMap.putIfAbsent((Object)key, (Object)requested);
        if (oldValues == null) {
            return true;
        }
        DiscreteResources addedValues = requested.difference(oldValues);
        if (addedValues.isEmpty()) {
            return true;
        }
        DiscreteResources newValues = oldValues.add(addedValues);
        return this.childMap.replace((Object)key, (Object)oldValues, (Object)newValues);
    }

    boolean unregister(DiscreteResourceId key, List<DiscreteResource> values) {
        if (values.isEmpty()) {
            return true;
        }
        boolean allocated = values.stream().anyMatch(x -> this.isAllocated(x.id()));
        if (allocated) {
            this.log.warn("Failed to unregister {}: allocation exists", (Object)key);
            return false;
        }
        DiscreteResources oldValues = (DiscreteResources)this.childMap.putIfAbsent((Object)key, (Object)DiscreteResources.empty());
        if (oldValues == null) {
            this.log.trace("No-Op removing values. key {} did not exist", (Object)key);
            return true;
        }
        if (!oldValues.containsAny(values)) {
            this.log.trace("No-Op removing values. key {} did not contain {}", (Object)key, values);
            return true;
        }
        DiscreteResources newValues = oldValues.remove(values);
        return this.childMap.replace((Object)key, (Object)oldValues, (Object)newValues);
    }

    private boolean isAllocated(DiscreteResourceId id) {
        return this.consumers.get((Object)id) != null;
    }

    boolean allocate(ResourceConsumerId consumerId, DiscreteResource resource) {
        Optional<DiscreteResource> lookedUp = this.lookup(resource.id());
        if (!lookedUp.isPresent()) {
            return false;
        }
        ResourceConsumerId oldValue = (ResourceConsumerId)this.consumers.put((Object)resource.id(), (Object)consumerId);
        return oldValue == null;
    }

    boolean release(DiscreteResource resource, ResourceConsumerId consumerId) {
        return this.consumers.remove((Object)resource.id(), (Object)consumerId);
    }
}

