/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.Codecs;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.EncodableDiscreteResources;
import org.onosproject.store.resource.impl.GenericDiscreteResources;

final class UnifiedDiscreteResources
implements DiscreteResources {
    private final DiscreteResources generics;
    private final DiscreteResources encodables;
    private static final Codecs CODECS = Codecs.getInstance();

    static DiscreteResources of(Set<DiscreteResource> resources) {
        if (resources.isEmpty()) {
            return DiscreteResources.empty();
        }
        Map<Boolean, Set> partitioned = resources.stream().collect(Collectors.partitioningBy(CODECS::isEncodable, Collectors.toCollection(LinkedHashSet::new)));
        return new UnifiedDiscreteResources(GenericDiscreteResources.of(partitioned.get(false)), EncodableDiscreteResources.of(partitioned.get(true)));
    }

    private UnifiedDiscreteResources(DiscreteResources generics, DiscreteResources encodables) {
        this.generics = generics;
        this.encodables = encodables;
    }

    @Override
    public Optional<DiscreteResource> lookup(DiscreteResourceId id) {
        if (CODECS.isEncodable(Resources.discrete((DiscreteResourceId)id).resource())) {
            return this.encodables.lookup(id);
        }
        return this.generics.lookup(id);
    }

    @Override
    public DiscreteResources difference(DiscreteResources other) {
        return UnifiedDiscreteResources.of((Set<DiscreteResource>)Sets.difference(this.values(), other.values()));
    }

    @Override
    public boolean isEmpty() {
        return this.generics.isEmpty() && this.encodables.isEmpty();
    }

    @Override
    public boolean containsAny(List<DiscreteResource> other) {
        Map<Boolean, List<DiscreteResource>> partitioned = other.stream().collect(Collectors.partitioningBy(CODECS::isEncodable));
        return this.generics.containsAny(partitioned.get(false)) || this.encodables.containsAny(partitioned.get(true));
    }

    @Override
    public DiscreteResources add(DiscreteResources other) {
        return UnifiedDiscreteResources.of((Set<DiscreteResource>)Sets.union(this.values(), other.values()));
    }

    @Override
    public DiscreteResources remove(List<DiscreteResource> removed) {
        return UnifiedDiscreteResources.of((Set<DiscreteResource>)Sets.difference(this.values(), new LinkedHashSet<DiscreteResource>(removed)));
    }

    @Override
    public Set<DiscreteResource> values() {
        return Stream.concat(this.encodables.values().stream(), this.generics.values().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

