/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.key.impl;

import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.key.DeviceKey;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.DeviceKeyStoreDelegate;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.key.impl.DistributedDeviceKeyStore;
import org.onosproject.store.service.TestStorageService;

public class DistributedDeviceKeyStoreTest {
    private DistributedDeviceKeyStore deviceKeyStore;
    final String deviceKeyIdValue = "DeviceKeyId";
    final String deviceKeyLabel = "DeviceKeyLabel";
    final String deviceKeyLabel2 = "DeviceKeyLabel2";
    final String deviceKeySnmpName = "DeviceKeySnmpName";

    @Before
    public void setUp() {
        this.deviceKeyStore = new DistributedDeviceKeyStore();
        this.deviceKeyStore.storageService = new TestStorageService();
        this.deviceKeyStore.setDelegate((StoreDelegate)((DeviceKeyStoreDelegate)event -> {}));
        this.deviceKeyStore.activate();
    }

    @After
    public void tearDown() {
        this.deviceKeyStore.deactivate();
    }

    @Test(expected=NullPointerException.class)
    public void testAddNullKey() {
        this.deviceKeyStore.createOrUpdateDeviceKey(null);
    }

    @Test
    public void testAddKey() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeySnmpName");
        Collection deviceKeys = this.deviceKeyStore.getDeviceKeys();
        Assert.assertTrue((String)"The device key set should be empty.", (boolean)deviceKeys.isEmpty());
        this.deviceKeyStore.createOrUpdateDeviceKey(deviceKey);
        deviceKeys = this.deviceKeyStore.getDeviceKeys();
        Assert.assertEquals((String)"There should be one device key in the set.", (long)deviceKeys.size(), (long)1L);
        deviceKey = this.deviceKeyStore.getDeviceKey(deviceKeyId);
        Assert.assertEquals((String)"There should be one device key in the set.", (long)deviceKeys.size(), (long)1L);
    }

    @Test
    public void testAddSameKey() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeySnmpName");
        this.deviceKeyStore.createOrUpdateDeviceKey(deviceKey);
        Collection deviceKeys = this.deviceKeyStore.getDeviceKeys();
        Assert.assertEquals((String)"There should be one device key in the set.", (long)deviceKeys.size(), (long)1L);
        DeviceKey deviceKey2 = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel2", (String)"DeviceKeySnmpName");
        this.deviceKeyStore.createOrUpdateDeviceKey(deviceKey2);
        deviceKeys = this.deviceKeyStore.getDeviceKeys();
        Assert.assertEquals((String)"There should be one device key in the set.", (long)deviceKeys.size(), (long)1L);
        deviceKey = this.deviceKeyStore.getDeviceKey(deviceKeyId);
        Assert.assertNotNull((String)"The device key should not be null.", (Object)deviceKey);
        Assert.assertEquals((String)"The device key label should match.", (Object)"DeviceKeyLabel2", (Object)deviceKey.label());
    }

    @Test
    public void testRemoveKey() {
        DeviceKeyId deviceKeyId = DeviceKeyId.deviceKeyId((String)"DeviceKeyId");
        DeviceKey deviceKey = DeviceKey.createDeviceKeyUsingCommunityName((DeviceKeyId)deviceKeyId, (String)"DeviceKeyLabel", (String)"DeviceKeySnmpName");
        this.deviceKeyStore.createOrUpdateDeviceKey(deviceKey);
        this.deviceKeyStore.deleteDeviceKey(deviceKeyId);
        deviceKey = this.deviceKeyStore.getDeviceKey(deviceKeyId);
        Assert.assertNull((String)"The device key set should be empty.", (Object)deviceKey);
    }
}

