/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.host.impl;

import java.util.HashSet;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.host.DefaultHostDescription;
import org.onosproject.net.host.HostDescription;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.host.impl.DistributedHostStore;
import org.onosproject.store.service.TestStorageService;

public class DistributedHostStoreTest {
    private DistributedHostStore ecXHostStore;
    private static final HostId HOSTID = HostId.hostId((MacAddress)MacAddress.valueOf((String)"1a:1a:1a:1a:1a:1a"));
    private static final IpAddress IP1 = IpAddress.valueOf((String)"10.2.0.2");
    private static final IpAddress IP2 = IpAddress.valueOf((String)"10.2.0.3");
    private static final ProviderId PID = new ProviderId("of", "foo");

    @Before
    public void setUp() {
        this.ecXHostStore = new DistributedHostStore();
        this.ecXHostStore.storageService = new TestStorageService();
        this.ecXHostStore.activate();
    }

    @After
    public void tearDown() {
        this.ecXHostStore.deactivate();
    }

    @Test
    public void testRemoveIp() {
        HashSet<IpAddress> ips = new HashSet<IpAddress>();
        ips.add(IP1);
        ips.add(IP2);
        DefaultHostDescription description = new DefaultHostDescription(HOSTID.mac(), HOSTID.vlanId(), HostLocation.NONE, ips, new SparseAnnotations[0]);
        this.ecXHostStore.createOrUpdateHost(PID, HOSTID, (HostDescription)description, false);
        this.ecXHostStore.removeIp(HOSTID, IP1);
        Host host = this.ecXHostStore.getHost(HOSTID);
        Assert.assertFalse((boolean)host.ipAddresses().contains(IP1));
        TestCase.assertTrue((boolean)host.ipAddresses().contains(IP2));
    }
}

