/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.DiscreteResourceId;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumerId;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.ContinuousResourceAllocation;
import org.onosproject.store.service.TransactionContext;
import org.onosproject.store.service.TransactionalMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransactionalContinuousResourceSubStore {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TransactionalMap<DiscreteResourceId, Set<ContinuousResource>> childMap;
    private final TransactionalMap<ContinuousResourceId, ContinuousResourceAllocation> consumers;

    TransactionalContinuousResourceSubStore(TransactionContext tx) {
        this.childMap = tx.getTransactionalMap("onos-resource-continuous-children", ConsistentResourceStore.SERIALIZER);
        this.consumers = tx.getTransactionalMap("onos-continuous-consumers", ConsistentResourceStore.SERIALIZER);
    }

    Optional<ContinuousResource> lookup(ContinuousResourceId id) {
        Preconditions.checkArgument((boolean)id.parent().isPresent());
        Set values = (Set)this.childMap.get(id.parent().get());
        if (values == null) {
            return Optional.empty();
        }
        return values.stream().filter(x -> x.id().equals((Object)id)).findFirst();
    }

    boolean register(DiscreteResourceId parent, Set<ContinuousResource> resources) {
        if (resources.isEmpty()) {
            return true;
        }
        Set oldValues = (Set)this.childMap.putIfAbsent((Object)parent, resources);
        if (oldValues == null) {
            return true;
        }
        Sets.SetView addedValues = Sets.difference(resources, (Set)oldValues);
        if (addedValues.isEmpty()) {
            return true;
        }
        Set addedIds = addedValues.stream().map(ContinuousResource::id).collect(Collectors.toSet());
        if (oldValues.stream().anyMatch(x -> addedIds.contains(x.id()))) {
            return false;
        }
        LinkedHashSet newValues = new LinkedHashSet(oldValues);
        newValues.addAll(addedValues);
        return this.childMap.replace((Object)parent, (Object)oldValues, newValues);
    }

    boolean unregister(DiscreteResourceId parent, Set<ContinuousResource> resources) {
        if (resources.isEmpty()) {
            return true;
        }
        boolean allocated = resources.stream().anyMatch(x -> this.isAllocated(x.id()));
        if (allocated) {
            this.log.warn("Failed to unregister {}: allocation exists", (Object)parent);
            return false;
        }
        Set oldValues = (Set)this.childMap.putIfAbsent((Object)parent, new LinkedHashSet());
        if (oldValues == null) {
            this.log.trace("No-Op removing values. key {} did not exist", (Object)parent);
            return true;
        }
        if (resources.stream().allMatch(x -> !oldValues.contains(x))) {
            this.log.trace("No-Op removing values. key {} did not contain {}", (Object)parent, resources);
            return true;
        }
        LinkedHashSet newValues = new LinkedHashSet(oldValues);
        newValues.removeAll(resources);
        return this.childMap.replace((Object)parent, (Object)oldValues, newValues);
    }

    private boolean isAllocated(ContinuousResourceId id) {
        ContinuousResourceAllocation allocations = (ContinuousResourceAllocation)this.consumers.get((Object)id);
        return allocations != null && !allocations.allocations().isEmpty();
    }

    boolean allocate(ResourceConsumerId consumerId, ContinuousResource request) {
        Optional<ContinuousResource> lookedUp = this.lookup(request.id());
        if (!lookedUp.isPresent()) {
            return false;
        }
        ContinuousResource original = lookedUp.get();
        ContinuousResourceAllocation allocations = (ContinuousResourceAllocation)this.consumers.get((Object)request.id());
        if (!Optional.ofNullable(allocations).orElse(ContinuousResourceAllocation.empty(original)).hasEnoughResource(request)) {
            return false;
        }
        return this.appendValue(original, new ResourceAllocation((Resource)request, consumerId));
    }

    private boolean appendValue(ContinuousResource original, ResourceAllocation value) {
        ContinuousResourceAllocation oldValue = (ContinuousResourceAllocation)this.consumers.putIfAbsent((Object)original.id(), (Object)new ContinuousResourceAllocation(original, (ImmutableList<ResourceAllocation>)ImmutableList.of((Object)value)));
        if (oldValue == null) {
            return true;
        }
        ContinuousResourceAllocation newValue = oldValue.allocate(value);
        return this.consumers.replace((Object)original.id(), (Object)oldValue, (Object)newValue);
    }

    boolean release(ContinuousResource resource, ResourceConsumerId consumerId) {
        ContinuousResourceAllocation oldAllocation = (ContinuousResourceAllocation)this.consumers.get((Object)resource.id());
        ContinuousResourceAllocation newAllocation = oldAllocation.release(resource, consumerId);
        return this.consumers.replace((Object)resource.id(), (Object)oldAllocation, (Object)newAllocation);
    }
}

