/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.EmptyDiscreteResources;

public class EmptyDiscreteResourcesTest {
    private EmptyDiscreteResources sut = EmptyDiscreteResources.INSTANCE;

    @Test
    public void testLookup() {
        Assert.assertThat((Object)this.sut.lookup(Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).id()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testDifference() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        Assert.assertThat((Object)this.sut.difference(DiscreteResources.of((Set)ImmutableSet.of((Object)res1))), (Matcher)Matchers.is((Object)EmptyDiscreteResources.INSTANCE));
        Assert.assertThat((Object)this.sut.difference(DiscreteResources.of((Set)ImmutableSet.of((Object)res2))), (Matcher)Matchers.is((Object)EmptyDiscreteResources.INSTANCE));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertThat((Object)this.sut.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testValuesOf() {
        Assert.assertThat((Object)this.sut.valuesOf(Object.class), (Matcher)Matchers.is((Object)ImmutableSet.of()));
        Assert.assertThat((Object)this.sut.valuesOf(VlanId.class), (Matcher)Matchers.is((Object)ImmutableSet.of()));
    }

    @Test
    public void testContainsAny() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        Assert.assertThat((Object)this.sut.containsAny((Set)ImmutableSet.of((Object)res1)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.sut.containsAny((Set)ImmutableSet.of((Object)res2)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAdd() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        Assert.assertThat((Object)this.sut.add(DiscreteResources.of((Set)ImmutableSet.of((Object)res1))), (Matcher)Matchers.is((Object)DiscreteResources.of((Set)ImmutableSet.of((Object)res1))));
        Assert.assertThat((Object)this.sut.add(DiscreteResources.of((Set)ImmutableSet.of((Object)res2))), (Matcher)Matchers.is((Object)DiscreteResources.of((Set)ImmutableSet.of((Object)res2))));
    }

    @Test
    public void testValues() {
        Assert.assertThat((Object)this.sut.values(), (Matcher)Matchers.is((Object)ImmutableSet.of()));
    }
}

