/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flowobjective.impl;

import com.google.common.base.Charsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.behaviour.DefaultNextGroup;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.store.flowobjective.impl.DistributedFlowObjectiveStore;
import org.onosproject.store.service.TestStorageService;

public class DistributedFlowObjectiveStoreTest {
    DistributedFlowObjectiveStore storeImpl;
    FlowObjectiveStore store;

    @Before
    public void setUp() {
        this.storeImpl = new DistributedFlowObjectiveStore();
        this.storeImpl.storageService = new TestStorageService();
        this.storeImpl.activate();
        this.store = this.storeImpl;
    }

    @After
    public void tearDown() {
        this.storeImpl.deactivate();
    }

    @Test
    public void testFlowObjectiveStore() {
        DefaultNextGroup group2 = new DefaultNextGroup("2".getBytes(Charsets.US_ASCII));
        int group1Id = this.store.allocateNextId();
        int group2Id = this.store.allocateNextId();
        NextGroup group1add = this.store.getNextGroup(Integer.valueOf(group1Id));
        MatcherAssert.assertThat((Object)group1add, (Matcher)Matchers.nullValue());
        this.store.putNextGroup(Integer.valueOf(group2Id), (NextGroup)group2);
        NextGroup group2Query = this.store.getNextGroup(Integer.valueOf(group2Id));
        MatcherAssert.assertThat((Object)group2Query.data(), (Matcher)Matchers.is((Object)group2.data()));
    }
}

