/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.onlab.util.ClosedOpenRange;
import org.onosproject.net.resource.DiscreteResourceCodec;
import org.onosproject.store.resource.impl.EncodedDiscreteResources;

final class EncodedResourcesSerializer
extends Serializer<EncodedDiscreteResources> {
    EncodedResourcesSerializer() {
    }

    public void write(Kryo kryo, Output output, EncodedDiscreteResources object) {
        List ranges = object.rangeSet().asRanges().stream().map(ClosedOpenRange::of).collect(Collectors.toList());
        kryo.writeObject(output, ranges);
        kryo.writeClassAndObject(output, (Object)object.codec());
    }

    public EncodedDiscreteResources read(Kryo kryo, Input input, Class<EncodedDiscreteResources> cls) {
        List ranges = (List)kryo.readObject(input, ArrayList.class);
        DiscreteResourceCodec codec = (DiscreteResourceCodec)kryo.readClassAndObject(input);
        TreeRangeSet rangeSet = TreeRangeSet.create();
        ranges.stream().map(x -> Range.closedOpen((Comparable)Integer.valueOf(x.lowerBound()), (Comparable)Integer.valueOf(x.upperBound()))).forEach(arg_0 -> ((RangeSet)rangeSet).add(arg_0));
        return new EncodedDiscreteResources((RangeSet<Integer>)rangeSet, codec);
    }
}

