/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.config.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigStoreDelegate;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.config.impl.DistributedNetworkConfigStore;
import org.onosproject.store.service.TestStorageService;

public class DistributedNetworkConfigStoreTest {
    private DistributedNetworkConfigStore configStore;

    @Before
    public void setUp() {
        this.configStore = new DistributedNetworkConfigStore();
        this.configStore.storageService = new TestStorageService();
        this.configStore.setDelegate((StoreDelegate)((NetworkConfigStoreDelegate)event -> {}));
        this.configStore.activate();
    }

    @After
    public void tearDown() {
        this.configStore.deactivate();
    }

    @Test
    public void testCreateConfig() {
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(BasicConfig.class, "config1"));
        this.configStore.createConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"config1"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)1));
        BasicConfig queried = (BasicConfig)this.configStore.getConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)((Object)queried), (Matcher)Matchers.notNullValue());
        this.configStore.clearConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"config1"), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)0));
        BasicConfig queriedAfterClear = (BasicConfig)this.configStore.getConfig((Object)"config1", BasicConfig.class);
        Assert.assertThat((Object)((Object)queriedAfterClear), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCreateFactory() {
        MockConfigFactory mockFactory = new MockConfigFactory(BasicConfig.class, "config1");
        Assert.assertThat((Object)this.configStore.getConfigFactory(BasicConfig.class), (Matcher)Matchers.nullValue());
        this.configStore.addConfigFactory((ConfigFactory)mockFactory);
        Assert.assertThat((Object)this.configStore.getConfigFactory(BasicConfig.class), (Matcher)Matchers.is((Object)((Object)mockFactory)));
        this.configStore.removeConfigFactory((ConfigFactory)mockFactory);
        Assert.assertThat((Object)this.configStore.getConfigFactory(BasicConfig.class), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testApplyConfig() {
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(BasicConfig.class, "config1"));
        this.configStore.applyConfig((Object)"subject", BasicConfig.class, (JsonNode)new ObjectMapper().createObjectNode());
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"subject"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testPendingConfig() {
        this.configStore.queueConfig((Object)"subject", "config1", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(BasicConfig.class, "config1"));
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"subject"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testPendingConfigSameKey() {
        this.configStore.queueConfig((Object)"subject", "config1", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.queueConfig((Object)123, "config1", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(BasicConfig.class, "config1"));
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"subject"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)123), (Matcher)Matchers.hasSize((int)0));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class, BasicConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(String.class), (Matcher)Matchers.hasSize((int)1));
        this.configStore.addConfigFactory((ConfigFactory)new MockIntConfigFactory(BasicIntConfig.class, "config1"));
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)"subject"), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getConfigClasses((Object)123), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(Integer.class, BasicIntConfig.class), (Matcher)Matchers.hasSize((int)1));
        Assert.assertThat((Object)this.configStore.getSubjects(Integer.class), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testRemoveConfig() {
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(BasicConfig.class, "config1"));
        this.configStore.queueConfig((Object)"subject", "config2", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.queueConfig((Object)123, "config2", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.applyConfig((Object)"subject1", BasicConfig.class, (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.clearConfig();
        Set subjects = this.configStore.getSubjects(String.class);
        Assert.assertThat((Object)subjects.size(), (Matcher)Matchers.is((Object)0));
        this.configStore.addConfigFactory((ConfigFactory)new MockConfigFactory(BasicConfig.class, "config1"));
        this.configStore.queueConfig((Object)"subject", "config3", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.queueConfig((Object)123, "config3", (JsonNode)new ObjectMapper().createObjectNode());
        this.configStore.applyConfig((Object)"subject1", BasicConfig.class, (JsonNode)new ObjectMapper().createObjectNode());
        Set configs = this.configStore.getSubjects(String.class);
        configs.forEach(c -> this.configStore.clearConfig(c));
        Set newConfig1 = this.configStore.getSubjects(String.class);
        Assert.assertThat((Object)newConfig1, (Matcher)Matchers.notNullValue());
    }

    public class MockIntSubjectFactory
    extends SubjectFactory<Integer> {
        protected MockIntSubjectFactory(String subjectClassKey) {
            super(Integer.class, subjectClassKey);
        }

        public Integer createSubject(String subjectKey) {
            return Integer.parseInt(subjectKey);
        }
    }

    public class MockSubjectFactory
    extends SubjectFactory<String> {
        protected MockSubjectFactory(String subjectClassKey) {
            super(String.class, subjectClassKey);
        }

        public String createSubject(String subjectKey) {
            return subjectKey;
        }
    }

    public class MockIntConfigFactory
    extends ConfigFactory<Integer, BasicIntConfig> {
        protected MockIntConfigFactory(Class<BasicIntConfig> configClass, String configKey) {
            super((SubjectFactory)new MockIntSubjectFactory("strings"), configClass, configKey);
        }

        public BasicIntConfig createConfig() {
            return new BasicIntConfig();
        }
    }

    public class MockConfigFactory
    extends ConfigFactory<String, BasicConfig> {
        protected MockConfigFactory(Class<BasicConfig> configClass, String configKey) {
            super((SubjectFactory)new MockSubjectFactory("strings"), configClass, configKey);
        }

        public BasicConfig createConfig() {
            return new BasicConfig();
        }
    }

    public class BasicIntConfig
    extends Config<Integer> {
    }

    public class BasicConfig
    extends Config<String> {
    }
}

