/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.link.impl;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DeviceClockService;
import org.onosproject.net.device.DeviceClockServiceAdapter;
import org.onosproject.net.link.DefaultLinkDescription;
import org.onosproject.net.link.LinkDescription;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkStore;
import org.onosproject.net.link.LinkStoreDelegate;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.store.StoreDelegate;
import org.onosproject.store.Timestamp;
import org.onosproject.store.cluster.StaticClusterService;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.ClusterMessageHandler;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.impl.MastershipBasedTimestamp;
import org.onosproject.store.link.impl.ECLinkStore;

@Ignore
public class ECLinkStoreTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final ProviderId PIDA = new ProviderId("of", "bar", true);
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:foo");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:bar");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);
    private static final PortNumber P3 = PortNumber.portNumber((long)3L);
    private static final SparseAnnotations A1 = DefaultAnnotations.builder().set("A1", "a1").set("B1", "b1").build();
    private static final SparseAnnotations A1_2 = DefaultAnnotations.builder().remove("A1").set("B3", "b3").build();
    private static final SparseAnnotations A2 = DefaultAnnotations.builder().set("A2", "a2").set("B2", "b2").build();
    private static final SparseAnnotations A2_2 = DefaultAnnotations.builder().remove("A2").set("B4", "b4").build();
    private static final NodeId NID1 = new NodeId("local");
    private static final ControllerNode ONOS1 = new DefaultControllerNode(NID1, IpAddress.valueOf((String)"127.0.0.1"));
    private static final NodeId NID2 = new NodeId("remote");
    private static final ControllerNode ONOS2 = new DefaultControllerNode(NID2, IpAddress.valueOf((String)"127.0.0.2"));
    private ECLinkStore linkStoreImpl;
    private LinkStore linkStore;
    private DeviceClockService deviceClockService;
    private ClusterCommunicationService clusterCommunicator;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.clusterCommunicator = (ClusterCommunicationService)EasyMock.createNiceMock(ClusterCommunicationService.class);
        this.clusterCommunicator.addSubscriber((MessageSubject)EasyMock.anyObject(MessageSubject.class), (ClusterMessageHandler)EasyMock.anyObject(ClusterMessageHandler.class), (ExecutorService)EasyMock.anyObject(ExecutorService.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clusterCommunicator});
        this.linkStoreImpl = new ECLinkStore();
        this.linkStoreImpl.deviceClockService = this.deviceClockService;
        this.linkStoreImpl.clusterCommunicator = this.clusterCommunicator;
        this.linkStoreImpl.clusterService = new TestClusterService();
        this.linkStoreImpl.deviceClockService = new TestDeviceClockService();
        this.linkStoreImpl.mastershipService = new TestMastershipService();
        this.linkStoreImpl.activate();
        this.linkStore = this.linkStoreImpl;
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
        EasyMock.reset((Object[])new Object[]{this.clusterCommunicator});
    }

    @After
    public void tearDown() throws Exception {
        this.linkStoreImpl.deactivate();
    }

    private void putLink(DeviceId srcId, PortNumber srcNum, DeviceId dstId, PortNumber dstNum, Link.Type type, SparseAnnotations ... annotations) {
        ConnectPoint src = new ConnectPoint((ElementId)srcId, srcNum);
        ConnectPoint dst = new ConnectPoint((ElementId)dstId, dstNum);
        this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, type, annotations));
        EasyMock.verify((Object[])new Object[]{this.clusterCommunicator});
    }

    private void putLink(LinkKey key, Link.Type type, SparseAnnotations ... annotations) {
        this.putLink(key.src().deviceId(), key.src().port(), key.dst().deviceId(), key.dst().port(), type, annotations);
    }

    private static void assertLink(DeviceId srcId, PortNumber srcNum, DeviceId dstId, PortNumber dstNum, Link.Type type, Link link) {
        Assert.assertEquals((Object)srcId, (Object)link.src().deviceId());
        Assert.assertEquals((Object)srcNum, (Object)link.src().port());
        Assert.assertEquals((Object)dstId, (Object)link.dst().deviceId());
        Assert.assertEquals((Object)dstNum, (Object)link.dst().port());
        Assert.assertEquals((Object)type, (Object)link.type());
    }

    private static void assertLink(LinkKey key, Link.Type type, Link link) {
        ECLinkStoreTest.assertLink(key.src().deviceId(), key.src().port(), key.dst().deviceId(), key.dst().port(), type, link);
    }

    @Test
    public final void testGetLinkCount() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)this.linkStore.getLinkCount());
        this.putLink(DID1, P1, DID2, P2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(DID2, P2, DID1, P1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(DID1, P1, DID2, P2, Link.Type.DIRECT, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expecting 2 unique link", (long)2L, (long)this.linkStore.getLinkCount());
    }

    @Test
    public final void testGetLinks() {
        Assert.assertEquals((String)"initialy empty", (long)0L, (long)Iterables.size((Iterable)this.linkStore.getLinks()));
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P1), (ConnectPoint)new ConnectPoint((ElementId)DID2, P2));
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID2, P2), (ConnectPoint)new ConnectPoint((ElementId)DID1, P1));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        Assert.assertEquals((String)"expecting 2 unique link", (long)2L, (long)Iterables.size((Iterable)this.linkStore.getLinks()));
        HashMap<LinkKey, Link> links = new HashMap<LinkKey, Link>();
        for (Link link : this.linkStore.getLinks()) {
            links.put(LinkKey.linkKey((Link)link), link);
        }
        ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)links.get(linkId1));
        ECLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links.get(linkId2));
    }

    @Test
    public final void testGetDeviceEgressLinks() {
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P1), (ConnectPoint)new ConnectPoint((ElementId)DID2, P2));
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID2, P2), (ConnectPoint)new ConnectPoint((ElementId)DID1, P1));
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getDeviceEgressLinks(DID1);
        Assert.assertEquals((long)2L, (long)links1.size());
        Set links2 = this.linkStore.getDeviceEgressLinks(DID2);
        Assert.assertEquals((long)1L, (long)links2.size());
        ECLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testGetDeviceIngressLinks() {
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P1), (ConnectPoint)new ConnectPoint((ElementId)DID2, P2));
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID2, P2), (ConnectPoint)new ConnectPoint((ElementId)DID1, P1));
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getDeviceIngressLinks(DID2);
        Assert.assertEquals((long)2L, (long)links1.size());
        Set links2 = this.linkStore.getDeviceIngressLinks(DID1);
        Assert.assertEquals((long)1L, (long)links2.size());
        ECLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testGetLink() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)src, (ConnectPoint)dst);
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        Link link = this.linkStore.getLink(src, dst);
        ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, link);
        Assert.assertNull((String)"There shouldn't be reverese link", (Object)this.linkStore.getLink(dst, src));
    }

    @Test
    public final void testGetEgressLinks() {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)d2P2, (ConnectPoint)d1P1);
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getEgressLinks(d1P1);
        Assert.assertEquals((long)1L, (long)links1.size());
        ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)links1.iterator().next());
        Set links2 = this.linkStore.getEgressLinks(d2P2);
        Assert.assertEquals((long)1L, (long)links2.size());
        ECLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testGetIngressLinks() {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)d2P2, (ConnectPoint)d1P1);
        LinkKey linkId3 = LinkKey.linkKey((ConnectPoint)new ConnectPoint((ElementId)DID1, P2), (ConnectPoint)new ConnectPoint((ElementId)DID2, P3));
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId2, Link.Type.DIRECT, new SparseAnnotations[0]);
        this.putLink(linkId3, Link.Type.DIRECT, new SparseAnnotations[0]);
        Set links1 = this.linkStore.getIngressLinks(d2P2);
        Assert.assertEquals((long)1L, (long)links1.size());
        ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)links1.iterator().next());
        Set links2 = this.linkStore.getIngressLinks(d1P1);
        Assert.assertEquals((long)1L, (long)links2.size());
        ECLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, (Link)links2.iterator().next());
    }

    @Test
    public final void testCreateOrUpdateLink() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        DefaultLinkDescription linkDescription = new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[0]);
        LinkEvent event = this.linkStore.createOrUpdateLink(PID, (LinkDescription)linkDescription);
        ECLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.INDIRECT, (Link)event.subject());
        Assert.assertEquals((Object)LinkEvent.Type.LINK_ADDED, (Object)event.type());
        LinkEvent event2 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]));
        ECLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event2.subject());
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event2.type());
        LinkEvent event3 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]));
        Assert.assertNull((String)"No change event expected", (Object)event3);
    }

    private static void assertLinkDescriptionEquals(ConnectPoint src, ConnectPoint dst, Link.Type type, LinkDescription actual) {
        Assert.assertEquals((Object)src, (Object)actual.src());
        Assert.assertEquals((Object)dst, (Object)actual.dst());
        Assert.assertEquals((Object)type, (Object)actual.type());
    }

    @Test
    public final void testCreateOrUpdateLinkAncillary() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        LinkEvent event = this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[]{A1}));
        Assert.assertNotNull((String)"Ancillary only link is ignored", (Object)event);
        LinkEvent event2 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[]{A2}));
        ECLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.INDIRECT, (Link)event2.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event2.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A1});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event2.type());
        LinkEvent event3 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[]{A2}));
        ECLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event3.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event3.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A1});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event3.type());
        LinkEvent event4 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[0]));
        Assert.assertNull((String)"No change event expected", (Object)event4);
        LinkEvent event5 = this.linkStore.createOrUpdateLink(PID, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[]{A2_2}));
        ECLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event5.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event5.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A2_2, A1});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event5.type());
        LinkEvent event6 = this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.DIRECT, new SparseAnnotations[]{A1_2}));
        ECLinkStoreTest.assertLink(DID1, P1, DID2, P2, Link.Type.DIRECT, (Link)event6.subject());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event6.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2, A2_2, A1, A1_2});
        Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event6.type());
        LinkEvent event7 = this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.EDGE, new SparseAnnotations[0]));
        Assert.assertNull((String)"Ancillary change other than annotation is ignored", (Object)event7);
    }

    @Test
    public final void testRemoveLink() {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        LinkKey linkId2 = LinkKey.linkKey((ConnectPoint)d2P2, (ConnectPoint)d1P1);
        this.putLink(linkId1, Link.Type.DIRECT, A1);
        this.putLink(linkId2, Link.Type.DIRECT, A2);
        LinkEvent event = this.linkStore.removeLink(d1P1, d2P2);
        Assert.assertEquals((Object)LinkEvent.Type.LINK_REMOVED, (Object)event.type());
        NetTestTools.assertAnnotationsEquals((Annotations)((Link)event.subject()).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A1});
        LinkEvent event2 = this.linkStore.removeLink(d1P1, d2P2);
        Assert.assertNull((Object)event2);
        ECLinkStoreTest.assertLink(linkId2, Link.Type.DIRECT, this.linkStore.getLink(d2P2, d1P1));
        NetTestTools.assertAnnotationsEquals((Annotations)this.linkStore.getLink(d2P2, d1P1).annotations(), (SparseAnnotations[])new SparseAnnotations[]{A2});
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, this.linkStore.getLink(d1P1, d2P2));
        NetTestTools.assertAnnotationsEquals((Annotations)this.linkStore.getLink(d1P1, d2P2).annotations(), (SparseAnnotations[])new SparseAnnotations[0]);
    }

    @Test
    public final void testAncillaryVisible() {
        ConnectPoint src = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint dst = new ConnectPoint((ElementId)DID2, P2);
        this.linkStore.createOrUpdateLink(PIDA, (LinkDescription)new DefaultLinkDescription(src, dst, Link.Type.INDIRECT, new SparseAnnotations[]{A1}));
        Assert.assertEquals((long)1L, (long)this.linkStore.getLinkCount());
        Assert.assertNotNull((Object)this.linkStore.getLink(src, dst));
    }

    @Ignore(value="Ignore until Delegate spec. is clear.")
    @Test
    public final void testEvents() throws InterruptedException {
        ConnectPoint d1P1 = new ConnectPoint((ElementId)DID1, P1);
        ConnectPoint d2P2 = new ConnectPoint((ElementId)DID2, P2);
        LinkKey linkId1 = LinkKey.linkKey((ConnectPoint)d1P1, (ConnectPoint)d2P2);
        CountDownLatch addLatch = new CountDownLatch(1);
        LinkStoreDelegate checkAdd = event -> {
            Assert.assertEquals((Object)LinkEvent.Type.LINK_ADDED, (Object)event.type());
            ECLinkStoreTest.assertLink(linkId1, Link.Type.INDIRECT, (Link)event.subject());
            addLatch.countDown();
        };
        CountDownLatch updateLatch = new CountDownLatch(1);
        LinkStoreDelegate checkUpdate = event -> {
            Assert.assertEquals((Object)LinkEvent.Type.LINK_UPDATED, (Object)event.type());
            ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)event.subject());
            updateLatch.countDown();
        };
        CountDownLatch removeLatch = new CountDownLatch(1);
        LinkStoreDelegate checkRemove = event -> {
            Assert.assertEquals((Object)LinkEvent.Type.LINK_REMOVED, (Object)event.type());
            ECLinkStoreTest.assertLink(linkId1, Link.Type.DIRECT, (Link)event.subject());
            removeLatch.countDown();
        };
        this.linkStore.setDelegate((StoreDelegate)checkAdd);
        this.putLink(linkId1, Link.Type.INDIRECT, new SparseAnnotations[0]);
        Assert.assertTrue((String)"Add event fired", (boolean)addLatch.await(1L, TimeUnit.SECONDS));
        this.linkStore.unsetDelegate((StoreDelegate)checkAdd);
        this.linkStore.setDelegate((StoreDelegate)checkUpdate);
        this.putLink(linkId1, Link.Type.DIRECT, new SparseAnnotations[0]);
        Assert.assertTrue((String)"Update event fired", (boolean)updateLatch.await(1L, TimeUnit.SECONDS));
        this.linkStore.unsetDelegate((StoreDelegate)checkUpdate);
        this.linkStore.setDelegate((StoreDelegate)checkRemove);
        this.linkStore.removeLink(d1P1, d2P2);
        Assert.assertTrue((String)"Remove event fired", (boolean)removeLatch.await(1L, TimeUnit.SECONDS));
    }

    private final class TestMastershipService
    extends MastershipServiceAdapter {
        private TestMastershipService() {
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            return NID1;
        }
    }

    private final class TestDeviceClockService
    extends DeviceClockServiceAdapter {
        private final AtomicLong ticker = new AtomicLong();

        private TestDeviceClockService() {
        }

        public Timestamp getTimestamp(DeviceId deviceId) {
            if (DID1.equals((Object)deviceId)) {
                return new MastershipBasedTimestamp(1L, this.ticker.getAndIncrement());
            }
            if (DID2.equals((Object)deviceId)) {
                return new MastershipBasedTimestamp(2L, this.ticker.getAndIncrement());
            }
            throw new IllegalStateException();
        }

        public boolean isTimestampAvailable(DeviceId deviceId) {
            return DID1.equals((Object)deviceId) || DID2.equals((Object)deviceId);
        }
    }

    private static final class TestClusterService
    extends StaticClusterService {
        public TestClusterService() {
            this.localNode = ONOS1;
            this.nodes.put(NID1, ONOS1);
            this.nodeStates.put(NID1, ControllerNode.State.ACTIVE);
            this.nodes.put(NID2, ONOS2);
            this.nodeStates.put(NID2, ControllerNode.State.ACTIVE);
        }
    }
}

