/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.ConsistentResourceStore;
import org.onosproject.store.resource.impl.DiscreteResources;
import org.onosproject.store.resource.impl.GenericDiscreteResources;
import org.onosproject.store.service.Serializer;

public class GenericDiscreteResourcesTest {
    private final Serializer serializer = ConsistentResourceStore.SERIALIZER;

    @Test
    public void testIfResourceIsFound() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.lookup(res1.id()), (Matcher)Matchers.is(Optional.of(res1)));
    }

    @Test
    public void testIfResourceIsNotFound() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.lookup(res2.id()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    public void testIfDifferenceIsEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources other = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources expected = GenericDiscreteResources.of((Set)ImmutableSet.of());
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testIfDifferenceIsNotEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources other = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources expected = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testIfDifferenceIsNotChanged() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources other = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        DiscreteResources expected = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testDifferenceFromEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources other = GenericDiscreteResources.of((Set)ImmutableSet.of());
        DiscreteResources expected = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.difference(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testEmpty() {
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of());
        Assert.assertThat((Object)sut.isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testNotEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.isEmpty(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIfResourceIsContained() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.containsAny((Set)ImmutableSet.of((Object)res1)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testIfResourceIsNotContained() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.containsAny((Set)ImmutableSet.of((Object)res2)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testContainsWithEmpty() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        Assert.assertThat((Object)sut.containsAny((Set)ImmutableSet.of()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAdd() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources other = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        DiscreteResources expected = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        Assert.assertThat((Object)sut.add(other), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testValues() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources sut = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        Assert.assertThat((Object)sut.values(), (Matcher)Matchers.is((Object)ImmutableSet.of((Object)res1, (Object)res2)));
    }

    @Test
    public void testDifferenceSerializable() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources set1 = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1, (Object)res2));
        DiscreteResources set2 = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources difference = set1.difference(set2);
        Assert.assertThat((Object)this.serializer.decode(this.serializer.encode((Object)difference)), (Matcher)Matchers.is((Object)difference));
    }

    @Test
    public void testAddSerializable() {
        DiscreteResource res1 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"a")).resource();
        DiscreteResource res2 = Resources.discrete((DeviceId)DeviceId.deviceId((String)"b")).resource();
        DiscreteResources set1 = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res1));
        DiscreteResources set2 = GenericDiscreteResources.of((Set)ImmutableSet.of((Object)res2));
        DiscreteResources add = set1.add(set2);
        Assert.assertThat((Object)this.serializer.decode(this.serializer.encode((Object)add)), (Matcher)Matchers.is((Object)add));
    }
}

