/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DeviceId;
import org.onosproject.net.OchSignal;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.Codecs;

public class CodecsTest {
    private static final DeviceId DID = DeviceId.deviceId((String)"a");
    private static final PortNumber PN = PortNumber.portNumber((long)1L);
    private static final VlanId VLAN = VlanId.vlanId((short)1);
    private static final MplsLabel MPLS = MplsLabel.mplsLabel((int)1);
    private static final OchSignal OCH = OchSignal.newDwdmSlot((ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)1);
    private Codecs sut;

    @Before
    public void setUp() {
        this.sut = Codecs.getInstance();
    }

    @Test
    public void isVlanEncodable() {
        DiscreteResource resource = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{VLAN}).resource();
        Assert.assertThat((Object)this.sut.isEncodable(resource), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isMplsEncodable() {
        DiscreteResource resource = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{MPLS}).resource();
        Assert.assertThat((Object)this.sut.isEncodable(resource), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void isRootNonEncodable() {
        DiscreteResource resource = Resource.ROOT;
        Assert.assertThat((Object)this.sut.isEncodable(resource), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void isOchNonEncodable() {
        DiscreteResource resource = Resources.discrete((DeviceId)DID, (PortNumber)PN, (Object[])new Object[]{OCH}).resource();
        Assert.assertThat((Object)this.sut.isEncodable(resource), (Matcher)Matchers.is((Object)false));
    }
}

