/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.resource.impl;

import com.google.common.collect.ImmutableList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.Resources;
import org.onosproject.store.resource.impl.ContinuousResourceAllocation;

public class ContinuousResourceAllocationTest {
    private static final DeviceId DID = DeviceId.deviceId((String)"a");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);

    @Test
    public void testNoAllocationHasEnoughResource() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResourceAllocation sut = ContinuousResourceAllocation.empty((ContinuousResource)original);
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)100L).bps());
        Assert.assertThat((Object)sut.hasEnoughResource(request), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHasEnoughResourceWhenSmallResourceIsRequested() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)200L).bps());
        Assert.assertThat((Object)sut.hasEnoughResource(request), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testHasEnoughResourceWhenLargeResourceIsRequested() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)600L).bps());
        Assert.assertThat((Object)sut.hasEnoughResource(request), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testHasEnoughResourceWhenExactResourceIsRequested() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        Assert.assertThat((Object)sut.hasEnoughResource(request), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testReleaseWhenAllocatedResourceIsRequested() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        ContinuousResourceAllocation released = sut.release(request, consumer.consumerId());
        Assert.assertThat((Object)released.allocations().isEmpty(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testReleaseWhenDifferentConsumerIsSpecified() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        IntentId otherConsumer = IntentId.valueOf((long)2L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        ImmutableList allocations = sut.release(request, otherConsumer.consumerId()).allocations();
        Assert.assertThat((Object)allocations.size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)((ResourceAllocation)allocations.get(0)).resource().equals(allocated), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAllocateDifferentValue() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)500L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)200L).bps());
        ContinuousResourceAllocation newValue = sut.allocate(new ResourceAllocation((Resource)request, (ResourceConsumer)consumer));
        Assert.assertThat((Object)newValue.allocations().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)newValue.allocations(), (Matcher)Matchers.hasItem((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        Assert.assertThat((Object)newValue.allocations(), (Matcher)Matchers.hasItem((Object)new ResourceAllocation((Resource)request, (ResourceConsumer)consumer)));
    }

    @Test
    public void testAllocateSameValue() {
        ContinuousResource original = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.gbps((long)1L).bps());
        ContinuousResource allocated = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)300L).bps());
        IntentId consumer = IntentId.valueOf((long)1L);
        ContinuousResourceAllocation sut = new ContinuousResourceAllocation(original, ImmutableList.of((Object)new ResourceAllocation((Resource)allocated, (ResourceConsumer)consumer)));
        ContinuousResource request = Resources.continuous((DeviceId)DID, (PortNumber)PN1, Bandwidth.class).resource(Bandwidth.mbps((long)300L).bps());
        ContinuousResourceAllocation newValue = sut.allocate(new ResourceAllocation((Resource)request, (ResourceConsumer)consumer));
        Assert.assertThat((Object)newValue.allocations().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)newValue.allocations().stream().allMatch(arg_0 -> ContinuousResourceAllocationTest.lambda$testAllocateSameValue$0(allocated, (ResourceConsumer)consumer, arg_0)), (Matcher)Matchers.is((Object)true));
    }

    private static /* synthetic */ boolean lambda$testAllocateSameValue$0(ContinuousResource allocated, ResourceConsumer consumer, ResourceAllocation x) {
        return x.equals((Object)new ResourceAllocation((Resource)allocated, consumer));
    }
}

