/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.flowobjective.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onlab.util.Tools;
import org.onosproject.event.Event;
import org.onosproject.net.behaviour.DefaultNextGroup;
import org.onosproject.net.behaviour.NextGroup;
import org.onosproject.net.flowobjective.FlowObjectiveStore;
import org.onosproject.net.flowobjective.FlowObjectiveStoreDelegate;
import org.onosproject.net.flowobjective.ObjectiveEvent;
import org.onosproject.store.AbstractStore;
import org.onosproject.store.service.AtomicCounter;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.MapEvent;
import org.onosproject.store.service.MapEventListener;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedFlowObjectiveStore
extends AbstractStore<ObjectiveEvent, FlowObjectiveStoreDelegate>
implements FlowObjectiveStore {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ConsistentMap<Integer, byte[]> nextGroups;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private AtomicCounter nextIds;
    private MapEventListener<Integer, byte[]> mapListener = new NextGroupListener();
    private BlockingQueue<ObjectiveEvent> eventQ;
    private ExecutorService tpool;

    @Activate
    public void activate() {
        this.tpool = Executors.newFixedThreadPool(4, Tools.groupedThreads((String)"onos/flobj-notifier", (String)"%d", (Logger)this.log));
        this.eventQ = new LinkedBlockingQueue<ObjectiveEvent>();
        this.tpool.execute(new FlowObjectiveNotifier());
        this.nextGroups = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-flowobjective-groups")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(new Class[]{byte[].class}).register(new Class[]{Versioned.class}).build("DistributedFlowObjectiveStore")))).build();
        this.nextGroups.addListener(this.mapListener);
        this.nextIds = this.storageService.getAtomicCounter("next-objective-counter");
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.nextGroups.removeListener(this.mapListener);
        this.tpool.shutdown();
        this.log.info("Stopped");
    }

    public void putNextGroup(Integer nextId, NextGroup group) {
        this.nextGroups.put((Object)nextId, (Object)group.data());
    }

    public NextGroup getNextGroup(Integer nextId) {
        Versioned versionGroup = this.nextGroups.get((Object)nextId);
        if (versionGroup != null) {
            return new DefaultNextGroup((byte[])versionGroup.value());
        }
        return null;
    }

    public NextGroup removeNextGroup(Integer nextId) {
        Versioned versionGroup = this.nextGroups.remove((Object)nextId);
        if (versionGroup != null) {
            return new DefaultNextGroup((byte[])versionGroup.value());
        }
        return null;
    }

    public Map<Integer, NextGroup> getAllGroups() {
        HashMap<Integer, NextGroup> nextGroupMappings = new HashMap<Integer, NextGroup>();
        Iterator iterator = this.nextGroups.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            NextGroup nextGroup = this.getNextGroup(key);
            if (nextGroup == null) continue;
            nextGroupMappings.put(key, nextGroup);
        }
        return nextGroupMappings;
    }

    public int allocateNextId() {
        return (int)this.nextIds.incrementAndGet();
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class NextGroupListener
    implements MapEventListener<Integer, byte[]> {
        private NextGroupListener() {
        }

        public void event(MapEvent<Integer, byte[]> event) {
            switch (event.type()) {
                case INSERT: {
                    DistributedFlowObjectiveStore.this.eventQ.add(new ObjectiveEvent(ObjectiveEvent.Type.ADD, (Integer)event.key()));
                    break;
                }
                case REMOVE: {
                    DistributedFlowObjectiveStore.this.eventQ.add(new ObjectiveEvent(ObjectiveEvent.Type.REMOVE, (Integer)event.key()));
                    break;
                }
                case UPDATE: {
                    break;
                }
            }
        }
    }

    private class FlowObjectiveNotifier
    implements Runnable {
        private FlowObjectiveNotifier() {
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    DistributedFlowObjectiveStore.this.notifyDelegate((Event)DistributedFlowObjectiveStore.this.eventQ.take());
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

